/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.actions;

import com.google.common.base.Strings;
import com.google.gwt.user.client.TakesValue;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.common.client.dom.Window;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.cm.client.actions.CaseActionsPresenter;
import org.jbpm.workbench.cm.client.util.AbstractView;
import org.jbpm.workbench.cm.client.util.DateConverter;
import org.jbpm.workbench.cm.model.CaseActionSummary;
import org.jbpm.workbench.cm.util.CaseActionStatus;
import org.jbpm.workbench.cm.util.CaseActionType;

@Dependent
@Templated
public class CaseActionItemView
extends AbstractView<CaseActionsPresenter>
implements TakesValue<CaseActionSummary>,
IsElement {
    @Inject
    protected TranslationService translationService;
    @Inject
    @DataField(value="action-name")
    @Bound
    Span name;
    @Inject
    @DataField(value="action-info")
    Span actionInfo;
    @Inject
    @DataField(value="action-createdOn")
    @Bound(converter=DateConverter.class)
    Span createdOn;
    @Inject
    @DataField(value="list-group-item")
    Div listGroupItem;
    @Inject
    @DataField(value="actions-dropdown")
    Div actions;
    @Inject
    @DataField(value="actions-items")
    UnorderedList actionsItems;
    @Inject
    @AutoBound
    private DataBinder<CaseActionSummary> caseActionSummary;

    public HTMLElement getElement() {
        return this.listGroupItem;
    }

    public CaseActionSummary getValue() {
        return (CaseActionSummary)this.caseActionSummary.getModel();
    }

    public void setValue(CaseActionSummary model) {
        this.caseActionSummary.setModel((Object)model);
        DOMUtil.removeCSSClass((HTMLElement)this.actions, (String)"dropup");
        CaseActionType actionType = model.getActionType();
        CaseActionStatus actionStatus = model.getActionStatus();
        switch (actionStatus) {
            case AVAILABLE: {
                this.prepareAction(model, actionType);
                break;
            }
            case IN_PROGRESS: {
                DOMUtil.removeCSSClass((HTMLElement)this.createdOn, (String)"hidden");
                if (Strings.isNullOrEmpty((String)model.getActualOwner())) break;
                this.actionInfo.setTextContent(" (" + model.getActualOwner() + ") ");
                break;
            }
            case COMPLETED: {
                DOMUtil.removeCSSClass((HTMLElement)this.createdOn, (String)"hidden");
            }
        }
    }

    private void prepareAction(final CaseActionSummary model, final CaseActionType actionType) {
        switch (actionType) {
            case AD_HOC_TASK: {
                if (Strings.isNullOrEmpty((String)model.getStageId())) {
                    this.actionInfo.setTextContent(this.translationService.format("AvailableIn", new Object[0]) + ": " + this.translationService.format("Case", new Object[0]));
                } else {
                    this.actionInfo.setTextContent(this.translationService.format("AvailableIn", new Object[0]) + ": " + model.getStageId());
                }
                this.addAction(new CaseActionsPresenter.CaseActionAction(){

                    @Override
                    public String label() {
                        return CaseActionItemView.this.translationService.format("ActionStart", new Object[0]);
                    }

                    public void execute() {
                        if (Strings.isNullOrEmpty((String)model.getStageId())) {
                            ((CaseActionsPresenter)CaseActionItemView.this.presenter).triggerAdHocAction(model.getName());
                        } else {
                            ((CaseActionsPresenter)CaseActionItemView.this.presenter).triggerAdHocActionInStage(model.getName(), model.getStageId());
                        }
                    }
                });
                break;
            }
            case DYNAMIC_SUBPROCESS_TASK: 
            case DYNAMIC_USER_TASK: {
                this.actionInfo.setTextContent(this.translationService.format("Dynamic", new Object[0]));
                this.addAction(new CaseActionsPresenter.CaseActionAction(){

                    @Override
                    public String label() {
                        return CaseActionItemView.this.translationService.format("ActionStart", new Object[0]);
                    }

                    public void execute() {
                        ((CaseActionsPresenter)CaseActionItemView.this.presenter).showDynamicAction(actionType);
                    }
                });
            }
        }
    }

    private void addAction(CaseActionsPresenter.CaseActionAction action) {
        DOMUtil.removeCSSClass((HTMLElement)this.actions, (String)"hidden");
        HTMLElement a = Window.getDocument().createElement("a");
        a.setTextContent(action.label());
        a.setOnclick(e -> action.execute());
        HTMLElement li = Window.getDocument().createElement("li");
        li.appendChild((Node)a);
        this.actionsItems.appendChild((Node)li);
    }

    public void setLastElementStyle() {
        DOMUtil.addCSSClass((HTMLElement)this.actions, (String)"dropup");
    }
}

