/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.roles;

import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.databinding.client.components.ListComponent;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.cm.client.events.CaseRoleAssignmentListLoadEvent;
import org.jbpm.workbench.cm.client.pagination.PaginationViewImpl;
import org.jbpm.workbench.cm.client.roles.CaseRoleItemView;
import org.jbpm.workbench.cm.client.roles.CaseRolesPresenter;
import org.jbpm.workbench.cm.client.util.AbstractView;
import org.jbpm.workbench.cm.client.util.CaseRolesAssignmentFilterBy;
import org.jbpm.workbench.cm.model.CaseRoleAssignmentSummary;
import org.uberfire.client.views.pfly.widgets.Select;

@Dependent
@Templated
public class CaseRolesViewImpl
extends AbstractView<CaseRolesPresenter>
implements CaseRolesPresenter.CaseRolesView,
PaginationViewImpl.PageList<CaseRoleAssignmentSummary> {
    public static int PAGE_SIZE = 2;
    @Inject
    @DataField(value="roles-badge")
    Span rolesBadge;
    @Inject
    @DataField(value="roles")
    private Div rolesContainer;
    @Inject
    @DataField(value="filter-select")
    private Select filterSelect;
    @Inject
    @DataField(value="scrollbox")
    private Div scrollbox;
    @Inject
    @DataField(value="empty-list-item")
    private Div emptyContainer;
    @Inject
    @DataField(value="pagination")
    private PaginationViewImpl pagination;
    @Inject
    private TranslationService translationService;
    @Inject
    @Bound
    @DataField(value="role-list")
    private ListComponent<CaseRoleAssignmentSummary, CaseRoleItemView> roleAssignments;
    @Inject
    @AutoBound
    private DataBinder<List<CaseRoleAssignmentSummary>> caseRolesList;
    private Event<CaseRoleAssignmentListLoadEvent> roleAssignmentListLoadEvent;

    @Inject
    public void setRoleAssignmentListLoadEvent(Event<CaseRoleAssignmentListLoadEvent> roleAssignmentListLoadEvent) {
        this.roleAssignmentListLoadEvent = roleAssignmentListLoadEvent;
    }

    @Override
    public void init(CaseRolesPresenter presenter) {
        this.presenter = presenter;
        this.roleAssignments.addComponentCreationHandler(v -> v.init(presenter));
    }

    @PostConstruct
    public void init() {
        for (CaseRolesAssignmentFilterBy filterBy : CaseRolesAssignmentFilterBy.values()) {
            this.filterSelect.addOption(this.translationService.format(filterBy.getLabel(), new Object[0]), filterBy.getLabel());
        }
        this.filterSelect.refresh();
        this.tooltip((HTMLElement)this.rolesBadge);
        this.rolesBadge.setAttribute("data-original-title", this.translationService.format("TotalNumberOfRoles", new Object[0]));
    }

    @Override
    public void setRolesAssignmentList(List<CaseRoleAssignmentSummary> caseRoleAssignmentSummaryList) {
        if (caseRoleAssignmentSummaryList.isEmpty()) {
            DOMUtil.removeCSSClass((HTMLElement)this.emptyContainer, (String)"hidden");
        } else {
            DOMUtil.addCSSClass((HTMLElement)this.emptyContainer, (String)"hidden");
        }
        this.pagination.init(caseRoleAssignmentSummaryList, this, PAGE_SIZE);
    }

    @Override
    public void removeAllRoles() {
        this.roleAssignments.deselectAll();
        this.caseRolesList.setModel(Collections.emptyList());
    }

    @Override
    public String getFilterValue() {
        return this.filterSelect.getValue();
    }

    @Override
    public void resetPagination() {
        this.pagination.setCurrentPage(0);
    }

    @Override
    public void setBadge(String badgeContent) {
        this.rolesBadge.setTextContent(badgeContent);
    }

    @Override
    public void setVisibleItems(List<CaseRoleAssignmentSummary> visibleItems) {
        this.removeAllRoles();
        this.caseRolesList.setModel(visibleItems);
        int maxWidth = this.scrollbox.getBoundingClientRect().getWidth().intValue() - 70;
        this.roleAssignmentListLoadEvent.fire((Object)new CaseRoleAssignmentListLoadEvent(maxWidth));
        int rolesListSize = visibleItems.size();
        if (rolesListSize > 0) {
            ((CaseRoleItemView)this.roleAssignments.getComponent(rolesListSize - 1)).setLastElementStyle();
        }
    }

    @Override
    public Div getScrollBox() {
        return this.scrollbox;
    }

    @EventHandler(value={"filter-select"})
    public void onRolesAssignmentFilterChange(@ForEvent(value={"change"}) org.jboss.errai.common.client.dom.Event e) {
        this.resetPagination();
        ((CaseRolesPresenter)this.presenter).filterElements();
    }

    public HTMLElement getElement() {
        return this.rolesContainer;
    }
}

