/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.actions;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.cm.client.actions.CaseActionItemView;
import org.jbpm.workbench.cm.client.util.AbstractCaseInstancePresenter;
import org.jbpm.workbench.cm.model.CaseActionSummary;
import org.jbpm.workbench.cm.model.CaseInstanceSummary;
import org.jbpm.workbench.cm.model.CaseStageSummary;
import org.jbpm.workbench.cm.model.ProcessDefinitionSummary;
import org.jbpm.workbench.cm.predicate.HumanTaskNodePredicate;
import org.jbpm.workbench.cm.predicate.MilestoneNodePredicate;
import org.jbpm.workbench.cm.predicate.SubProcessNodePredicate;
import org.jbpm.workbench.cm.service.CaseManagementService;
import org.jbpm.workbench.cm.util.CaseActionStatus;
import org.jbpm.workbench.cm.util.CaseActionType;
import org.jbpm.workbench.cm.util.CaseStageStatus;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.mvp.Command;

@Dependent
@WorkbenchScreen(identifier="Case Actions")
public class CaseActionsPresenter
extends AbstractCaseInstancePresenter<CaseActionsView> {
    public static final String SCREEN_ID = "Case Actions";
    private final Map<String, ProcessDefinitionSummary> processDefinitionSummaryMap = new HashMap<String, ProcessDefinitionSummary>();
    @Inject
    private User identity;
    @Inject
    private NewActionView newActionView;

    @WorkbenchPartTitle
    public String getTitle() {
        return this.translationService.format("CaseActions", new Object[0]);
    }

    Map<String, ProcessDefinitionSummary> getProcessDefinitionSummaryMap() {
        return this.processDefinitionSummaryMap;
    }

    @Override
    protected void clearCaseInstance() {
        ((CaseActionsView)this.view).removeAllTasks();
        this.newActionView.clearAllStages();
        this.newActionView.clearAllProcessDefinitions();
    }

    @Override
    protected void loadCaseInstance(CaseInstanceSummary cis) {
        ((CaseActionsView)this.view).updateListHeaders();
        this.setCaseStagesList(cis.getStages());
        this.processDefinitionSummaryMap.clear();
        ((CaseManagementService)this.caseService.call(processDefinitionSummaries -> {
            ArrayList<String> processDefinitionNames = new ArrayList<String>();
            for (ProcessDefinitionSummary processDefinitionSummary : processDefinitionSummaries) {
                processDefinitionNames.add(processDefinitionSummary.getName());
                this.processDefinitionSummaryMap.put(processDefinitionSummary.getName(), processDefinitionSummary);
            }
            Collections.sort(processDefinitionNames);
            this.newActionView.setProcessDefinitions(processDefinitionNames);
        })).getProcessDefinitions(this.containerId);
        this.refreshData(true);
    }

    void setCaseStagesList(List<CaseStageSummary> caseStagesList) {
        this.newActionView.addStages(caseStagesList.stream().filter(s -> s.getStatus().equals(CaseStageStatus.ACTIVE.getStatus())).collect(Collectors.toList()));
    }

    protected void setNewDynamicAction(CaseActionType caseActionType) {
        switch (caseActionType) {
            case DYNAMIC_USER_TASK: {
                this.newActionView.show(caseActionType, () -> this.addDynamicUserTaskAction(this.newActionView.getTaskName(), this.newActionView.getDescription(), this.newActionView.getActors(), this.newActionView.getGroups(), this.newActionView.getStageId()));
                break;
            }
            case DYNAMIC_SUBPROCESS_TASK: {
                this.newActionView.show(caseActionType, () -> this.addDynamicSubprocessTaskAction(this.newActionView.getProcessDefinitionName(), this.newActionView.getStageId()));
            }
        }
    }

    protected void addDynamicUserTaskAction(String taskName, String taskDescription, String actors, String groups, String stageId) {
        if (Strings.isNullOrEmpty((String)stageId)) {
            ((CaseManagementService)this.caseService.call(r -> this.refreshData(false))).addDynamicUserTask(this.containerId, this.caseId, taskName, taskDescription, actors, groups, null);
        } else {
            ((CaseManagementService)this.caseService.call(r -> this.refreshData(false))).addDynamicUserTaskToStage(this.containerId, this.caseId, stageId, taskName, taskDescription, actors, groups, null);
        }
    }

    protected void addDynamicSubprocessTaskAction(String caseDefinitionName, String stageId) {
        ProcessDefinitionSummary processDefinitionSummary = this.processDefinitionSummaryMap.get(caseDefinitionName);
        if (Strings.isNullOrEmpty((String)stageId)) {
            ((CaseManagementService)this.caseService.call(r -> this.refreshData(false))).addDynamicSubProcess(this.containerId, this.caseId, processDefinitionSummary.getId(), null);
        } else {
            ((CaseManagementService)this.caseService.call(r -> this.refreshData(false))).addDynamicSubProcessToStage(this.containerId, this.caseId, stageId, processDefinitionSummary.getId(), null);
        }
    }

    protected void triggerAdHocAction(String actionName) {
        ((CaseManagementService)this.caseService.call(r -> this.refreshData(false))).triggerAdHocAction(this.containerId, this.caseId, actionName, null);
    }

    protected void triggerAdHocActionInStage(String actionName, String stageId) {
        ((CaseManagementService)this.caseService.call(r -> this.refreshData(false))).triggerAdHocActionInStage(this.containerId, this.caseId, stageId, actionName, null);
    }

    protected void refreshData(boolean refreshAvailableActions) {
        ((CaseManagementService)this.caseService.call(actions -> {
            if (refreshAvailableActions) {
                ArrayList<CaseActionSummary> availableActions = new ArrayList<CaseActionSummary>();
                availableActions.add(CaseActionSummary.builder().name(this.translationService.getTranslation("NewUserTask")).actionType(CaseActionType.DYNAMIC_USER_TASK).actionStatus(CaseActionStatus.AVAILABLE).build());
                availableActions.add(CaseActionSummary.builder().name(this.translationService.getTranslation("NewProcessTask")).actionType(CaseActionType.DYNAMIC_SUBPROCESS_TASK).actionStatus(CaseActionStatus.AVAILABLE).build());
                availableActions.addAll(actions.getAvailableActions());
                ((CaseActionsView)this.view).setAvailableActionsList(availableActions);
            }
            ((CaseActionsView)this.view).setInProgressActionsList(actions.getInProgressAction());
            ((CaseActionsView)this.view).setCompletedActionsList(actions.getCompleteActions());
        })).getCaseActions(this.serverTemplateId, this.containerId, this.caseId, this.identity.getIdentifier());
    }

    void setAction(CaseActionItemView caseActionItem) {
        CaseActionSummary caseActionItemModel = caseActionItem.getValue();
        switch (caseActionItemModel.getActionStatus()) {
            case AVAILABLE: {
                this.prepareAction(caseActionItem);
                break;
            }
            case IN_PROGRESS: {
                caseActionItem.addCreationDate();
                String nodeLabel = this.getNodeTypeLabel(caseActionItemModel);
                String actionOwner = caseActionItemModel.getActualOwner();
                if (!Strings.isNullOrEmpty((String)actionOwner) && !Strings.isNullOrEmpty((String)nodeLabel)) {
                    caseActionItem.addActionInfo(" ( " + nodeLabel + " - " + actionOwner + " ) ");
                    break;
                }
                if (Strings.isNullOrEmpty((String)nodeLabel)) break;
                caseActionItem.addActionInfo(" ( " + nodeLabel + " ) ");
                break;
            }
            case COMPLETED: {
                String nodeLabel = this.getNodeTypeLabel(caseActionItemModel);
                if (!Strings.isNullOrEmpty((String)nodeLabel)) {
                    caseActionItem.addActionInfo(" ( " + nodeLabel + " ) ");
                }
                caseActionItem.addCreationDate();
            }
        }
    }

    protected String getNodeTypeLabel(CaseActionSummary action) {
        if (new HumanTaskNodePredicate().test(action.getType())) {
            return this.translationService.format("HumanTask", new Object[0]);
        }
        if (new MilestoneNodePredicate().test(action.getType())) {
            return this.translationService.format("Milestone", new Object[0]);
        }
        if (new SubProcessNodePredicate().test(action.getType())) {
            return this.translationService.format("SubProcess", new Object[0]);
        }
        return null;
    }

    void prepareAction(CaseActionItemView caseActionItem) {
        final CaseActionSummary caseActionItemModel = caseActionItem.getValue();
        switch (caseActionItemModel.getActionType()) {
            case AD_HOC_TASK: {
                if (caseActionItemModel.getStage() == null) {
                    caseActionItem.addActionInfo(this.translationService.format("AvailableIn", new Object[0]) + ": " + this.translationService.format("Case", new Object[0]));
                } else {
                    caseActionItem.addActionInfo(this.translationService.format("AvailableIn", new Object[0]) + ": " + caseActionItemModel.getStage().getName());
                }
                caseActionItem.addAction(new CaseActionAction(){

                    @Override
                    public String label() {
                        return CaseActionsPresenter.this.translationService.format("ActionStart", new Object[0]);
                    }

                    public void execute() {
                        if (caseActionItemModel.getStage() == null) {
                            CaseActionsPresenter.this.triggerAdHocAction(caseActionItemModel.getName());
                        } else {
                            CaseActionsPresenter.this.triggerAdHocActionInStage(caseActionItemModel.getName(), caseActionItemModel.getStage().getIdentifier());
                        }
                    }
                });
                break;
            }
            case DYNAMIC_USER_TASK: 
            case DYNAMIC_SUBPROCESS_TASK: {
                caseActionItem.addActionInfo(this.translationService.format("Dynamic", new Object[0]));
                caseActionItem.addAction(new CaseActionAction(){

                    @Override
                    public String label() {
                        return CaseActionsPresenter.this.translationService.format("ActionStart", new Object[0]);
                    }

                    public void execute() {
                        CaseActionsPresenter.this.setNewDynamicAction(caseActionItemModel.getActionType());
                    }
                });
            }
        }
    }

    public static interface CaseActionAction
    extends Command {
        public String label();
    }

    public static interface NewActionView
    extends UberElement<CaseActionsPresenter> {
        public void show(CaseActionType var1, Command var2);

        public void hide();

        public String getTaskName();

        public String getDescription();

        public String getProcessDefinitionName();

        public String getActors();

        public String getGroups();

        public void addStages(List<CaseStageSummary> var1);

        public String getStageId();

        public void clearAllStages();

        public void setProcessDefinitions(List<String> var1);

        public void clearAllProcessDefinitions();
    }

    public static interface CaseActionsListView
    extends UberElement<CaseActionsPresenter> {
        public void removeAllTasks();

        public void setCaseActionList(List<CaseActionSummary> var1);

        public void updateActionsHeader(String var1, String ... var2);
    }

    public static interface CaseActionsView
    extends UberElement<CaseActionsPresenter> {
        public void removeAllTasks();

        public void setAvailableActionsList(List<CaseActionSummary> var1);

        public void setInProgressActionsList(List<CaseActionSummary> var1);

        public void setCompletedActionsList(List<CaseActionSummary> var1);

        public void updateListHeaders();
    }
}

