/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.list;

import com.google.gwt.user.client.TakesValue;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.workbench.cm.client.events.CaseCreatedEvent;
import org.jbpm.workbench.cm.client.newcase.NewCaseInstancePresenter;
import org.jbpm.workbench.cm.client.util.AbstractPresenter;
import org.jbpm.workbench.cm.model.CaseInstanceSummary;
import org.jbpm.workbench.cm.service.CaseManagementService;
import org.jbpm.workbench.cm.util.CaseInstanceSearchRequest;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@Dependent
@WorkbenchScreen(identifier="Case List")
public class CaseInstanceListPresenter
extends AbstractPresenter<CaseInstanceListView> {
    public static final String SCREEN_ID = "Case List";
    private Caller<CaseManagementService> caseService;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private TranslationService translationService;
    @Inject
    private NewCaseInstancePresenter newCaseInstancePresenter;

    @WorkbenchPartTitle
    public String getTitle() {
        return this.translationService.format("CaseList", new Object[0]);
    }

    @Override
    public void init() {
        super.init();
        ((CaseInstanceListView)this.view).setValue(new CaseInstanceSearchRequest());
        this.refreshData();
    }

    public void createCaseInstance() {
        this.newCaseInstancePresenter.show();
    }

    protected void refreshData() {
        ((CaseManagementService)this.caseService.call(cases -> ((CaseInstanceListView)this.view).setCaseInstanceList((List<CaseInstanceSummary>)cases))).getCaseInstances((CaseInstanceSearchRequest)((CaseInstanceListView)this.view).getValue());
    }

    protected void selectCaseInstance(CaseInstanceSummary cis) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serverTemplateId", "");
        parameters.put("containerId", cis.getContainerId());
        parameters.put("caseId", cis.getCaseId());
        DefaultPlaceRequest overview = new DefaultPlaceRequest("CaseOverview", parameters);
        this.placeManager.goTo((PlaceRequest)overview);
    }

    protected void cancelCaseInstance(CaseInstanceSummary caseInstanceSummary) {
        ((CaseManagementService)this.caseService.call(e -> this.refreshData())).cancelCaseInstance(null, caseInstanceSummary.getContainerId(), caseInstanceSummary.getCaseId());
    }

    protected void closeCaseInstance(CaseInstanceSummary caseInstanceSummary) {
        ((CaseManagementService)this.caseService.call(e -> this.refreshData())).closeCaseInstance(caseInstanceSummary.getContainerId(), caseInstanceSummary.getCaseId(), null);
    }

    public void onCaseCreatedEvent(@Observes CaseCreatedEvent event) {
        this.refreshData();
    }

    protected void searchCaseInstances() {
        this.refreshData();
    }

    @Inject
    public void setCaseService(Caller<CaseManagementService> caseService) {
        this.caseService = caseService;
    }

    public static interface CaseInstanceListView
    extends UberElement<CaseInstanceListPresenter>,
    TakesValue<CaseInstanceSearchRequest> {
        public void setCaseInstanceList(List<CaseInstanceSummary> var1);
    }
}

