/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.databinding.client.components.ListComponent;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.cm.client.actions.CaseActionItemView;
import org.jbpm.workbench.cm.client.actions.CaseActionsPresenter;
import org.jbpm.workbench.cm.client.pagination.PaginationViewImpl;
import org.jbpm.workbench.cm.client.util.AbstractView;
import org.jbpm.workbench.cm.model.CaseActionSummary;

@Dependent
@Templated
public class CaseActionsListViewImpl
extends AbstractView<CaseActionsPresenter>
implements CaseActionsPresenter.CaseActionsListView,
PaginationViewImpl.PageList<CaseActionSummary> {
    private static int PAGE_SIZE = 3;
    @Inject
    @DataField(value="simple-list")
    private Div simpleList;
    @Inject
    @DataField(value="actions-list-header-image")
    private Span actionsListHeaderImage;
    @Inject
    @DataField(value="actions-list-header-text")
    private Span actionsListHeaderText;
    @Inject
    @DataField(value="actions-list-header-counter")
    private Span actionsListHeaderCounter;
    @Inject
    @DataField(value="empty-list-item")
    private Div emptyContainer;
    @Inject
    @DataField(value="pagination")
    private PaginationViewImpl pagination;
    @Inject
    @DataField(value="scrollbox")
    private Div scrollbox;
    @Inject
    @Bound
    @DataField(value="actions-list")
    private ListComponent<CaseActionSummary, CaseActionItemView> tasks;
    @Inject
    @AutoBound
    private DataBinder<List<CaseActionSummary>> caseActionList;

    @Override
    public void init(CaseActionsPresenter presenter) {
        this.presenter = presenter;
        this.tasks.addComponentCreationHandler(v -> v.init(presenter));
    }

    @Override
    public void setCaseActionList(List<CaseActionSummary> caseActionList) {
        this.pagination.init(caseActionList, this, PAGE_SIZE);
        if (caseActionList.isEmpty()) {
            DOMUtil.removeCSSClass((HTMLElement)this.emptyContainer, (String)"hidden");
        } else {
            DOMUtil.addCSSClass((HTMLElement)this.emptyContainer, (String)"hidden");
        }
        this.actionsListHeaderCounter.setTextContent(String.valueOf(caseActionList.size()));
    }

    @Override
    public void removeAllTasks() {
        this.caseActionList.setModel(new ArrayList());
    }

    @Override
    public void updateActionsHeader(String heatherText, String ... stylesClass) {
        this.actionsListHeaderText.setTextContent(heatherText);
        for (String styleClass : stylesClass) {
            DOMUtil.addCSSClass((HTMLElement)this.actionsListHeaderImage, (String)styleClass);
        }
    }

    @Override
    public void setVisibleItems(List<CaseActionSummary> visibleItems) {
        this.caseActionList.setModel(visibleItems);
        this.setActions(visibleItems);
        int tasksSize = visibleItems.size();
        if (tasksSize > 1) {
            ((CaseActionItemView)this.tasks.getComponent(tasksSize - 1)).setLastElementStyle();
        }
    }

    private void setActions(List<CaseActionSummary> visibleItems) {
        List<CaseActionItemView> caseActionItemViews = visibleItems.stream().map(task -> this.tasks.getComponent(task)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        caseActionItemViews.forEach(action -> ((CaseActionsPresenter)this.presenter).setAction((CaseActionItemView)action));
    }

    @Override
    public Div getScrollBox() {
        return this.scrollbox;
    }

    public HTMLElement getElement() {
        return this.simpleList;
    }
}

