/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.comments;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.cm.client.util.AbstractCaseInstancePresenter;
import org.jbpm.workbench.cm.model.CaseCommentSummary;
import org.jbpm.workbench.cm.model.CaseInstanceSummary;
import org.jbpm.workbench.cm.service.CaseManagementService;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.mvp.Command;

@Dependent
@WorkbenchScreen(identifier="Case Comments")
public class CaseCommentsPresenter
extends AbstractCaseInstancePresenter<CaseCommentsView> {
    public static final String SCREEN_ID = "Case Comments";
    @Inject
    User identity;
    boolean sortAsc = false;
    int currentPage = 0;
    public static final int PAGE_SIZE = 20;
    List<CaseCommentSummary> visibleComments = new ArrayList<CaseCommentSummary>();

    public int getPageSize() {
        return 20;
    }

    public void setCurrentPage(int i) {
        this.currentPage = i;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    @WorkbenchPartTitle
    public String getTittle() {
        return this.translationService.format("Comments", new Object[0]);
    }

    @Override
    protected void clearCaseInstance() {
    }

    @Override
    protected void loadCaseInstance(CaseInstanceSummary cis) {
        this.refreshComments();
    }

    private void commentsServiceCall(int currentPage) {
        ((CaseManagementService)this.caseService.call(comments -> {
            this.visibleComments.addAll((Collection<CaseCommentSummary>)comments);
            if (comments.size() < 20) {
                ((CaseCommentsView)this.view).hideLoadButton();
            }
            ((CaseCommentsView)this.view).setCaseCommentList(this.visibleComments.stream().sorted(this.sortAsc ? Comparator.comparing(CaseCommentSummary::getAddedAt) : Comparator.comparing(CaseCommentSummary::getAddedAt).reversed()).collect(Collectors.toList()));
        })).getComments(this.containerId, this.caseId, Integer.valueOf(currentPage), Integer.valueOf(20));
    }

    public void refreshComments() {
        ((CaseCommentsView)this.view).clearCommentInputForm();
        this.visibleComments.clear();
        this.commentsServiceCall(this.currentPage);
    }

    public void loadMoreCaseComments() {
        ++this.currentPage;
        this.commentsServiceCall(this.currentPage);
    }

    public void sortComments(boolean sortAsc) {
        this.sortAsc = sortAsc;
        this.refreshComments();
    }

    protected void addCaseComment(String caseCommentText) {
        ((CaseManagementService)this.caseService.call(Void2 -> ((CaseCommentsView)this.view).resetPagination())).addComment(this.containerId, this.caseId, this.identity.getIdentifier(), caseCommentText);
    }

    protected void updateCaseComment(CaseCommentSummary caseCommentSummary, String caseCommentNewText) {
        ((CaseManagementService)this.caseService.call(Void2 -> this.refreshComments())).updateComment(this.containerId, this.caseId, caseCommentSummary.getId(), this.identity.getIdentifier(), caseCommentNewText);
    }

    protected void deleteCaseComment(CaseCommentSummary caseCommentSummary) {
        ((CaseManagementService)this.caseService.call(Void2 -> this.refreshComments())).removeComment(this.containerId, this.caseId, caseCommentSummary.getId());
    }

    public static interface CaseCommentAction
    extends Command {
        public String label();
    }

    public static interface CaseCommentsView
    extends UberElement<CaseCommentsPresenter> {
        public void clearCommentInputForm();

        public void setCaseCommentList(List<CaseCommentSummary> var1);

        public void resetPagination();

        public void hideLoadButton();
    }
}

