/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dashboard.renderer.client.panel.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import java.util.Set;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.displayer.client.AbstractDisplayerListener;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.jbpm.dashboard.renderer.client.panel.i18n.DashboardConstants;
import org.jbpm.dashboard.renderer.client.panel.widgets.DisplayerContainerView;
import org.uberfire.client.mvp.UberView;

public class DisplayerContainer
implements IsWidget {
    protected View view = new DisplayerContainerView();
    protected Map<String, Displayer> displayers;
    protected Displayer currentDisplayer;
    protected boolean error = true;
    protected Timer loadingTimer = new Timer(){

        public void run() {
            DisplayerContainer.this.view.showLoading(DisplayerContainer.this.currentDisplayer);
        }
    };
    DisplayerListener displayerListener = new AbstractDisplayerListener(){

        public void onDataLookup(Displayer displayer) {
            if (displayer == DisplayerContainer.this.currentDisplayer) {
                DisplayerContainer.this.loadingTimer.schedule(1000);
            }
        }

        public void onDraw(Displayer displayer) {
            if (displayer == DisplayerContainer.this.currentDisplayer) {
                DisplayerContainer.this.loadingTimer.cancel();
                DisplayerContainer.this.updateDisplayer();
            }
        }

        public void onRedraw(Displayer displayer) {
            if (displayer == DisplayerContainer.this.currentDisplayer) {
                DisplayerContainer.this.loadingTimer.cancel();
                DisplayerContainer.this.updateDisplayer();
            }
        }

        public void onError(Displayer displayer, ClientRuntimeError e) {
            if (displayer == DisplayerContainer.this.currentDisplayer) {
                DisplayerContainer.this.loadingTimer.cancel();
                DisplayerContainer.this.showError(e);
            }
        }
    };

    public DisplayerContainer(Map<String, Displayer> displayers, boolean showHeader) {
        this.view.init(this);
        this.view.setHeaderVisible(showHeader);
        this.showDisplayers(displayers);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void showDisplayers(Map<String, Displayer> displayers) {
        this.displayers = displayers;
        this.view.setDisplayerList(displayers.keySet());
        for (Displayer displayer : displayers.values()) {
            displayer.addListener(new DisplayerListener[]{this.displayerListener});
        }
        if (displayers.size() < 2) {
            this.view.setSelectorVisible(false);
        }
        int height = 0;
        for (Map.Entry<String, Displayer> entry : displayers.entrySet()) {
            int chartHeight = entry.getValue().getDisplayerSettings().getChartHeight();
            if (chartHeight <= height) continue;
            height = chartHeight;
        }
        if (!displayers.isEmpty()) {
            this.view.setDisplayerHeight(height);
            Displayer displayer = displayers.values().iterator().next();
            this.showDisplayer(displayer);
        }
    }

    public void selectDisplayer(String name) {
        Displayer displayer = this.displayers.get(name);
        if (displayer != null) {
            this.showDisplayer(displayer);
        } else {
            this.view.showError(DashboardConstants.INSTANCE.displayerNotFound(name), null);
        }
    }

    public View getView() {
        return this.view;
    }

    protected void showDisplayer(Displayer displayer) {
        this.error = false;
        this.currentDisplayer = displayer;
        this.view.setHeaderText(displayer.getDisplayerSettings().getTitle());
        this.updateDisplayer();
    }

    protected void updateDisplayer() {
        DataSet ds = this.currentDisplayer.getDataSetHandler().getLastDataSet();
        if (ds != null && ds.getRowCount() == 0) {
            this.view.showEmpty(this.currentDisplayer);
        } else {
            this.view.showDisplayer(this.currentDisplayer);
        }
    }

    protected void showError(ClientRuntimeError e) {
        this.error = true;
        GWT.log((String)e.getMessage(), (Throwable)e.getThrowable());
        this.view.showError(e.getMessage(), e.getCause());
    }

    public static interface View
    extends UberView<DisplayerContainer> {
        public void setHeaderVisible(boolean var1);

        public void setHeaderText(String var1);

        public void setSelectorVisible(boolean var1);

        public void setDisplayerList(Set<String> var1);

        public void setDisplayerHeight(int var1);

        public void showLoading(Displayer var1);

        public void showDisplayer(Displayer var1);

        public void showEmpty(Displayer var1);

        public void showError(String var1, String var2);

        public Style getHeaderStyle();

        public Style getBodyStyle();
    }
}

