/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dashboard.dataset.editor.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.gwt.editor.client.EditorDelegate;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.common.client.editor.ValueBoxEditor;
import org.dashbuilder.common.client.editor.list.DropDownEditor;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.dashboard.renderer.client.panel.i18n.DashboardConstants;
import org.jbpm.workbench.ks.integration.RemoteDataSetDef;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateList;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.uberfire.client.mvp.UberView;

@Dependent
public class RemoteDataSetDefAttributesEditor
implements IsWidget,
org.jbpm.dashboard.dataset.editor.RemoteDataSetDefAttributesEditor {
    DropDownEditor queryTarget;
    DropDownEditor serverTemplateId;
    ValueBoxEditor<String> dataSource;
    ValueBoxEditor<String> dbSQL;
    public View view;
    private Caller<SpecManagementService> specManagementService;

    @Inject
    public RemoteDataSetDefAttributesEditor(DropDownEditor queryTarget, DropDownEditor serverTemplateId, ValueBoxEditor<String> dataSource, ValueBoxEditor<String> dbSQL, View view, Caller<SpecManagementService> specManagementService) {
        this.queryTarget = queryTarget;
        this.serverTemplateId = serverTemplateId;
        this.dataSource = dataSource;
        this.dbSQL = dbSQL;
        this.view = view;
        this.specManagementService = specManagementService;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.initWidgets(this.queryTarget.view, this.serverTemplateId.view, this.dataSource.view, this.dbSQL.view);
        this.queryTarget.setSelectHint(DashboardConstants.INSTANCE.remote_query_target_hint());
        List entries = Stream.of("CUSTOM", "PROCESS", "TASK", "BA_TASK", "PO_TASK", "JOBS", "FILTERED_PROCESS", "FILTERED_BA_TASK", "FILTERED_PO_TASK").map(s -> this.queryTarget.newEntry(s, s)).collect(Collectors.toList());
        this.queryTarget.setEntries(entries);
        this.queryTarget.addHelpContent(DashboardConstants.INSTANCE.query_target(), DashboardConstants.INSTANCE.query_target_description(), Placement.RIGHT);
        this.serverTemplateId.setSelectHint(DashboardConstants.INSTANCE.remote_server_template_hint());
        ((SpecManagementService)this.specManagementService.call(serverTemplates -> this.onServerTemplateLoad((ServerTemplateList)serverTemplates))).listServerTemplates();
        this.serverTemplateId.addHelpContent(DashboardConstants.INSTANCE.server_template(), DashboardConstants.INSTANCE.server_template_description(), Placement.RIGHT);
        this.dataSource.addHelpContent(DashboardConstants.INSTANCE.sql_datasource(), DashboardConstants.INSTANCE.sql_datasource_description(), Placement.BOTTOM);
        this.dbSQL.addHelpContent(DashboardConstants.INSTANCE.sql_source(), DashboardConstants.INSTANCE.sql_source_description(), Placement.BOTTOM);
    }

    private DropDownEditor.Entry toDropDownEntry(ServerTemplate st) {
        return this.serverTemplateId.newEntry(st.getId(), st.getId());
    }

    private void onServerTemplateLoad(ServerTemplateList list) {
        ImmutableList entries = FluentIterable.from((Object[])list.getServerTemplates()).transform(this::toDropDownEntry).toList();
        this.serverTemplateId.setEntries((Collection)entries);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public DropDownEditor queryTarget() {
        return this.queryTarget;
    }

    public DropDownEditor serverTemplateId() {
        return this.serverTemplateId;
    }

    public ValueBoxEditor<String> dataSource() {
        return this.dataSource;
    }

    public ValueBoxEditor<String> dbSQL() {
        return this.dbSQL;
    }

    public void flush() {
    }

    public void onPropertyChange(String ... paths) {
    }

    public void setDelegate(EditorDelegate<RemoteDataSetDef> delegate) {
    }

    public void setValue(RemoteDataSetDef value) {
    }

    public static interface View
    extends UberView<RemoteDataSetDefAttributesEditor> {
        public void initWidgets(DropDownEditor.View var1, DropDownEditor.View var2, ValueBoxEditor.View var3, ValueBoxEditor.View var4);
    }
}

