/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist;

import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.view.client.Range;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.DataSetOpType;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.Group;
import org.jbpm.workbench.common.client.dataset.AbstractDataSetReadyCallback;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.list.ListView;
import org.jbpm.workbench.common.client.list.MultiGridView;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.base.DataSetQueryHelper;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.model.TaskSummary;
import org.jbpm.workbench.ht.model.events.NewTaskEvent;
import org.jbpm.workbench.ht.model.events.TaskCompletedEvent;
import org.jbpm.workbench.ht.model.events.TaskRefreshedEvent;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.jbpm.workbench.ht.service.TaskService;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.menu.Menus;

public abstract class AbstractTaskListPresenter
extends AbstractMultiGridPresenter<TaskSummary, TaskListView> {
    private Constants constants = Constants.INSTANCE;
    private Caller<TaskService> taskService;
    private DataSetQueryHelper dataSetQueryHelperDomainSpecific;
    @Inject
    private ErrorPopupPresenter errorPopup;
    @Inject
    private Event<TaskSelectionEvent> taskSelected;

    public void getData(Range visibleRange) {
        try {
            if (!this.isAddingDefaultFilters()) {
                FilterSettings currentTableSettings = this.dataSetQueryHelper.getCurrentTableSettings();
                currentTableSettings.setServerTemplateId(this.selectedServerTemplate);
                currentTableSettings.setTablePageSize(((TaskListView)this.view).getListGrid().getPageSize());
                ColumnSortList columnSortList = ((TaskListView)this.view).getListGrid().getColumnSortList();
                if (columnSortList != null && columnSortList.size() > 0) {
                    this.dataSetQueryHelper.setLastOrderedColumn(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
                    this.dataSetQueryHelper.setLastSortOrder(columnSortList.size() > 0 && columnSortList.get(0).isAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING);
                } else {
                    this.dataSetQueryHelper.setLastOrderedColumn("createdOn");
                    this.dataSetQueryHelper.setLastSortOrder(SortOrder.ASCENDING);
                }
                List<ColumnFilter> filters = this.getColumnFilters(this.textSearchStr);
                if (!filters.isEmpty()) {
                    if (currentTableSettings.getDataSetLookup().getFirstFilterOp() != null) {
                        currentTableSettings.getDataSetLookup().getFirstFilterOp().addFilterColumn(new ColumnFilter[]{FilterFactory.OR(filters)});
                    } else {
                        DataSetFilter filter = new DataSetFilter();
                        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.OR(filters)});
                        currentTableSettings.getDataSetLookup().addOperation(new DataSetOp[]{filter});
                    }
                }
                this.dataSetQueryHelper.setDataSetHandler(currentTableSettings);
                this.dataSetQueryHelper.lookupDataSet(Integer.valueOf(visibleRange.getStart()), this.createDataSetTaskCallback(visibleRange.getStart(), currentTableSettings));
            }
        }
        catch (Exception e) {
            this.errorPopup.showMessage(this.constants.UnexpectedError(e.getMessage()));
        }
    }

    protected List<ColumnFilter> getColumnFilters(String searchString) {
        ArrayList<ColumnFilter> filters = new ArrayList<ColumnFilter>();
        if (searchString != null && searchString.trim().length() > 0) {
            try {
                Long taskId = Long.valueOf(searchString.trim());
                filters.add(FilterFactory.equalsTo((String)"taskId", (Comparable)taskId));
            }
            catch (NumberFormatException ex) {
                filters.add(FilterFactory.likeTo((String)"name", (String)("%" + searchString.toLowerCase() + "%"), (boolean)false));
                filters.add(FilterFactory.likeTo((String)"description", (String)("%" + searchString.toLowerCase() + "%"), (boolean)false));
                filters.add(FilterFactory.likeTo((String)"processId", (String)("%" + searchString.toLowerCase() + "%"), (boolean)false));
            }
        }
        return filters;
    }

    protected ColumnFilter getUserGroupFilters(boolean isAdminDataset) {
        Set groups = this.identity.getGroups();
        ArrayList<ColumnFilter> condList = new ArrayList<ColumnFilter>();
        for (Group g : groups) {
            condList.add(FilterFactory.equalsTo((String)"id", (Comparable)((Object)g.getName())));
        }
        condList.add(FilterFactory.equalsTo((String)"id", (Comparable)((Object)this.identity.getIdentifier())));
        if (isAdminDataset) {
            return FilterFactory.OR((String)"id", condList);
        }
        ColumnFilter myGroupFilter = FilterFactory.AND((ColumnFilter[])new ColumnFilter[]{FilterFactory.OR(condList), FilterFactory.OR((ColumnFilter[])new ColumnFilter[]{FilterFactory.equalsTo((String)"actualOwner", (Comparable)((Object)"")), FilterFactory.isNull((String)"actualOwner")})});
        return FilterFactory.OR((ColumnFilter[])new ColumnFilter[]{myGroupFilter, FilterFactory.equalsTo((String)"actualOwner", (Comparable)((Object)this.identity.getIdentifier()))});
    }

    protected DataSetReadyCallback createDataSetTaskCallback(final int startRange, final FilterSettings tableSettings) {
        return new AbstractDataSetReadyCallback(this.errorPopup, (ListView)this.view, tableSettings.getUUID()){

            public void callback(DataSet dataSet) {
                if (dataSet != null && AbstractTaskListPresenter.this.dataSetQueryHelper.getCurrentTableSettings().getKey().equals(tableSettings.getKey())) {
                    ArrayList<TaskSummary> myTasksFromDataSet = new ArrayList<TaskSummary>();
                    for (int i = 0; i < dataSet.getRowCount(); ++i) {
                        myTasksFromDataSet.add(AbstractTaskListPresenter.this.createTaskSummaryFromDataSet(dataSet, i));
                    }
                    List ops = tableSettings.getDataSetLookup().getOperationList();
                    String filterValue = AbstractTaskListPresenter.this.isFilteredByTaskName(ops);
                    boolean lastPageExactCount = false;
                    if (dataSet.getRowCount() < ((TaskListView)AbstractTaskListPresenter.this.view).getListGrid().getPageSize()) {
                        lastPageExactCount = true;
                    }
                    if (filterValue != null) {
                        AbstractTaskListPresenter.this.getDomainSpecifDataForTasks(startRange, filterValue, myTasksFromDataSet, lastPageExactCount);
                    } else {
                        AbstractTaskListPresenter.this.updateDataOnCallback(myTasksFromDataSet, startRange, startRange + myTasksFromDataSet.size(), lastPageExactCount);
                    }
                }
                ((TaskListView)AbstractTaskListPresenter.this.view).hideBusyIndicator();
            }
        };
    }

    protected String isFilteredByTaskName(List<DataSetOp> ops) {
        for (DataSetOp dataSetOp : ops) {
            if (!dataSetOp.getType().equals((Object)DataSetOpType.FILTER)) continue;
            List filters = ((DataSetFilter)dataSetOp).getColumnFilterList();
            for (ColumnFilter filter : filters) {
                List parameters;
                if (!(filter instanceof CoreFunctionFilter)) continue;
                CoreFunctionFilter coreFilter = (CoreFunctionFilter)filter;
                if (!filter.getColumnId().toUpperCase().equals("name".toUpperCase()) || ((CoreFunctionFilter)filter).getType() != CoreFunctionType.EQUALS_TO || (parameters = coreFilter.getParameters()).size() <= 0) continue;
                return parameters.get(0).toString();
            }
        }
        return null;
    }

    public void getDomainSpecifDataForTasks(int startRange, String filterValue, List<TaskSummary> myTasksFromDataSet, boolean lastPageExactCount) {
        FilterSettings variablesTableSettings = ((TaskListView)this.view).getVariablesTableSettings(filterValue);
        variablesTableSettings.setTablePageSize(-1);
        variablesTableSettings.setServerTemplateId(this.selectedServerTemplate);
        this.dataSetQueryHelperDomainSpecific.setDataSetHandler(variablesTableSettings);
        this.dataSetQueryHelperDomainSpecific.setCurrentTableSettings(variablesTableSettings);
        this.dataSetQueryHelperDomainSpecific.setLastOrderedColumn("taskId");
        this.dataSetQueryHelperDomainSpecific.setLastSortOrder(SortOrder.ASCENDING);
        ArrayList<Long> tasksIds = new ArrayList<Long>();
        for (TaskSummary task : myTasksFromDataSet) {
            tasksIds.add(task.getTaskId());
        }
        DataSetFilter filter = new DataSetFilter();
        ColumnFilter filter1 = FilterFactory.equalsTo((String)"taskId", tasksIds);
        filter.addFilterColumn(new ColumnFilter[]{filter1});
        variablesTableSettings.getDataSetLookup().addOperation(new DataSetOp[]{filter});
        this.dataSetQueryHelperDomainSpecific.lookupDataSet(Integer.valueOf(0), this.createDataSetDomainSpecificCallback(startRange, myTasksFromDataSet, variablesTableSettings, lastPageExactCount));
    }

    protected DataSetReadyCallback createDataSetDomainSpecificCallback(final int startRange, final List<TaskSummary> instances, FilterSettings tableSettings, final boolean lastPageExactCount) {
        return new AbstractDataSetReadyCallback(this.errorPopup, (ListView)this.view, tableSettings.getUUID()){

            public void callback(DataSet dataSet) {
                if (dataSet.getRowCount() > 0) {
                    HashSet<String> columns = new HashSet<String>();
                    for (int i = 0; i < dataSet.getRowCount(); ++i) {
                        Long taskId = AbstractTaskListPresenter.this.dataSetQueryHelperDomainSpecific.getColumnLongValue(dataSet, "taskId", i);
                        String variableName = AbstractTaskListPresenter.this.dataSetQueryHelperDomainSpecific.getColumnStringValue(dataSet, "name", i);
                        String variableValue = AbstractTaskListPresenter.this.dataSetQueryHelperDomainSpecific.getColumnStringValue(dataSet, "value", i);
                        for (TaskSummary task : instances) {
                            if (!task.getTaskId().equals(taskId)) continue;
                            task.addDomainData(variableName, variableValue);
                            columns.add(variableName);
                        }
                    }
                    ((TaskListView)AbstractTaskListPresenter.this.view).addDomainSpecifColumns((ExtendedPagedTable<TaskSummary>)((TaskListView)AbstractTaskListPresenter.this.view).getListGrid(), columns);
                }
                AbstractTaskListPresenter.this.updateDataOnCallback(instances, startRange, startRange + instances.size(), lastPageExactCount);
            }
        };
    }

    protected TaskSummary createTaskSummaryFromDataSet(DataSet dataSet, int i) {
        return new TaskSummary(this.dataSetQueryHelper.getColumnLongValue(dataSet, "taskId", i).longValue(), this.dataSetQueryHelper.getColumnStringValue(dataSet, "name", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "description", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "status", i), this.dataSetQueryHelper.getColumnIntValue(dataSet, "priority", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "actualOwner", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "createdBy", i), this.dataSetQueryHelper.getColumnDateValue(dataSet, "createdOn", i), this.dataSetQueryHelper.getColumnDateValue(dataSet, "activationTime", i), this.dataSetQueryHelper.getColumnDateValue(dataSet, "dueDate", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "processId", i), this.dataSetQueryHelper.getColumnLongValue(dataSet, "processSessionId", i).longValue(), this.dataSetQueryHelper.getColumnLongValue(dataSet, "processInstanceId", i).longValue(), this.dataSetQueryHelper.getColumnStringValue(dataSet, "deploymentId", i), this.dataSetQueryHelper.getColumnLongValue(dataSet, "parentId", i).longValue(), this.dataSetQueryHelper.getColumnDateValue(dataSet, "lastModificationDate", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "correlationKey", i), this.dataSetQueryHelper.getColumnStringValue(dataSet, "processInstanceDescription", i), "jbpmHumanTasksWithAdmin".equals(dataSet.getUUID()));
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Tasks_List();
    }

    public void releaseTask(final TaskSummary task) {
        ((TaskService)this.taskService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                ((TaskListView)AbstractTaskListPresenter.this.view).displayNotification(AbstractTaskListPresenter.this.constants.TaskReleased(String.valueOf(task.getTaskId())));
                AbstractTaskListPresenter.this.refreshGrid();
            }
        })).releaseTask(this.selectedServerTemplate, task.getDeploymentId(), task.getTaskId());
        this.taskSelected.fire((Object)new TaskSelectionEvent(this.selectedServerTemplate, task.getDeploymentId(), task.getTaskId(), task.getTaskName()));
    }

    public void claimTask(final TaskSummary task) {
        ((TaskService)this.taskService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                ((TaskListView)AbstractTaskListPresenter.this.view).displayNotification(AbstractTaskListPresenter.this.constants.TaskClaimed(String.valueOf(task.getTaskId())));
                AbstractTaskListPresenter.this.refreshGrid();
            }
        })).claimTask(this.selectedServerTemplate, task.getDeploymentId(), task.getTaskId());
        this.taskSelected.fire((Object)new TaskSelectionEvent(this.selectedServerTemplate, task.getDeploymentId(), task.getTaskId(), task.getTaskName()));
    }

    public abstract Menus getMenus();

    public void selectTask(TaskSummary summary, Boolean close) {
        DefaultPlaceRequest defaultPlaceRequest = new DefaultPlaceRequest("Task Details Multi");
        PlaceStatus status = this.placeManager.getStatus((PlaceRequest)defaultPlaceRequest);
        boolean logOnly = false;
        if (summary.getStatus().equals("Completed") && summary.isLogOnly()) {
            logOnly = true;
        }
        if (status == PlaceStatus.CLOSE) {
            this.placeManager.goTo((PlaceRequest)defaultPlaceRequest);
            this.taskSelected.fire((Object)new TaskSelectionEvent(this.selectedServerTemplate, summary.getDeploymentId(), summary.getTaskId(), summary.getTaskName(), summary.isForAdmin(), logOnly));
        } else if (status == PlaceStatus.OPEN && !close.booleanValue()) {
            this.taskSelected.fire((Object)new TaskSelectionEvent(this.selectedServerTemplate, summary.getDeploymentId(), summary.getTaskId(), summary.getTaskName(), summary.isForAdmin(), logOnly));
        } else if (status == PlaceStatus.OPEN && close.booleanValue()) {
            this.placeManager.closePlace("Task Details Multi");
        }
    }

    public void refreshNewTask(@Observes NewTaskEvent newTask) {
        this.refreshGrid();
        PlaceStatus status = this.placeManager.getStatus((PlaceRequest)new DefaultPlaceRequest("Task Details Multi"));
        if (status == PlaceStatus.OPEN) {
            this.taskSelected.fire((Object)new TaskSelectionEvent(this.selectedServerTemplate, null, newTask.getNewTaskId(), newTask.getNewTaskName()));
        } else {
            this.placeManager.goTo("Task Details Multi");
            this.taskSelected.fire((Object)new TaskSelectionEvent(this.selectedServerTemplate, null, newTask.getNewTaskId(), newTask.getNewTaskName()));
        }
        ((TaskListView)this.view).setSelectedTask(new TaskSummary(newTask.getNewTaskId(), newTask.getNewTaskName()));
    }

    public void onTaskRefreshedEvent(@Observes TaskRefreshedEvent event) {
        this.refreshGrid();
    }

    public void onTaskCompletedEvent(@Observes TaskCompletedEvent event) {
        this.refreshGrid();
    }

    @Inject
    public void setDataSetQueryHelperDomainSpecific(DataSetQueryHelper dataSetQueryHelperDomainSpecific) {
        this.dataSetQueryHelperDomainSpecific = dataSetQueryHelperDomainSpecific;
    }

    @Inject
    public void setTaskService(Caller<TaskService> taskService) {
        this.taskService = taskService;
    }

    public static interface TaskListView<T extends AbstractTaskListPresenter>
    extends MultiGridView<TaskSummary, T> {
        public void addDomainSpecifColumns(ExtendedPagedTable<TaskSummary> var1, Set<String> var2);

        public FilterSettings getVariablesTableSettings(String var1);

        public void setSelectedTask(TaskSummary var1);
    }
}

