/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist;

import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.RowStyles;
import com.google.gwt.view.client.AbstractDataProvider;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.common.client.list.AbstractMultiGridView;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.resources.CommonResources;
import org.jbpm.workbench.common.client.util.ButtonActionCell;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.common.client.util.TaskUtils;
import org.jbpm.workbench.common.model.GenericSummary;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.base.DataSetEditorManager;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListPresenter;
import org.jbpm.workbench.ht.client.resources.HumanTaskResources;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.model.TaskSummary;
import org.uberfire.ext.services.shared.preferences.GridColumnPreference;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.mvp.Command;

public abstract class AbstractTaskListView<P extends AbstractTaskListPresenter>
extends AbstractMultiGridView<TaskSummary, P>
implements AbstractTaskListPresenter.TaskListView<P> {
    public static final String COL_ID_ACTIONS = "actions";
    protected final Constants constants = Constants.INSTANCE;
    @Inject
    private DataSetEditorManager dataSetEditorManager;

    public abstract String getDataSetTaskListPrefix();

    public void init(P presenter) {
        final ArrayList<String> bannedColumns = new ArrayList<String>();
        bannedColumns.add("name");
        bannedColumns.add(COL_ID_ACTIONS);
        final ArrayList<String> initColumns = new ArrayList<String>();
        initColumns.add("name");
        initColumns.add("processId");
        initColumns.add("status");
        initColumns.add("createdOn");
        initColumns.add(COL_ID_ACTIONS);
        this.createTabButton.addClickHandler(new ClickHandler((AbstractTaskListPresenter)((Object)presenter)){
            final /* synthetic */ AbstractTaskListPresenter val$presenter;
            {
                this.val$presenter = abstractTaskListPresenter;
            }

            public void onClick(ClickEvent event) {
                final String key = AbstractTaskListView.this.getValidKeyForAdditionalListGrid(AbstractTaskListView.this.getDataSetTaskListPrefix() + "_");
                Command addNewGrid = new Command(){

                    public void execute() {
                        final ExtendedPagedTable extendedPagedTable = AbstractTaskListView.this.createGridInstance(new GridGlobalPreferences(key, initColumns, bannedColumns), key);
                        extendedPagedTable.setDataProvider((AbstractDataProvider)val$presenter.getDataProvider());
                        AbstractTaskListView.this.filterPagedTable.createNewTab((PagedTable)extendedPagedTable, key, AbstractTaskListView.this.createTabButton, new Command(){

                            public void execute() {
                                AbstractTaskListView.this.currentListGrid = extendedPagedTable;
                                AbstractTaskListView.this.applyFilterOnPresenter(key);
                            }
                        });
                        AbstractTaskListView.this.applyFilterOnPresenter(key);
                    }
                };
                FilterSettings tableSettings = this.val$presenter.createTableSettingsPrototype();
                tableSettings.setKey(key);
                AbstractTaskListView.this.dataSetEditorManager.showTableSettingsEditor(AbstractTaskListView.this.filterPagedTable, Constants.INSTANCE.New_FilteredList(), tableSettings, addNewGrid);
            }
        });
        super.init(presenter, new GridGlobalPreferences(this.getDataSetTaskListPrefix(), initColumns, bannedColumns));
    }

    public void initSelectionModel(final ExtendedPagedTable<TaskSummary> extendedPagedTable) {
        this.selectedStyles = new RowStyles<TaskSummary>(){

            public String getStyleNames(TaskSummary row, int rowIndex) {
                if (rowIndex == AbstractTaskListView.this.selectedRow) {
                    return CommonResources.INSTANCE.css().selected();
                }
                if (row.getStatus().equals(TaskUtils.TASK_STATUS_INPROGRESS) || row.getStatus().equals(TaskUtils.TASK_STATUS_READY)) {
                    switch (row.getPriority()) {
                        case 5: {
                            return HumanTaskResources.INSTANCE.css().taskPriorityFive();
                        }
                        case 4: {
                            return HumanTaskResources.INSTANCE.css().taskPriorityFour();
                        }
                        case 3: {
                            return HumanTaskResources.INSTANCE.css().taskPriorityThree();
                        }
                        case 2: {
                            return HumanTaskResources.INSTANCE.css().taskPriorityTwo();
                        }
                        case 1: {
                            return HumanTaskResources.INSTANCE.css().taskPriorityOne();
                        }
                    }
                    return "";
                }
                if (row.getStatus().equals(TaskUtils.TASK_STATUS_COMPLETED)) {
                    return HumanTaskResources.INSTANCE.css().taskCompleted();
                }
                return null;
            }
        };
        extendedPagedTable.setEmptyTableCaption(this.constants.No_Tasks_Found());
        final NoSelectionModel selectionModel = new NoSelectionModel();
        selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                boolean close = false;
                if (AbstractTaskListView.this.selectedRow == -1) {
                    AbstractTaskListView.this.selectedRow = extendedPagedTable.getKeyboardSelectedRow();
                    extendedPagedTable.setRowStyles(AbstractTaskListView.this.selectedStyles);
                    extendedPagedTable.redraw();
                } else if (extendedPagedTable.getKeyboardSelectedRow() != AbstractTaskListView.this.selectedRow) {
                    extendedPagedTable.setRowStyles(AbstractTaskListView.this.selectedStyles);
                    AbstractTaskListView.this.selectedRow = extendedPagedTable.getKeyboardSelectedRow();
                    extendedPagedTable.redraw();
                } else {
                    close = true;
                }
                AbstractTaskListView.this.selectedItem = (GenericSummary)selectionModel.getLastSelectedObject();
                ((AbstractTaskListPresenter)AbstractTaskListView.this.presenter).selectTask((TaskSummary)AbstractTaskListView.this.selectedItem, close);
            }
        });
        DefaultSelectionEventManager noActionColumnManager = DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new DefaultSelectionEventManager.EventTranslator<TaskSummary>(){

            public boolean clearCurrentSelection(CellPreviewEvent<TaskSummary> event) {
                return false;
            }

            public DefaultSelectionEventManager.SelectAction translateSelectionEvent(CellPreviewEvent<TaskSummary> event) {
                DefaultSelectionEventManager.SelectAction ret = DefaultSelectionEventManager.SelectAction.DEFAULT;
                NativeEvent nativeEvent = event.getNativeEvent();
                if ("click".equals(nativeEvent.getType()) && extendedPagedTable.isSelectionIgnoreColumn(event.getColumn())) {
                    ret = DefaultSelectionEventManager.SelectAction.IGNORE;
                }
                return ret;
            }
        });
        extendedPagedTable.setSelectionModel((SelectionModel)selectionModel, (CellPreviewEvent.Handler)noActionColumnManager);
        extendedPagedTable.setRowStyles(this.selectedStyles);
    }

    public void initColumns(ExtendedPagedTable<TaskSummary> extendedPagedTable) {
        this.initCellPreview(extendedPagedTable);
        Column<TaskSummary, ?> actionsColumn = this.initActionsColumn();
        extendedPagedTable.addSelectionIgnoreColumn(actionsColumn);
        ArrayList<ColumnMeta<TaskSummary>> columnMetas = new ArrayList<ColumnMeta<TaskSummary>>();
        columnMetas.add(new ColumnMeta(this.createNumberColumn("taskId", task -> task.getTaskId()), this.constants.Id()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("name", task -> task.getTaskName()), this.constants.Task()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("description", task -> task.getDescription()), this.constants.Description()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("processId", task -> task.getProcessId()), this.constants.Process_Name()));
        columnMetas.add(new ColumnMeta(this.createNumberColumn("processInstanceId", task -> task.getProcessInstanceId()), this.constants.Process_Id()));
        columnMetas.add(new ColumnMeta(this.createNumberColumn("priority", task -> task.getPriority()), this.constants.Priority()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("status", task -> task.getStatus()), this.constants.Status()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("createdOn", task -> DateUtils.getDateTimeStr((Date)task.getCreatedOn())), this.constants.Created_On()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("dueDate", task -> DateUtils.getDateTimeStr((Date)task.getExpirationTime())), this.constants.Due_On()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("actualOwner", task -> task.getActualOwner()), this.constants.Actual_Owner()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("correlationKey", task -> task.getProcessInstanceCorrelationKey()), this.constants.Process_Instance_Correlation_Key()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("processInstanceDescription", task -> task.getProcessInstanceDescription()), this.constants.Process_Instance_Description()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("lastModificationDate", task -> DateUtils.getDateTimeStr((Date)task.getLastModificationDate())), this.constants.Last_Modification_Date()));
        columnMetas.add(new ColumnMeta(actionsColumn, this.constants.Actions()));
        List columPreferenceList = extendedPagedTable.getGridPreferencesStore().getColumnPreferences();
        for (GridColumnPreference colPref : columPreferenceList) {
            if (this.isColumnAdded(columnMetas, colPref.getName())) continue;
            Column<TaskSummary, ?> genericColumn = this.initGenericColumn(colPref.getName());
            genericColumn.setSortable(false);
            columnMetas.add((ColumnMeta<TaskSummary>)new ColumnMeta(genericColumn, colPref.getName(), true, true));
        }
        extendedPagedTable.addColumns(columnMetas);
    }

    private void initCellPreview(final ExtendedPagedTable<TaskSummary> extendedPagedTable) {
        extendedPagedTable.addCellPreviewHandler((CellPreviewEvent.Handler)new CellPreviewEvent.Handler<TaskSummary>(){

            public void onCellPreview(CellPreviewEvent<TaskSummary> event) {
                if ("mouseover".equalsIgnoreCase(event.getNativeEvent().getType())) {
                    AbstractTaskListView.this.onMouseOverGrid((ExtendedPagedTable<TaskSummary>)extendedPagedTable, (CellPreviewEvent<TaskSummary>)event);
                }
            }
        });
    }

    private void onMouseOverGrid(ExtendedPagedTable<TaskSummary> extendedPagedTable, CellPreviewEvent<TaskSummary> event) {
        TaskSummary task = (TaskSummary)event.getValue();
        if (task.getDescription() != null) {
            extendedPagedTable.setTooltip(extendedPagedTable.getKeyboardSelectedRow(), event.getColumn(), task.getDescription());
        }
    }

    private Column<TaskSummary, ?> initActionsColumn() {
        LinkedList<ButtonActionCell> cells = new LinkedList<ButtonActionCell>();
        cells.add(new ClaimActionHasCell(this.constants.Claim(), (ActionCell.Delegate<TaskSummary>)((ActionCell.Delegate)task -> ((AbstractTaskListPresenter)this.presenter).claimTask((TaskSummary)task))));
        cells.add(new ReleaseActionHasCell(this.identity, this.constants.Release(), (ActionCell.Delegate<TaskSummary>)((ActionCell.Delegate)task -> ((AbstractTaskListPresenter)this.presenter).releaseTask((TaskSummary)task))));
        cells.add(new ConditionalActionHasCell(this.constants.Suspend(), (ActionCell.Delegate<TaskSummary>)((ActionCell.Delegate)task -> ((AbstractTaskListPresenter)this.presenter).suspendTask((TaskSummary)task)), this.getSuspendActionCondition()));
        cells.add(new ConditionalActionHasCell(this.constants.Resume(), (ActionCell.Delegate<TaskSummary>)((ActionCell.Delegate)task -> ((AbstractTaskListPresenter)this.presenter).resumeTask((TaskSummary)task)), this.getResumeActionCondition()));
        cells.add(new CompleteActionHasCell(this.constants.Open(), (ActionCell.Delegate<TaskSummary>)((ActionCell.Delegate)task -> {
            this.selectedRow = -1;
            ((AbstractTaskListPresenter)this.presenter).selectTask((TaskSummary)task, false);
        })));
        CompositeCell cell = new CompositeCell(cells);
        Column<TaskSummary, TaskSummary> actionsColumn = new Column<TaskSummary, TaskSummary>((Cell)cell){

            public TaskSummary getValue(TaskSummary object) {
                return object;
            }
        };
        actionsColumn.setDataStoreName(COL_ID_ACTIONS);
        return actionsColumn;
    }

    protected ConditionalActionHasCell.ActionCellRenderCondition getSuspendActionCondition() {
        return task -> {
            String taskStatus = task.getStatus();
            return taskStatus.equals(TaskUtils.TASK_STATUS_RESERVED) || taskStatus.equals(TaskUtils.TASK_STATUS_INPROGRESS) || taskStatus.equals(TaskUtils.TASK_STATUS_READY);
        };
    }

    protected ConditionalActionHasCell.ActionCellRenderCondition getResumeActionCondition() {
        return task -> {
            String taskStatus = task.getStatus();
            return taskStatus.equals(TaskUtils.TASK_STATUS_SUSPENDED);
        };
    }

    protected void initFilterTab(FilterSettings tableSettings, String key, String tabName, String tabDesc, GridGlobalPreferences preferences) {
        tableSettings.setKey(key);
        tableSettings.setTableName(tabName);
        tableSettings.setTableDescription(tabDesc);
        this.addNewTab(preferences, tableSettings);
    }

    private boolean isColumnAdded(List<ColumnMeta<TaskSummary>> columnMetas, String caption) {
        if (caption != null) {
            for (ColumnMeta<TaskSummary> colMet : columnMetas) {
                if (!caption.equals(colMet.getColumn().getDataStoreName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addDomainSpecifColumns(ExtendedPagedTable<TaskSummary> extendedPagedTable, Set<String> columns) {
        extendedPagedTable.storeColumnToPreferences();
        HashMap<String, String> modifiedCaptions = new HashMap<String, String>();
        ArrayList<ColumnMeta> existingExtraColumns = new ArrayList<ColumnMeta>();
        for (ColumnMeta cm : extendedPagedTable.getColumnMetaList()) {
            if (cm.isExtraColumn()) {
                existingExtraColumns.add(cm);
                continue;
            }
            if (!columns.contains(cm.getCaption())) continue;
            for (String c : columns) {
                if (!c.equals(cm.getCaption())) continue;
                modifiedCaptions.put(c, "Var_" + c);
            }
        }
        for (ColumnMeta colMet : existingExtraColumns) {
            if (!columns.contains(colMet.getCaption())) {
                extendedPagedTable.removeColumnMeta(colMet);
                continue;
            }
            columns.remove(colMet.getCaption());
        }
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        String caption = "";
        Iterator<String> iterator = columns.iterator();
        while (iterator.hasNext()) {
            String c;
            caption = c = iterator.next();
            if (modifiedCaptions.get(c) != null) {
                caption = (String)modifiedCaptions.get(c);
            }
            Column<TaskSummary, ?> genericColumn = this.initGenericColumn(c);
            genericColumn.setSortable(false);
            columnMetas.add(new ColumnMeta(genericColumn, caption, true, true));
        }
        extendedPagedTable.addColumns(columnMetas);
    }

    private Column<TaskSummary, ?> initGenericColumn(String key) {
        return this.createTextColumn(key, task -> task.getDomainDataValue(key));
    }

    @Override
    public void setSelectedTask(TaskSummary selectedTask) {
        this.currentListGrid.getSelectionModel().setSelected((Object)selectedTask, true);
    }

    protected static class ConditionalActionHasCell
    extends ButtonActionCell<TaskSummary> {
        private final ActionCellRenderCondition cond;

        public ConditionalActionHasCell(String text, ActionCell.Delegate<TaskSummary> delegate, ActionCellRenderCondition cond) {
            super(text, delegate);
            this.cond = cond;
        }

        public void render(Cell.Context context, TaskSummary value, SafeHtmlBuilder sb) {
            if (this.cond.shouldRender(value)) {
                super.render(context, (Object)value, sb);
            }
        }

        protected static interface ActionCellRenderCondition {
            public boolean shouldRender(TaskSummary var1);
        }
    }

    protected static class ReleaseActionHasCell
    extends ButtonActionCell<TaskSummary> {
        private final User identity;

        public ReleaseActionHasCell(User identity, String text, ActionCell.Delegate<TaskSummary> delegate) {
            super(text, delegate);
            this.identity = identity;
        }

        public void render(Cell.Context context, TaskSummary value, SafeHtmlBuilder sb) {
            if (value.getActualOwner() != null && value.getActualOwner().equals(this.identity.getIdentifier()) && (value.getStatus().equals(TaskUtils.TASK_STATUS_RESERVED) || value.getStatus().equals(TaskUtils.TASK_STATUS_INPROGRESS))) {
                super.render(context, (Object)value, sb);
            }
        }
    }

    protected static class ClaimActionHasCell
    extends ButtonActionCell<TaskSummary> {
        public ClaimActionHasCell(String text, ActionCell.Delegate<TaskSummary> delegate) {
            super(text, delegate);
        }

        public void render(Cell.Context context, TaskSummary value, SafeHtmlBuilder sb) {
            if (value.getStatus().equals(TaskUtils.TASK_STATUS_READY)) {
                super.render(context, (Object)value, sb);
            }
        }
    }

    protected static class CompleteActionHasCell
    extends ButtonActionCell<TaskSummary> {
        public CompleteActionHasCell(String text, ActionCell.Delegate<TaskSummary> delegate) {
            super(text, delegate);
        }

        public void render(Cell.Context context, TaskSummary value, SafeHtmlBuilder sb) {
            if (value.getActualOwner() != null && value.getStatus().equals(TaskUtils.TASK_STATUS_INPROGRESS)) {
                super.render(context, (Object)value, sb);
            }
        }
    }
}

