/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist;

import java.util.List;
import javax.enterprise.context.Dependent;
import org.gwtbootstrap3.client.ui.Button;
import org.jbpm.workbench.common.client.util.TaskUtils;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListView;
import org.jbpm.workbench.ht.client.editors.taskslist.TaskListPresenter;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;

@Dependent
public class TaskListViewImpl
extends AbstractTaskListView<TaskListPresenter> {
    private static final String DATA_SET_TASK_LIST_PREFIX = "DataSetTaskListGrid";
    private static final String TAB_ALL = "DataSetTaskListGrid_3";
    private static final String TAB_GROUP = "DataSetTaskListGrid_2";
    private static final String TAB_PERSONAL = "DataSetTaskListGrid_1";
    private static final String TAB_ACTIVE = "DataSetTaskListGrid_0";

    public void initDefaultFilters(GridGlobalPreferences preferences, Button createTabButton) {
        super.initDefaultFilters(preferences, createTabButton);
        this.initFilterTab(((TaskListPresenter)this.presenter).createActiveTabSettings(), TAB_ACTIVE, Constants.INSTANCE.Active(), Constants.INSTANCE.FilterActive(), preferences);
        this.initFilterTab(((TaskListPresenter)this.presenter).createPersonalTabSettings(), TAB_PERSONAL, Constants.INSTANCE.Personal(), Constants.INSTANCE.FilterPersonal(), preferences);
        this.initFilterTab(((TaskListPresenter)this.presenter).createGroupTabSettings(), TAB_GROUP, Constants.INSTANCE.Group(), Constants.INSTANCE.FilterGroup(), preferences);
        this.initFilterTab(((TaskListPresenter)this.presenter).createAllTabSettings(), TAB_ALL, Constants.INSTANCE.All(), Constants.INSTANCE.FilterAll(), preferences);
        this.filterPagedTable.addAddTableButton(createTabButton);
        this.selectFirstTabAndEnableQueries();
    }

    public void resetDefaultFilterTitleAndDescription() {
        super.resetDefaultFilterTitleAndDescription();
        this.saveTabSettings(TAB_ACTIVE, this.constants.Active(), this.constants.FilterActive());
        this.saveTabSettings(TAB_PERSONAL, this.constants.Personal(), this.constants.FilterPersonal());
        this.saveTabSettings(TAB_GROUP, this.constants.Group(), this.constants.FilterGroup());
        this.saveTabSettings(TAB_ALL, this.constants.All(), this.constants.FilterAll());
    }

    @Override
    public String getDataSetTaskListPrefix() {
        return DATA_SET_TASK_LIST_PREFIX;
    }

    @Override
    protected AbstractTaskListView.ConditionalActionHasCell.ActionCellRenderCondition getSuspendActionCondition() {
        return task -> {
            String taskStatus = task.getStatus();
            String actualOwner = task.getActualOwner();
            String currentId = this.identity.getIdentifier();
            List potOwners = task.getPotOwnersString();
            return actualOwner != null && actualOwner.equals(currentId) && (taskStatus.equals(TaskUtils.TASK_STATUS_RESERVED) || taskStatus.equals(TaskUtils.TASK_STATUS_INPROGRESS)) || potOwners != null && potOwners.contains(currentId) && taskStatus.equals(TaskUtils.TASK_STATUS_READY);
        };
    }

    @Override
    protected AbstractTaskListView.ConditionalActionHasCell.ActionCellRenderCondition getResumeActionCondition() {
        return task -> {
            String taskStatus = task.getStatus();
            String actualOwner = task.getActualOwner();
            String currentId = this.identity.getIdentifier();
            List potOwners = task.getPotOwnersString();
            return taskStatus.equals(TaskUtils.TASK_STATUS_SUSPENDED) && (actualOwner != null && actualOwner.equals(currentId) || potOwners != null && potOwners.contains(currentId));
        };
    }
}

