/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskadmin;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.ht.client.editors.AbstractTaskPresenter;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.model.events.AbstractTaskEvent;
import org.jbpm.workbench.ht.model.events.TaskRefreshedEvent;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.jbpm.workbench.ht.service.TaskService;
import org.uberfire.client.mvp.UberView;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class TaskAdminPresenter
extends AbstractTaskPresenter {
    @Inject
    protected Caller<TaskService> taskService;
    private Constants constants = Constants.INSTANCE;
    @Inject
    private TaskAdminView view;
    @Inject
    private User identity;
    @Inject
    private Event<TaskRefreshedEvent> taskRefreshed;
    @Inject
    private Event<NotificationEvent> notification;

    @Inject
    public void setTaskService(Caller<TaskService> taskService) {
        this.taskService = taskService;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public IsWidget getView() {
        return this.view;
    }

    public void forwardTask(String entity) {
        ((TaskService)this.taskService.call(nothing -> {
            this.notification.fire((Object)new NotificationEvent(this.constants.TaskSuccessfullyForwarded()));
            this.taskRefreshed.fire((Object)new TaskRefreshedEvent(this.getServerTemplateId(), this.getContainerId(), this.getTaskId()));
            this.refreshTaskPotentialOwners();
        })).forward(this.getServerTemplateId(), this.getContainerId(), this.getTaskId(), entity);
    }

    public void reminder() {
        ((TaskService)this.taskService.call(ts -> this.notification.fire((Object)new NotificationEvent(this.constants.ReminderSentTo(this.identity.getIdentifier()))))).executeReminderForTask(this.getServerTemplateId(), this.getContainerId(), this.getTaskId(), this.identity.getIdentifier());
    }

    public void refreshTaskPotentialOwners() {
        this.view.enableReminderButton(false);
        this.view.enableForwardButton(false);
        this.view.enableUserOrGroupText(false);
        this.view.setUsersGroupsControlsPanelText(Collections.emptyList());
        this.view.clearUserOrGroupText();
        this.view.setActualOwnerText("");
        ((TaskService)this.taskService.call(ts -> {
            if (ts == null) {
                return;
            }
            if (ts.getPotOwnersString() == null || ts.getPotOwnersString().isEmpty()) {
                this.view.setUsersGroupsControlsPanelText(Collections.singletonList(Constants.INSTANCE.No_Potential_Owners()));
            } else {
                this.view.setUsersGroupsControlsPanelText(ts.getPotOwnersString());
            }
            this.view.enableForwardButton(ts.isForwardAllowed());
            this.view.enableUserOrGroupText(ts.isForwardAllowed());
            if (ts.getActualOwner() == null || ts.getActualOwner().equals("")) {
                this.view.enableReminderButton(false);
                this.view.setActualOwnerText(Constants.INSTANCE.No_Actual_Owner());
            } else {
                this.view.enableReminderButton(true);
                this.view.setActualOwnerText(ts.getActualOwner());
            }
        })).getTaskAssignmentDetails(this.getServerTemplateId(), this.getContainerId(), this.getTaskId());
    }

    public void onTaskSelectionEvent(@Observes TaskSelectionEvent event) {
        if (!event.isForLog().booleanValue()) {
            this.setSelectedTask(event);
            this.refreshTaskPotentialOwners();
        }
    }

    public void onTaskRefreshedEvent(@Observes TaskRefreshedEvent event) {
        if (this.isSameTaskFromEvent().test((AbstractTaskEvent)event)) {
            this.refreshTaskPotentialOwners();
        }
    }

    public static interface TaskAdminView
    extends UberView<TaskAdminPresenter> {
        public void setUsersGroupsControlsPanelText(List<String> var1);

        public void enableForwardButton(boolean var1);

        public void enableUserOrGroupText(boolean var1);

        public void enableReminderButton(boolean var1);

        public void setActualOwnerText(String var1);

        public void clearUserOrGroupText();
    }
}

