/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskcomments;

import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.HasCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.TextArea;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.ht.client.editors.taskcomments.TaskCommentsPresenter;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.model.CommentSummary;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
@Templated(value="TaskCommentsViewImpl.html")
public class TaskCommentsViewImpl
extends Composite
implements TaskCommentsPresenter.TaskCommentsView {
    protected static final String COL_ADDEDBY = "addedBy";
    protected static final String COL_ADDEDAT = "addedAt";
    protected static final String COL_COMMENT = "comment";
    protected static final String COL_ID_ACTIONS = "Actions";
    private static final int COMMENTS_PER_PAGE = 10;
    @DataField
    PagedTable<CommentSummary> commentsListGrid = new PagedTable(10);
    @Inject
    @DataField
    TextArea newTaskCommentTextArea;
    @Inject
    @DataField
    FormLabel newTaskCommentLabel = (FormLabel)GWT.create(FormLabel.class);
    @Inject
    @DataField
    Button addCommentButton = (Button)GWT.create(Button.class);
    @Inject
    @DataField
    HTMLDivElement form;
    @Inject
    @Named(value="span")
    @DataField
    HTMLElement message;
    @Inject
    @DataField
    HTMLDivElement alert;
    @Inject
    @DataField
    HTMLDivElement listContainer;
    private Constants constants = (Constants)GWT.create(Constants.class);
    private TaskCommentsPresenter presenter;
    @Inject
    private Event<NotificationEvent> notification;
    private ColumnSortEvent.ListHandler<CommentSummary> sortHandler;

    @Override
    public void clearCommentInput() {
        this.newTaskCommentTextArea.setText("");
    }

    @Override
    public void redrawDataGrid() {
        this.commentsListGrid.refresh();
        this.commentsListGrid.redraw();
    }

    public void init(TaskCommentsPresenter presenter) {
        this.presenter = presenter;
        ArrayList<String> bannedColumns = new ArrayList<String>();
        bannedColumns.add(COL_COMMENT);
        bannedColumns.add(COL_ID_ACTIONS);
        ArrayList<String> initColumns = new ArrayList<String>();
        initColumns.add(COL_ADDEDBY);
        initColumns.add(COL_COMMENT);
        initColumns.add(COL_ADDEDAT);
        initColumns.add(COL_ID_ACTIONS);
        this.commentsListGrid.setGridPreferencesStore(new GridPreferencesStore(new GridGlobalPreferences("CommentsGrid", initColumns, bannedColumns)));
        this.commentsListGrid.setEmptyTableCaption(this.constants.No_Comments_For_This_Task());
        this.sortHandler = new ColumnSortEvent.ListHandler(presenter.getDataProvider().getList());
        this.commentsListGrid.addColumnSortHandler(this.sortHandler);
        this.initTableColumns();
        presenter.addDataDisplay((HasData<CommentSummary>)this.commentsListGrid);
        this.addCommentButton.setText(this.constants.Add_Comment());
        this.newTaskCommentLabel.setText(this.constants.Comment());
    }

    @EventHandler(value={"addCommentButton"})
    public void addCommentButton(ClickEvent e) {
        this.presenter.addTaskComment(this.newTaskCommentTextArea.getText());
    }

    @Override
    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    private void initTableColumns() {
        Column<CommentSummary, String> addedByColumn = new Column<CommentSummary, String>((Cell)new TextCell()){

            public String getValue(CommentSummary c) {
                return c.getAddedBy();
            }
        };
        addedByColumn.setSortable(false);
        addedByColumn.setDataStoreName(COL_ADDEDBY);
        this.commentsListGrid.addColumn((Column)addedByColumn, this.constants.Added_By());
        Column<CommentSummary, String> addedAtColumn = new Column<CommentSummary, String>((Cell)new TextCell()){

            public String getValue(CommentSummary c) {
                return DateUtils.getDateTimeStr((Date)c.getAddedAt());
            }
        };
        addedAtColumn.setSortable(true);
        addedAtColumn.setDataStoreName(COL_ADDEDAT);
        addedAtColumn.setDefaultSortAscending(true);
        this.commentsListGrid.addColumn((Column)addedAtColumn, this.constants.Added_At());
        this.sortHandler.setComparator((Column)addedAtColumn, Comparator.comparing(CommentSummary::getAddedAt).reversed());
        Column<CommentSummary, String> commentTextColumn = new Column<CommentSummary, String>((Cell)new TextCell()){

            public String getValue(CommentSummary object) {
                return object.getText();
            }
        };
        commentTextColumn.setSortable(false);
        commentTextColumn.setDataStoreName(COL_COMMENT);
        this.commentsListGrid.addColumn((Column)commentTextColumn, this.constants.Comment());
        LinkedList<DeleteCommentActionHasCell> cells = new LinkedList<DeleteCommentActionHasCell>();
        cells.add(new DeleteCommentActionHasCell(this.constants.Delete(), new ActionCell.Delegate<CommentSummary>(){

            public void execute(CommentSummary comment) {
                TaskCommentsViewImpl.this.presenter.removeTaskComment(comment.getId());
            }
        }));
        CompositeCell cell = new CompositeCell(cells);
        Column<CommentSummary, CommentSummary> actionsColumn = new Column<CommentSummary, CommentSummary>((Cell)cell){

            public CommentSummary getValue(CommentSummary object) {
                return object;
            }
        };
        actionsColumn.setSortable(false);
        actionsColumn.setDataStoreName(COL_ID_ACTIONS);
        this.commentsListGrid.addColumn((Column)actionsColumn, this.constants.Actions());
        this.commentsListGrid.setColumnWidth((Column)addedByColumn, 150.0, Style.Unit.PX);
        this.commentsListGrid.setColumnWidth((Column)addedAtColumn, 150.0, Style.Unit.PX);
        this.commentsListGrid.setColumnWidth((Column)actionsColumn, 120.0, Style.Unit.PX);
        this.commentsListGrid.getColumnSortList().push((Column)addedAtColumn);
    }

    @Override
    public void setErrorMessage(String message) {
        this.alert.classList.remove(new String[]{"hidden"});
        this.listContainer.classList.add(new String[]{"hidden"});
        this.message.textContent = message;
    }

    @Override
    public void newCommentsEnabled(Boolean enabled) {
        if (enabled.booleanValue()) {
            this.form.classList.remove(new String[]{"hidden"});
        } else {
            this.form.classList.add(new String[]{"hidden"});
        }
    }

    private class DeleteCommentActionHasCell
    implements HasCell<CommentSummary, CommentSummary> {
        private ActionCell<CommentSummary> cell;

        public DeleteCommentActionHasCell(String text, ActionCell.Delegate<CommentSummary> delegate) {
            this.cell = new ActionCell<CommentSummary>(text, delegate){

                public void render(Cell.Context context, CommentSummary value, SafeHtmlBuilder sb) {
                    if (TaskCommentsViewImpl.this.presenter.getDeleteCondition().test(value)) {
                        SafeHtmlBuilder mysb = new SafeHtmlBuilder();
                        Button button = (Button)GWT.create(Button.class);
                        button.setText(TaskCommentsViewImpl.this.constants.Delete());
                        button.setSize(ButtonSize.SMALL);
                        button.setType(ButtonType.DANGER);
                        mysb.appendHtmlConstant(new SimplePanel((Widget)button).getElement().getInnerHTML());
                        sb.append(mysb.toSafeHtml());
                    }
                }
            };
        }

        public Cell<CommentSummary> getCell() {
            return this.cell;
        }

        public FieldUpdater<CommentSummary, CommentSummary> getFieldUpdater() {
            return null;
        }

        public CommentSummary getValue(CommentSummary object) {
            return object;
        }
    }
}

