/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskdetails;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.html.Paragraph;
import org.gwtbootstrap3.extras.select.client.ui.Option;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.ht.client.editors.taskdetails.TaskDetailsPresenter;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.uberfire.client.views.pfly.widgets.DateRangePicker;
import org.uberfire.client.views.pfly.widgets.DateRangePickerOptions;
import org.uberfire.client.views.pfly.widgets.Moment;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
@Templated(value="TaskDetailsViewImpl.html")
public class TaskDetailsViewImpl
extends Composite
implements TaskDetailsPresenter.TaskDetailsView {
    private static Constants constants = Constants.INSTANCE;
    @Inject
    @DataField
    public Paragraph userText;
    @Inject
    @DataField(value="taskStatusText")
    public Paragraph taskStatusText;
    @Inject
    @DataField
    public TextArea taskDescriptionTextArea;
    @Inject
    @DataField
    public Select taskPriorityListBox;
    @Inject
    @DataField(value="processInstanceIdText")
    public Paragraph processInstanceIdText;
    @Inject
    @DataField(value="processIdText")
    public Paragraph processIdText;
    @Inject
    @DataField
    public Button updateTaskButton;
    @Inject
    @DataField
    public FormLabel taskStatusLabel;
    @Inject
    @DataField
    public FormLabel userLabel;
    @Inject
    @DataField
    public FormLabel dueDateLabel;
    @Inject
    @DataField
    public FormLabel taskPriorityLabel;
    @Inject
    @DataField
    public FormLabel taskDescriptionLabel;
    @Inject
    @DataField
    public FormLabel processInstanceIdLabel;
    @Inject
    @DataField
    public FormLabel processIdLabel;
    @Inject
    @DataField(value="date-filters-input")
    public FlowPanel dateRangePickerInput;
    @Inject
    @DataField(value="dueDateText")
    public Paragraph dueDateText;
    @Inject
    private ManagedInstance<DateRangePicker> dateRangePickerProvider;
    private DateRangePicker dateRangePicker;
    private Date selectedDate;
    private TaskDetailsPresenter presenter;
    private String[] priorities = new String[]{"0 - " + constants.High(), "1", "2", "3", "4", "5 - " + constants.Medium(), "6", "7", "8", "9", "10 - " + constants.Low()};
    @Inject
    private Event<NotificationEvent> notification;

    @Override
    public void init(TaskDetailsPresenter presenter) {
        this.presenter = presenter;
        for (int i = 0; i < this.priorities.length; ++i) {
            Option option = new Option();
            option.setText(this.priorities[i]);
            option.setValue(String.valueOf(i));
            this.taskPriorityListBox.add((Widget)option);
        }
        this.refreshPriorities();
        this.taskStatusLabel.setText(constants.Status());
        this.userLabel.setText(constants.User());
        this.dueDateLabel.setText(constants.Due_On());
        this.taskPriorityLabel.setText(constants.Priority());
        this.taskDescriptionLabel.setText(constants.Description());
        this.processInstanceIdLabel.setText(constants.Process_Instance_Id());
        this.processIdLabel.setText(constants.Process_Definition_Id());
        this.updateTaskButton.setText(constants.Update());
        this.setDueDateEnabled(true);
        this.initDateTimePicker();
    }

    protected void initDateTimePicker() {
        this.dateRangePicker = (DateRangePicker)this.dateRangePickerProvider.get();
        this.dateRangePicker.getElement().setReadOnly(true);
        this.dateRangePicker.getElement().setAttribute("placeholder", Constants.INSTANCE.Due_On());
        this.dateRangePicker.getElement().getClassList().add("form-control");
        this.setupDateTimePicker();
        this.dateRangePickerInput.add((Widget)ElementWrapperWidget.getWidget((HTMLElement)this.dateRangePicker.getElement()));
    }

    protected void setupDateTimePicker() {
        DateRangePickerOptions options = this.getDateRangePickerOptions();
        this.dateRangePicker.setup(options, (start, end, label) -> {
            this.selectedDate = start.milliseconds(0).asDate();
            this.dateRangePicker.getElement().setAttribute("placeholder", DateUtils.getDateTimeStr((Date)this.selectedDate));
        });
    }

    protected DateRangePickerOptions getDateRangePickerOptions() {
        DateRangePickerOptions options = DateRangePickerOptions.create();
        options.setAutoUpdateInput(Boolean.valueOf(false));
        options.setAutoApply(Boolean.valueOf(true));
        options.setTimePicker(Boolean.valueOf(true));
        options.setTimePickerIncrement(1);
        options.setSingleDatePicker(Boolean.valueOf(true));
        options.setMinDate(Moment.Builder.moment());
        options.setParentEl("[data-field='modal']");
        if (this.selectedDate != null) {
            options.setStartDate(Moment.Builder.moment((Long)this.selectedDate.getTime()));
        }
        return options;
    }

    @EventHandler(value={"updateTaskButton"})
    public void updateTaskButton(ClickEvent e) {
        this.presenter.updateTask(this.taskDescriptionTextArea.getText(), this.selectedDate != null ? this.selectedDate : null, Integer.valueOf(this.taskPriorityListBox.getValue()));
    }

    @Override
    public void setTaskDescription(String text) {
        this.taskDescriptionTextArea.setText(text);
    }

    @Override
    public void setSelectedDate(Date date) {
        if (date != null) {
            this.selectedDate = date;
            this.setupDateTimePicker();
            this.dateRangePicker.getElement().setAttribute("placeholder", DateUtils.getDateTimeStr((Date)this.selectedDate));
        }
    }

    @Override
    public void setUser(String user) {
        this.userText.setText(user);
    }

    @Override
    public void setTaskStatus(String status) {
        this.taskStatusText.setText(status);
    }

    @Override
    public void setTaskPriority(String priority) {
        this.taskPriorityListBox.setValue((Object)priority);
    }

    @Override
    public void setTaskDescriptionEnabled(Boolean enabled) {
        this.taskDescriptionTextArea.setEnabled(enabled.booleanValue());
    }

    @Override
    public void setDueDateEnabled(Boolean enabled) {
        this.dateRangePickerInput.setVisible(enabled.booleanValue());
        this.dueDateText.setVisible(enabled == false);
        this.dueDateText.setText(DateUtils.getDateTimeStr((Date)this.selectedDate));
    }

    @Override
    public void setTaskPriorityEnabled(Boolean enabled) {
        this.taskPriorityListBox.setEnabled(enabled.booleanValue());
        this.refreshPriorities();
    }

    @Override
    public void setProcessInstanceId(String piid) {
        this.processInstanceIdLabel.setVisible(!piid.isEmpty());
        this.processInstanceIdText.setText(piid);
    }

    @Override
    public void setProcessId(String pid) {
        this.processIdLabel.setVisible(!pid.isEmpty());
        this.processIdText.setText(pid);
    }

    @Override
    public void setUpdateTaskVisible(Boolean enabled) {
        this.updateTaskButton.setVisible(enabled.booleanValue());
    }

    private void refreshPriorities() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                TaskDetailsViewImpl.this.taskPriorityListBox.refresh();
            }
        });
    }

    @Override
    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }
}

