/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.tasklogs;

import com.google.gwt.user.client.TakesValue;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.util.AbstractView;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.ht.client.editors.tasklogs.TaskLogsPresenter;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.model.TaskEventSummary;
import org.jbpm.workbench.ht.util.TaskEventType;

@Dependent
@Templated
public class TaskLogItemView
extends AbstractView<TaskLogsPresenter>
implements TakesValue<TaskEventSummary>,
IsElement {
    Constants constants = Constants.INSTANCE;
    @Inject
    private TranslationService translationService;
    @Inject
    @DataField(value="list-group-item")
    Div listGroupItem;
    @Inject
    @DataField(value="logIcon")
    Span logIcon;
    @Inject
    @DataField(value="logTime")
    Span logTime;
    @Inject
    @DataField(value="logTypeDesc")
    Span logTypeDesc;
    @Inject
    @DataField(value="logInfo")
    Span logInfo;
    @Inject
    @AutoBound
    private DataBinder<TaskEventSummary> logSummary;

    @PostConstruct
    public void init() {
        this.tooltip((HTMLElement)this.logIcon);
    }

    public HTMLElement getElement() {
        return this.listGroupItem;
    }

    public TaskEventSummary getValue() {
        return (TaskEventSummary)this.logSummary.getModel();
    }

    public void setValue(TaskEventSummary model) {
        String iconClass = "list-view-pf-icon-sm kie-timeline-list-view-pf-icon-sm";
        this.logSummary.setModel((Object)model);
        this.tooltip((HTMLElement)this.logTime);
        this.logTime.setTextContent(DateUtils.getPrettyTime((Date)model.getLogTime()));
        this.logTime.setAttribute("data-original-title", DateUtils.getDateTimeStr((Date)model.getLogTime()));
        String logInfoContent = this.constants.ByUser() + " " + model.getUserId() + " ";
        TaskEventType type = TaskEventType.valueOf((String)model.getType());
        switch (type) {
            case ADDED: {
                logInfoContent = model.getUserId() != null && !model.getUserId().isEmpty() ? this.constants.ByProcess() + " '" + model.getUserId() + "' " : "";
                iconClass = iconClass + " fa fa-cogs";
                break;
            }
            case ACTIVATED: 
            case CREATED: 
            case FORWARDED: 
            case RESUMED: 
            case DELEGATED: 
            case NOMINATED: {
                iconClass = iconClass + " fa fa-cogs";
                break;
            }
            case STOPPED: 
            case EXITED: 
            case FAILED: 
            case SKIPPED: 
            case SUSPENDED: {
                iconClass = iconClass + " fa fa-cogs";
                iconClass = iconClass + " kie-timeline-icon--completed";
                break;
            }
            case UPDATED: {
                iconClass = iconClass + " fa fa-user";
                logInfoContent = logInfoContent + " (" + model.getMessage() + " ) ";
                break;
            }
            case CLAIMED: 
            case STARTED: {
                iconClass = iconClass + " fa fa-user";
                break;
            }
            case COMPLETED: 
            case RELEASED: {
                iconClass = iconClass + " fa fa-user";
                iconClass = iconClass + " kie-timeline-icon--completed";
                break;
            }
            default: {
                iconClass = iconClass + " fa fa-cogs";
            }
        }
        this.tooltip((HTMLElement)this.logIcon);
        String logString = this.constants.Task() + " " + this.translationService.format(type.getTypeTranslationId(), new Object[0]).toLowerCase();
        this.logIcon.setAttribute("data-original-title", logString);
        this.logIcon.setClassName(iconClass);
        this.logTypeDesc.setTextContent(logString);
        this.logInfo.setTextContent(logInfoContent);
    }
}

