/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetLookupFactory;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItem;
import org.jbpm.workbench.common.client.filters.basic.BasicFiltersPresenter;
import org.jbpm.workbench.common.client.util.DateRange;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.client.util.TaskUtils;

public abstract class AbstractTaskListBasicFiltersPresenter
extends BasicFiltersPresenter {
    private Constants constants = Constants.INSTANCE;
    private TranslationService translationService;

    public void loadFilters() {
        this.view.addNumericFilter(this.constants.Id(), this.constants.FilterByTaskId(), f -> this.addSearchFilter((ActiveFilterItem)f, FilterFactory.equalsTo((String)"taskId", (Comparable)((Comparable)f.getValue()))));
        this.view.addTextFilter(this.constants.Task(), this.constants.FilterByTaskName(), f -> this.addSearchFilter((ActiveFilterItem)f, FilterFactory.likeTo((String)"name", (String)((String)f.getValue()), (boolean)false)));
        Map<String, String> status = TaskUtils.getStatusByType(TaskUtils.TaskType.ALL).stream().sorted().collect(Collectors.toMap(key -> key, value -> this.translationService.format(value, new Object[0])));
        this.view.addMultiSelectFilter(this.constants.Status(), status, f -> this.addSearchFilterList("status", (ActiveFilterItem)f));
        this.view.addTextFilter(this.constants.Process_Instance_Correlation_Key(), this.constants.FilterByCorrelationKey(), f -> this.addSearchFilter((ActiveFilterItem)f, FilterFactory.likeTo((String)"correlationKey", (String)((String)f.getValue()), (boolean)false)));
        this.view.addTextFilter(this.constants.Actual_Owner(), this.constants.FilterByActualOwner(), f -> this.addSearchFilter((ActiveFilterItem)f, FilterFactory.likeTo((String)"actualOwner", (String)((String)f.getValue()), (boolean)false)));
        this.view.addTextFilter(this.constants.Process_Instance_Description(), this.constants.FilterByProcessInstanceDescription(), f -> this.addSearchFilter((ActiveFilterItem)f, FilterFactory.likeTo((String)"processInstanceDescription", (String)((String)f.getValue()), (boolean)false)));
        this.addTaskNameFilter(this.getDataSetId());
        this.addProcessNameFilter(this.getDataSetId());
        this.view.addDateRangeFilter(this.constants.Created_On(), this.constants.Created_On_Placeholder(), Boolean.valueOf(true), f -> this.addSearchFilter((ActiveFilterItem)f, FilterFactory.between((String)"createdOn", (Comparable)((DateRange)f.getValue()).getStartDate(), (Comparable)((DateRange)f.getValue()).getEndDate())));
    }

    protected void addTaskNameFilter(String dataSetId) {
        DataSetLookup dataSetLookup = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset(dataSetId)).group("name")).column("name")).sort("name", SortOrder.ASCENDING)).buildLookup();
        this.view.addDataSetSelectFilter(this.constants.Task_Name(), dataSetLookup, "name", "name", f -> this.addSearchFilter((ActiveFilterItem)f, FilterFactory.equalsTo((String)"name", (Comparable)((Comparable)f.getValue()))));
    }

    protected void addProcessNameFilter(String dataSetId) {
        DataSetLookup dataSetLookup = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset(dataSetId)).group("processId")).column("processId")).sort("processId", SortOrder.ASCENDING)).buildLookup();
        this.view.addDataSetSelectFilter(this.constants.Process_Definition_Id(), dataSetLookup, "processId", "processId", f -> this.addSearchFilter((ActiveFilterItem)f, FilterFactory.equalsTo((String)"processId", (Comparable)((Comparable)f.getValue()))));
    }

    protected void addDeploymentIdFilter(String dataSetId) {
        DataSetLookup dataSetLookup = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset(dataSetId)).group("deploymentId")).column("deploymentId")).sort("deploymentId", SortOrder.ASCENDING)).buildLookup();
        this.view.addDataSetSelectFilter(this.constants.DeploymentId(), dataSetLookup, "deploymentId", "deploymentId", f -> this.addSearchFilter((ActiveFilterItem)f, FilterFactory.equalsTo((String)"deploymentId", (Comparable)((Comparable)f.getValue()))));
    }

    @Inject
    public void setTranslationService(TranslationService translationService) {
        this.translationService = translationService;
    }

    protected void onActiveFilterAdded(ActiveFilterItem activeFilterItem) {
        if (activeFilterItem.getKey().equals(this.constants.Status()) && activeFilterItem.getValue() instanceof List) {
            List values = (List)activeFilterItem.getValue();
            values.forEach(v -> this.view.checkSelectFilter(this.constants.Status(), v));
        }
    }
}

