/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.DataSetOpType;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.workbench.common.client.dataset.ErrorHandlerBuilder;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.MultiGridView;
import org.jbpm.workbench.common.client.menu.RefreshMenuBuilder;
import org.jbpm.workbench.common.client.util.DataSetUtils;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.DataSetQueryHelper;
import org.jbpm.workbench.ht.client.editors.taskslist.TaskSummaryDataSetMapper;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.model.TaskSummary;
import org.jbpm.workbench.ht.model.events.AbstractTaskEvent;
import org.jbpm.workbench.ht.model.events.TaskCompletedEvent;
import org.jbpm.workbench.ht.model.events.TaskRefreshedEvent;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.jbpm.workbench.ht.service.TaskService;
import org.jbpm.workbench.ht.util.TaskStatus;
import org.uberfire.client.workbench.events.BeforeClosePlaceEvent;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

public abstract class AbstractTaskListPresenter<V extends TaskListView>
extends AbstractMultiGridPresenter<TaskSummary, V> {
    protected Constants constants = Constants.INSTANCE;
    private Caller<TaskService> taskService;
    private DataSetQueryHelper dataSetQueryHelperDomainSpecific;
    protected TranslationService translationService;
    @Inject
    private Event<TaskSelectionEvent> taskSelected;
    private TaskSummary selectedTask = null;

    public abstract void setupDetailBreadcrumb(String var1);

    public void openErrorView(String tId) {
        DefaultPlaceRequest request = new DefaultPlaceRequest("ExecutionErrors");
        request.addParameter("isErrorAck", Boolean.toString(false));
        request.addParameter("taskId", tId);
        request.addParameter("errorType", this.constants.Task());
        this.placeManager.goTo((PlaceRequest)request);
    }

    public Predicate<TaskSummary> getViewErrorsActionCondition() {
        return tId -> this.isUserAuthorizedForPerspective("ExecutionErrors") && tId.getErrorCount() != null && tId.getErrorCount() > 0;
    }

    protected DataSetReadyCallback getDataSetReadyCallback(Integer startRange, FilterSettings tableSettings) {
        return ((ErrorHandlerBuilder)this.errorHandlerBuilder.get()).withUUID(tableSettings.getUUID()).withDataSetCallback(dataSet -> {
            if (dataSet != null && this.dataSetQueryHelper.getCurrentTableSettings().getKey().equals(tableSettings.getKey())) {
                List ops;
                String filterValue;
                ArrayList<TaskSummary> myTasksFromDataSet = new ArrayList<TaskSummary>();
                for (int i = 0; i < dataSet.getRowCount(); ++i) {
                    myTasksFromDataSet.add(new TaskSummaryDataSetMapper().apply((DataSet)dataSet, i));
                }
                boolean lastPageExactCount = false;
                if (dataSet.getRowCount() < ((TaskListView)this.view).getListGrid().getPageSize()) {
                    lastPageExactCount = true;
                }
                if ((filterValue = this.isFilteredByTaskName(ops = tableSettings.getDataSetLookup().getOperationList())) != null) {
                    this.getDomainSpecifDataForTasks(startRange, myTasksFromDataSet, lastPageExactCount);
                } else {
                    this.updateDataOnCallback(myTasksFromDataSet, startRange, startRange + myTasksFromDataSet.size(), lastPageExactCount);
                }
            }
            ((TaskListView)this.view).hideBusyIndicator();
        }).withEmptyResultsCallback(() -> this.setEmptyResults());
    }

    protected void removeActiveFilter(ColumnFilter columnFilter) {
        super.removeActiveFilter(columnFilter);
        if (this.isFilteredByTaskName(columnFilter) != null) {
            ((TaskListView)this.view).removeDomainSpecifColumns();
        }
    }

    protected String isFilteredByTaskName(List<DataSetOp> ops) {
        for (DataSetOp dataSetOp : ops) {
            if (!dataSetOp.getType().equals((Object)DataSetOpType.FILTER)) continue;
            List filters = ((DataSetFilter)dataSetOp).getColumnFilterList();
            for (ColumnFilter filter : filters) {
                String taskName = this.isFilteredByTaskName(filter);
                if (taskName == null) continue;
                return taskName;
            }
        }
        return null;
    }

    protected String isFilteredByTaskName(ColumnFilter filter) {
        if (filter instanceof CoreFunctionFilter) {
            List parameters;
            CoreFunctionFilter coreFilter = (CoreFunctionFilter)filter;
            if (filter.getColumnId().toUpperCase().equals("name".toUpperCase()) && ((CoreFunctionFilter)filter).getType() == CoreFunctionType.EQUALS_TO && (parameters = coreFilter.getParameters()).size() > 0) {
                return parameters.get(0).toString();
            }
        }
        return null;
    }

    public void getDomainSpecifDataForTasks(Integer startRange, List<TaskSummary> tasksFromDataSet, Boolean lastPageExactCount) {
        List taskIds = tasksFromDataSet.stream().map(t -> (Long)t.getId()).collect(Collectors.toList());
        FilterSettings variablesTableSettings = this.filterSettingsManager.getVariablesFilterSettings(taskIds);
        variablesTableSettings.setTablePageSize(-1);
        variablesTableSettings.setServerTemplateId(this.getSelectedServerTemplate());
        this.dataSetQueryHelperDomainSpecific.setDataSetHandler(variablesTableSettings);
        this.dataSetQueryHelperDomainSpecific.setCurrentTableSettings(variablesTableSettings);
        this.dataSetQueryHelperDomainSpecific.setLastOrderedColumn("taskId");
        this.dataSetQueryHelperDomainSpecific.setLastSortOrder(SortOrder.ASCENDING);
        this.dataSetQueryHelperDomainSpecific.lookupDataSet(Integer.valueOf(0), this.createDataSetDomainSpecificCallback(startRange, tasksFromDataSet, variablesTableSettings, lastPageExactCount));
    }

    protected DataSetReadyCallback createDataSetDomainSpecificCallback(int startRange, List<TaskSummary> instances, FilterSettings tableSettings, boolean lastPageExactCount) {
        return ((ErrorHandlerBuilder)this.errorHandlerBuilder.get()).withUUID(tableSettings.getUUID()).withDataSetCallback(dataSet -> {
            if (dataSet.getRowCount() > 0) {
                HashSet<String> columns = new HashSet<String>();
                for (int i = 0; i < dataSet.getRowCount(); ++i) {
                    Long taskId = DataSetUtils.getColumnLongValue((DataSet)dataSet, (String)"taskId", (int)i);
                    String variableName = DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"name", (int)i);
                    String variableValue = DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"value", (int)i);
                    for (TaskSummary task : instances) {
                        if (!((Long)task.getId()).equals(taskId)) continue;
                        task.addDomainData(variableName, variableValue);
                        columns.add(variableName);
                    }
                }
                ((TaskListView)this.view).addDomainSpecifColumns(columns);
            }
            this.updateDataOnCallback(instances, startRange, startRange + instances.size(), lastPageExactCount);
        }).withEmptyResultsCallback(() -> this.setEmptyResults());
    }

    public void releaseTask(final TaskSummary task) {
        ((TaskService)this.taskService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                ((TaskListView)AbstractTaskListPresenter.this.view).displayNotification(AbstractTaskListPresenter.this.constants.TaskReleased(String.valueOf(task.getId())));
                AbstractTaskListPresenter.this.refreshGrid();
            }
        })).releaseTask(this.getSelectedServerTemplate(), task.getDeploymentId(), (Long)task.getId());
    }

    public void claimTask(final TaskSummary task) {
        ((TaskService)this.taskService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                ((TaskListView)AbstractTaskListPresenter.this.view).displayNotification(AbstractTaskListPresenter.this.constants.TaskClaimed(String.valueOf(task.getId())));
                AbstractTaskListPresenter.this.refreshGrid();
            }
        })).claimTask(this.getSelectedServerTemplate(), task.getDeploymentId(), (Long)task.getId());
    }

    public void claimAndWorkTask(final TaskSummary task) {
        ((TaskService)this.taskService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                ((TaskListView)AbstractTaskListPresenter.this.view).displayNotification(AbstractTaskListPresenter.this.constants.TaskClaimed(String.valueOf(task.getId())));
                AbstractTaskListPresenter.this.selectSummaryItem(task);
                AbstractTaskListPresenter.this.refreshGrid();
            }
        })).claimTask(this.getSelectedServerTemplate(), task.getDeploymentId(), (Long)task.getId());
    }

    public void resumeTask(final TaskSummary task) {
        ((TaskService)this.taskService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                ((TaskListView)AbstractTaskListPresenter.this.view).displayNotification(AbstractTaskListPresenter.this.constants.TaskResumed(String.valueOf(task.getId())));
                AbstractTaskListPresenter.this.refreshGrid();
            }
        })).resumeTask(this.getSelectedServerTemplate(), task.getDeploymentId(), (Long)task.getId());
    }

    public void suspendTask(final TaskSummary task) {
        ((TaskService)this.taskService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                ((TaskListView)AbstractTaskListPresenter.this.view).displayNotification(AbstractTaskListPresenter.this.constants.TaskSuspended(String.valueOf(task.getId())));
                AbstractTaskListPresenter.this.refreshGrid();
            }
        })).suspendTask(this.getSelectedServerTemplate(), task.getDeploymentId(), (Long)task.getId());
    }

    public Menus getMenus() {
        return ((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).build();
    }

    public void selectSummaryItem(TaskSummary summary) {
        boolean logOnly = false;
        if (TaskStatus.TASK_STATUS_COMPLETED.equals((Object)summary.getTaskStatus()) || TaskStatus.TASK_STATUS_EXITED.equals((Object)summary.getTaskStatus())) {
            logOnly = true;
        }
        this.setupDetailBreadcrumb(this.constants.TaskBreadcrumb((Long)summary.getId()));
        this.placeManager.goTo("TaskDetailsScreen");
        this.fireTaskSelectionEvent(summary, logOnly);
        this.selectedTask = summary;
    }

    private void fireTaskSelectionEvent(TaskSummary summary, boolean logOnly) {
        this.taskSelected.fire((Object)new TaskSelectionEvent(this.getSelectedServerTemplate(), summary.getDeploymentId(), (Long)summary.getId(), summary.getName(), Boolean.valueOf(summary.isForAdmin()), Boolean.valueOf(logOnly), summary.getDescription(), summary.getExpirationTime(), summary.getStatus(), summary.getActualOwner(), summary.getPriority(), summary.getProcessInstanceId(), summary.getProcessId()));
    }

    public void onTaskRefreshedEvent(@Observes TaskRefreshedEvent event) {
        this.refreshGrid();
    }

    public void onTaskDetailsClosed(@Observes BeforeClosePlaceEvent closed) {
        if ("TaskDetailsScreen".equals(closed.getPlace().getIdentifier())) {
            this.selectedTask = null;
        }
    }

    public void onTaskCompletedEvent(@Observes TaskCompletedEvent event) {
        if (this.isSameTaskFromEvent().test((AbstractTaskEvent)event)) {
            this.refreshGrid();
        }
    }

    protected Predicate<AbstractTaskEvent> isSameTaskFromEvent() {
        return e -> this.selectedTask != null && e.getServerTemplateId().equals(this.getSelectedServerTemplate()) && e.getContainerId().equals(this.selectedTask.getDeploymentId()) && e.getTaskId().equals(this.selectedTask.getId());
    }

    @Inject
    public void setDataSetQueryHelperDomainSpecific(DataSetQueryHelper dataSetQueryHelperDomainSpecific) {
        this.dataSetQueryHelperDomainSpecific = dataSetQueryHelperDomainSpecific;
    }

    @Inject
    public void setTaskService(Caller<TaskService> taskService) {
        this.taskService = taskService;
    }

    public void setupActiveSearchFilters() {
        Optional processInstIdSearch = this.getSearchParameter("processInstanceId");
        if (processInstIdSearch.isPresent()) {
            String processInstId = (String)processInstIdSearch.get();
            this.addActiveFilter(FilterFactory.equalsTo((String)"processInstanceId", (Comparable)Integer.valueOf(processInstId)), this.constants.Process_Instance_Id(), processInstId, Integer.valueOf(processInstId), v -> this.removeActiveFilter(FilterFactory.equalsTo((String)"processInstanceId", (Comparable)v)));
        } else {
            Optional taskIdSearch = this.getSearchParameter("taskId");
            if (taskIdSearch.isPresent()) {
                String taskId = (String)taskIdSearch.get();
                this.addActiveFilter(FilterFactory.equalsTo((String)"taskId", (Comparable)Integer.valueOf(taskId)), this.constants.Task(), taskId, Integer.valueOf(taskId), v -> this.removeActiveFilter(FilterFactory.equalsTo((String)"taskId", (Comparable)v)));
            } else {
                super.setupActiveSearchFilters();
            }
        }
    }

    public void setupDefaultActiveSearchFilters() {
        List<String> status = Arrays.asList(TaskStatus.TASK_STATUS_READY.getIdentifier(), TaskStatus.TASK_STATUS_IN_PROGRESS.getIdentifier(), TaskStatus.TASK_STATUS_RESERVED.getIdentifier());
        List<String> statusLabels = Arrays.asList(this.translationService.format(TaskStatus.TASK_STATUS_READY.getIdentifier(), new Object[0]), this.translationService.format(TaskStatus.TASK_STATUS_IN_PROGRESS.getIdentifier(), new Object[0]), this.translationService.format(TaskStatus.TASK_STATUS_RESERVED.getIdentifier(), new Object[0]));
        this.addActiveFilter(FilterFactory.in((String)"status", status), this.constants.Status(), String.join((CharSequence)", ", statusLabels), status, v -> this.removeActiveFilter(FilterFactory.in((String)"status", (List)status)));
    }

    public void openProcessInstanceView(String processInstanceId) {
        this.navigateToPerspective("ProcessInstances", "processInstanceId", processInstanceId);
    }

    protected abstract Predicate<TaskSummary> getSuspendActionCondition();

    protected abstract Predicate<TaskSummary> getResumeActionCondition();

    protected Predicate<TaskSummary> getCompleteActionCondition() {
        return task -> task.getActualOwner() != null && TaskStatus.TASK_STATUS_IN_PROGRESS.equals((Object)task.getTaskStatus());
    }

    protected Predicate<TaskSummary> getClaimActionCondition() {
        return task -> TaskStatus.TASK_STATUS_READY.equals((Object)task.getTaskStatus());
    }

    protected Predicate<TaskSummary> getReleaseActionCondition() {
        return task -> TaskStatus.TASK_STATUS_RESERVED.equals((Object)task.getTaskStatus()) || TaskStatus.TASK_STATUS_IN_PROGRESS.equals((Object)task.getTaskStatus());
    }

    protected Predicate<TaskSummary> getProcessInstanceCondition() {
        return task -> task.getProcessInstanceId() != null;
    }

    @Inject
    public void setTranslationService(TranslationService translationService) {
        this.translationService = translationService;
    }

    protected TaskSummary getSelectedTask() {
        return this.selectedTask;
    }

    public static interface TaskListView<T extends AbstractTaskListPresenter>
    extends MultiGridView<TaskSummary, T> {
        public void addDomainSpecifColumns(Set<String> var1);

        public void removeDomainSpecifColumns();
    }
}

