/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskdetails;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.workbench.ht.client.editors.AbstractTaskPresenter;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.model.events.AbstractTaskEvent;
import org.jbpm.workbench.ht.model.events.TaskRefreshedEvent;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.jbpm.workbench.ht.service.TaskService;

@Dependent
public class TaskDetailsPresenter
extends AbstractTaskPresenter {
    @Inject
    private TranslationService translationService;
    @Inject
    protected Event<TaskRefreshedEvent> taskRefreshed;
    protected TaskDetailsView view;
    private Constants constants = Constants.INSTANCE;
    @Inject
    private Caller<TaskService> taskService;

    @Inject
    public TaskDetailsPresenter(TaskDetailsView view, Caller<TaskService> taskService, Event<TaskRefreshedEvent> taskRefreshed) {
        this.view = view;
        this.taskService = taskService;
        this.taskRefreshed = taskRefreshed;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public IsWidget getView() {
        return this.view;
    }

    public void updateTask(String taskDescription, Date dueDate, int priority) {
        if (this.getTaskId() != null) {
            ((TaskService)this.taskService.call(Void2 -> {
                this.view.displayNotification(this.constants.TaskDetailsUpdatedForTaskId(this.getTaskId()));
                this.taskRefreshed.fire((Object)new TaskRefreshedEvent(this.getServerTemplateId(), this.getContainerId(), this.getTaskId()));
            })).updateTask(this.getServerTemplateId(), this.getContainerId(), this.getTaskId(), Integer.valueOf(priority), taskDescription, dueDate);
        }
    }

    protected void setTaskDetails(String status, String description, String actualOwner, Date expirationTime, String priority, Long processInstanceId, String processId, Integer slaCompliance) {
        this.view.setTaskDescription(description);
        this.view.setSelectedDate(expirationTime);
        this.view.setUser(actualOwner);
        this.view.setTaskStatus(status);
        this.view.setTaskPriority(priority);
        this.view.setSlaCompliance(slaCompliance);
        if (processInstanceId == null) {
            this.view.setProcessInstanceId("");
            this.view.setProcessId("");
            return;
        }
        this.view.setProcessInstanceId(String.valueOf(processInstanceId));
        this.view.setProcessId(processId);
    }

    public void setReadOnlyTaskDetail() {
        this.view.setTaskDescriptionEnabled(false);
        this.view.setDueDateEnabled(false);
        this.view.setTaskPriorityEnabled(false);
        this.view.setUpdateTaskVisible(false);
    }

    public void onTaskSelectionEvent(@Observes TaskSelectionEvent event) {
        this.setSelectedTask(event);
        if (event.isForLog().booleanValue()) {
            this.setReadOnlyTaskDetail();
        }
        this.setTaskDetails(this.translationService.format(event.getStatus(), new Object[0]), event.getDescription(), event.getActualOwner(), event.getExpirationTime(), String.valueOf(event.getPriority()), event.getProcessInstanceId(), event.getProcessId(), event.getSlaCompliance());
    }

    public void onTaskRefreshedEvent(@Observes TaskRefreshedEvent event) {
        if (this.isSameTaskFromEvent().test((AbstractTaskEvent)event)) {
            ((TaskService)this.taskService.call(task -> {
                if (task != null) {
                    this.setTaskDetails(this.translationService.format(task.getStatus(), new Object[0]), task.getDescription(), task.getActualOwner(), task.getExpirationTime(), String.valueOf(task.getPriority()), task.getProcessInstanceId(), task.getProcessId(), task.getSlaCompliance());
                }
            })).getTask(this.getServerTemplateId(), this.getContainerId(), this.getTaskId());
        }
    }

    @Inject
    public void setTranslationService(TranslationService translationService) {
        this.translationService = translationService;
    }

    public static interface TaskDetailsView
    extends IsWidget {
        public void init(TaskDetailsPresenter var1);

        public void setTaskDescription(String var1);

        public void setTaskDescriptionEnabled(Boolean var1);

        public void setSelectedDate(Date var1);

        public void setDueDateEnabled(Boolean var1);

        public void setUser(String var1);

        public void setTaskStatus(String var1);

        public void setSlaCompliance(Integer var1);

        public void setTaskPriority(String var1);

        public void setProcessInstanceId(String var1);

        public void setProcessId(String var1);

        public void setTaskPriorityEnabled(Boolean var1);

        public void setUpdateTaskVisible(Boolean var1);

        public void displayNotification(String var1);
    }
}

