/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.quicknewtask;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Column;
import org.gwtbootstrap3.client.ui.FieldSet;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.InputGroup;
import org.gwtbootstrap3.client.ui.InputGroupButton;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TabListItem;
import org.gwtbootstrap3.client.ui.TabPane;
import org.gwtbootstrap3.client.ui.TabPanel;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.ColumnSize;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.common.client.util.UTCDateBox;
import org.jbpm.workbench.common.client.util.UTCTimeBox;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class QuickNewTaskPopup
extends BaseModal {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    private final List<FormGroup> userControlGroups = new ArrayList<FormGroup>();
    private final List<FormGroup> groupControlGroups = new ArrayList<FormGroup>();
    @UiField
    public TabPanel tabPanel;
    @UiField
    public TabListItem basicTab;
    @UiField
    public TabListItem taskformTab;
    @UiField
    public TabListItem advancedTab;
    @UiField
    public TabPane basicTabPane;
    @UiField
    public TabPane taskformTabPane;
    @UiField
    public TabPane advancedTabPane;
    @UiField
    public Button addUserButton;
    @UiField
    public Button addGroupButton;
    @UiField
    public TextBox taskNameText;
    @UiField
    public FormGroup taskNameControlGroup;
    @UiField
    public UTCDateBox dueDate;
    @UiField
    public UTCTimeBox dueDateTime;
    @UiField
    public HelpBlock taskNameHelpLabel;
    @UiField
    public ListBox taskPriorityListBox;
    @UiField
    public FieldSet controlsPanel;
    @UiField
    public HelpBlock errorMessages;
    @UiField
    public FormGroup errorMessagesGroup;
    @UiField
    public ListBox taskFormDeploymentId;
    @UiField
    public FormGroup taskFormDeploymentIdControlGroup;
    @UiField
    public HelpBlock taskFormDeploymentIdHelpLabel;
    @UiField
    public ListBox taskFormName;
    @UiField
    public FormGroup taskFormNameControlGroup;
    @UiField
    public HelpBlock taskFormNameHelpLabel;
    @Inject
    User identity;
    @Inject
    private Event<NotificationEvent> notification;
    private HandlerRegistration textKeyPressHandler;
    private String[] priorities = new String[]{"0 - " + Constants.INSTANCE.High(), "1", "2", "3", "4", "5 - " + Constants.INSTANCE.Medium(), "6", "7", "8", "9", "10 - " + Constants.INSTANCE.Low()};
    private Long processInstanceId = -1L;

    public QuickNewTaskPopup() {
        this.setTitle(Constants.INSTANCE.New_Task());
        this.setBody((Widget)uiBinder.createAndBindUi((Object)this));
        this.basicTab.setDataTargetWidget((Widget)this.basicTabPane);
        this.taskformTab.setDataTargetWidget((Widget)this.taskformTabPane);
        this.advancedTab.setDataTargetWidget((Widget)this.advancedTabPane);
        this.dueDate.getDateBox().setContainer((Widget)this);
        this.init();
        GenericModalFooter footer = new GenericModalFooter();
        footer.addButton(Constants.INSTANCE.Create(), new Command(){

            public void execute() {
                QuickNewTaskPopup.this.okButton();
            }
        }, IconType.PLUS, ButtonType.PRIMARY);
        this.add((Widget)footer);
    }

    public void show(Long processInstanceId) {
        this.show();
        this.processInstanceId = processInstanceId;
    }

    public void show() {
        this.cleanForm();
        super.show();
    }

    private void okButton() {
        if (this.validateForm()) {
            this.addTask();
        }
    }

    public void init() {
        long day = new Long(86400000L);
        long now = System.currentTimeMillis();
        this.dueDate.setEnabled(true);
        this.dueDate.setValue(Long.valueOf(day + now));
        this.dueDateTime.setValue(UTCTimeBox.getValueForNextHour());
        this.refreshUserGroupControls();
        KeyPressHandler keyPressHandlerText = new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                QuickNewTaskPopup.this.clearErrorMessages();
                if (event.getNativeEvent().getKeyCode() == 13) {
                    QuickNewTaskPopup.this.addTask();
                }
            }
        };
        this.textKeyPressHandler = this.taskNameText.addKeyPressHandler(keyPressHandlerText);
        this.taskNameText.setFocus(true);
        for (String priority : this.priorities) {
            this.taskPriorityListBox.addItem(priority);
        }
        this.addUserButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                QuickNewTaskPopup.this.addUserControl(false);
                QuickNewTaskPopup.this.refreshUserGroupControls();
            }
        });
        this.addGroupButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                QuickNewTaskPopup.this.addGroupControl();
                QuickNewTaskPopup.this.refreshUserGroupControls();
            }
        });
    }

    public void cleanForm() {
        this.basicTab.showTab();
        this.basicTab.setActive(true);
        this.advancedTab.setActive(false);
        this.userControlGroups.clear();
        this.groupControlGroups.clear();
        this.clearErrorMessages();
        this.taskNameText.setValue((Object)"");
        long day = new Long(86400000L);
        long now = System.currentTimeMillis();
        this.dueDate.setEnabled(true);
        this.dueDate.setValue(Long.valueOf(day + now));
        this.dueDateTime.setValue(UTCTimeBox.getValueForNextHour());
        this.setSelectedValue(this.taskPriorityListBox, "0");
        this.addUserControl(true);
        this.refreshUserGroupControls();
        this.taskNameText.setFocus(true);
        this.taskFormDeploymentId.clear();
        this.setSelectedValue(this.taskFormDeploymentId, "");
        this.taskFormName.clear();
        this.setSelectedValue(this.taskFormName, "");
        this.processInstanceId = -1L;
    }

    public void closePopup() {
        this.cleanForm();
        this.hide();
    }

    protected boolean validateForm() {
        boolean valid = true;
        this.clearErrorMessages();
        if (this.taskNameText.getText() != null && this.taskNameText.getText().trim().length() == 0) {
            this.basicTab.showTab();
            this.taskNameText.setFocus(true);
            this.taskNameHelpLabel.setText(Constants.INSTANCE.Task_Must_Have_A_Name());
            this.taskNameControlGroup.setValidationState(ValidationState.ERROR);
            valid = false;
        } else {
            this.taskNameControlGroup.setValidationState(ValidationState.SUCCESS);
        }
        return valid;
    }

    private void refreshUserGroupControls() {
        ArrayList<Widget> widgets2Remove = new ArrayList<Widget>(this.controlsPanel.getWidgetCount());
        for (int i = 0; i < this.controlsPanel.getWidgetCount(); ++i) {
            if (!"yes".equals(this.controlsPanel.getWidget(i).getElement().getPropertyString("isDynamic"))) continue;
            widgets2Remove.add(this.controlsPanel.getWidget(i));
        }
        for (Widget widget : widgets2Remove) {
            this.controlsPanel.remove(widget);
        }
        widgets2Remove.clear();
        for (FormGroup userGroupControl : this.userControlGroups) {
            this.controlsPanel.add((Widget)userGroupControl);
        }
        for (FormGroup groupGroupControl : this.groupControlGroups) {
            this.controlsPanel.add((Widget)groupGroupControl);
        }
    }

    private void addUserControl(final Boolean addCurrentUser) {
        final FormGroup userControlGroup = new FormGroup();
        userControlGroup.getElement().setPropertyString("isDynamic", "yes");
        userControlGroup.add((Widget)new FormLabel(){
            {
                this.setText(Constants.INSTANCE.User());
                this.addStyleName(ColumnSize.MD_3.getCssName());
                this.setFor("userTextBox");
            }
        });
        userControlGroup.add((Widget)new Column(ColumnSize.MD_9, new ColumnSize[0]){
            {
                super(x0, x1);
                this.add((Widget)new InputGroup(){
                    {
                        this.add((Widget)new TextBox(){
                            {
                                this.setName("userTextBox");
                                if (addCurrentUser.booleanValue()) {
                                    this.setText(QuickNewTaskPopup.this.identity.getIdentifier());
                                }
                            }
                        });
                        this.add((Widget)new InputGroupButton(){
                            {
                                this.add((Widget)new Button(){
                                    {
                                        this.setIcon(IconType.TRASH);
                                        this.setType(ButtonType.DANGER);
                                        this.setTitle(Constants.INSTANCE.Remove_User());
                                        this.addClickHandler(new ClickHandler(){

                                            public void onClick(ClickEvent event) {
                                                QuickNewTaskPopup.this.userControlGroups.remove(userControlGroup);
                                                QuickNewTaskPopup.this.refreshUserGroupControls();
                                            }
                                        });
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
        this.userControlGroups.add(userControlGroup);
    }

    private void addGroupControl() {
        final FormGroup groupControlGroup = new FormGroup();
        groupControlGroup.getElement().setPropertyString("isDynamic", "yes");
        groupControlGroup.add((Widget)new FormLabel(){
            {
                this.setText(Constants.INSTANCE.Group());
                this.addStyleName(ColumnSize.MD_3.getCssName());
                this.setFor("groupTextBox");
            }
        });
        groupControlGroup.add((Widget)new Column(ColumnSize.MD_9, new ColumnSize[0]){
            {
                super(x0, x1);
                this.add((Widget)new InputGroup(){
                    {
                        this.add((Widget)new TextBox(){
                            {
                                this.setName("groupTextBox");
                            }
                        });
                        this.add((Widget)new InputGroupButton(){
                            {
                                this.add((Widget)new Button(){
                                    {
                                        this.setIcon(IconType.MINUS);
                                        this.setTitle(Constants.INSTANCE.Remove_User());
                                        this.addClickHandler(new ClickHandler(){

                                            public void onClick(ClickEvent event) {
                                                QuickNewTaskPopup.this.groupControlGroups.remove(groupControlGroup);
                                                QuickNewTaskPopup.this.refreshUserGroupControls();
                                            }
                                        });
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
        this.groupControlGroups.add(groupControlGroup);
    }

    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    private void addTask() {
        this.textKeyPressHandler.removeHandler();
        List<String> users = this.getTextBoxValues(this.userControlGroups);
        List<String> groups = this.getTextBoxValues(this.groupControlGroups);
        if (users.size() == 0 && groups.size() == 0) {
            this.userControlGroups.clear();
            this.groupControlGroups.clear();
            this.addUserControl(true);
            this.refreshUserGroupControls();
            this.errorMessages.setText(Constants.INSTANCE.Provide_User_Or_Group());
            this.errorMessagesGroup.setValidationState(ValidationState.ERROR);
            this.advancedTab.showTab();
        } else {
            this.addTask(users, groups, this.taskNameText.getText(), this.taskPriorityListBox.getSelectedIndex(), this.dueDate.getValue(), this.dueDateTime.getValue(), this.taskFormName.getSelectedValue(), this.taskFormDeploymentId.getSelectedValue(), this.processInstanceId);
        }
    }

    public void addTask(List<String> users, List<String> groups, String taskName, int priority, long dueDate, long dueDateTime, String taskFormName, String deploymentId, Long processInstanceId) {
    }

    public List<String> getTextBoxValues(List<FormGroup> controlGroups) {
        ArrayList<String> filledValues = new ArrayList<String>();
        for (FormGroup userGroupControl : controlGroups) {
            this.getTextBoxValues((Widget)userGroupControl, filledValues);
        }
        return filledValues;
    }

    private void getTextBoxValues(Widget widget, List<String> values) {
        String value;
        if (widget instanceof ComplexPanel) {
            for (Widget child : (ComplexPanel)widget) {
                this.getTextBoxValues(child, values);
            }
        } else if (widget instanceof TextBox && !(value = ((TextBox)widget).getText().trim()).isEmpty()) {
            values.add(value);
        }
    }

    private void clearErrorMessages() {
        this.errorMessages.setText("");
        this.taskNameHelpLabel.setText("");
        this.taskNameControlGroup.setValidationState(ValidationState.NONE);
    }

    void setSelectedValue(ListBox listbox, String value) {
        for (int i = 0; i < listbox.getItemCount(); ++i) {
            if (!listbox.getValue(i).equals(value)) continue;
            listbox.setSelectedIndex(i);
            return;
        }
    }

    static interface Binder
    extends UiBinder<Widget, QuickNewTaskPopup> {
    }
}

