/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.RowStyles;
import com.google.gwt.view.client.CellPreviewEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jbpm.workbench.common.client.list.AbstractMultiGridView;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.resources.CommonResources;
import org.jbpm.workbench.common.client.util.ConditionalButtonActionCell;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.common.client.util.TaskUtils;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListPresenter;
import org.jbpm.workbench.ht.client.resources.HumanTaskResources;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.model.TaskSummary;
import org.uberfire.ext.services.shared.preferences.GridColumnPreference;
import org.uberfire.ext.widgets.table.client.ColumnMeta;

public abstract class AbstractTaskListView<P extends AbstractTaskListPresenter>
extends AbstractMultiGridView<TaskSummary, P>
implements AbstractTaskListPresenter.TaskListView<P> {
    protected final Constants constants = Constants.INSTANCE;

    public List<String> getInitColumns() {
        return Arrays.asList("name", "processId", "status", "createdOn", "Actions");
    }

    public List<String> getBannedColumns() {
        return Arrays.asList("name", "Actions");
    }

    public String getNewFilterPopupTitle() {
        return Constants.INSTANCE.New_FilteredList();
    }

    public void initSelectionModel(final ExtendedPagedTable<TaskSummary> extendedPagedTable) {
        RowStyles<TaskSummary> selectedStyles = new RowStyles<TaskSummary>(){

            public String getStyleNames(TaskSummary row, int rowIndex) {
                if (rowIndex == extendedPagedTable.getSelectedRow()) {
                    return CommonResources.INSTANCE.css().selected();
                }
                if (row.getStatus().equals(TaskUtils.TASK_STATUS_COMPLETED)) {
                    return HumanTaskResources.INSTANCE.css().taskCompleted();
                }
                return null;
            }
        };
        extendedPagedTable.setEmptyTableCaption(this.constants.No_Tasks_Found());
        extendedPagedTable.setSelectionCallback((task, close) -> ((AbstractTaskListPresenter)this.presenter).selectTask((TaskSummary)task, (Boolean)close));
        extendedPagedTable.setRowStyles((RowStyles)selectedStyles);
    }

    public void initColumns(ExtendedPagedTable<TaskSummary> extendedPagedTable) {
        this.initCellPreview(extendedPagedTable);
        Column<TaskSummary, ?> actionsColumn = this.initActionsColumn();
        extendedPagedTable.addSelectionIgnoreColumn(actionsColumn);
        ArrayList<ColumnMeta<TaskSummary>> columnMetas = new ArrayList<ColumnMeta<TaskSummary>>();
        columnMetas.add(new ColumnMeta(this.createNumberColumn("taskId", task -> (Long)task.getId()), this.constants.Id()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("name", task -> task.getName()), this.constants.Task()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("description", task -> task.getDescription()), this.constants.Description()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("processId", task -> task.getProcessId()), this.constants.Process_Name()));
        columnMetas.add(new ColumnMeta(this.createNumberColumn("processInstanceId", task -> task.getProcessInstanceId()), this.constants.Process_Id()));
        columnMetas.add(new ColumnMeta(this.createNumberColumn("priority", task -> task.getPriority()), this.constants.Priority()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("status", task -> task.getStatus()), this.constants.Status()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("createdOn", task -> DateUtils.getDateTimeStr((Date)task.getCreatedOn())), this.constants.Created_On()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("dueDate", task -> DateUtils.getDateTimeStr((Date)task.getExpirationTime())), this.constants.Due_On()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("actualOwner", task -> task.getActualOwner()), this.constants.Actual_Owner()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("correlationKey", task -> task.getProcessInstanceCorrelationKey()), this.constants.Process_Instance_Correlation_Key()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("processInstanceDescription", task -> task.getProcessInstanceDescription()), this.constants.Process_Instance_Description()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("lastModificationDate", task -> DateUtils.getDateTimeStr((Date)task.getLastModificationDate())), this.constants.Last_Modification_Date()));
        columnMetas.add(new ColumnMeta(this.createNumberColumn("processSessionId", task -> task.getProcessSessionId()), this.constants.ProcessSessionId()));
        columnMetas.add(new ColumnMeta(actionsColumn, this.constants.Actions()));
        List columPreferenceList = extendedPagedTable.getGridPreferencesStore().getColumnPreferences();
        for (GridColumnPreference colPref : columPreferenceList) {
            if (this.isColumnAdded(columnMetas, colPref.getName())) continue;
            Column<TaskSummary, ?> genericColumn = this.initGenericColumn(colPref.getName());
            genericColumn.setSortable(false);
            columnMetas.add((ColumnMeta<TaskSummary>)new ColumnMeta(genericColumn, colPref.getName(), true, true));
        }
        extendedPagedTable.addColumns(columnMetas);
    }

    private void initCellPreview(final ExtendedPagedTable<TaskSummary> extendedPagedTable) {
        extendedPagedTable.addCellPreviewHandler((CellPreviewEvent.Handler)new CellPreviewEvent.Handler<TaskSummary>(){

            public void onCellPreview(CellPreviewEvent<TaskSummary> event) {
                if ("mouseover".equalsIgnoreCase(event.getNativeEvent().getType())) {
                    AbstractTaskListView.this.onMouseOverGrid((ExtendedPagedTable<TaskSummary>)extendedPagedTable, (CellPreviewEvent<TaskSummary>)event);
                }
            }
        });
    }

    private void onMouseOverGrid(ExtendedPagedTable<TaskSummary> extendedPagedTable, CellPreviewEvent<TaskSummary> event) {
        TaskSummary task = (TaskSummary)event.getValue();
        if (task.getDescription() != null) {
            extendedPagedTable.setTooltip(extendedPagedTable.getKeyboardSelectedRow(), event.getColumn(), task.getDescription());
        }
    }

    private Column<TaskSummary, ?> initActionsColumn() {
        LinkedList<ConditionalButtonActionCell> cells = new LinkedList<ConditionalButtonActionCell>();
        cells.add(new ConditionalButtonActionCell(this.constants.Claim(), task -> ((AbstractTaskListPresenter)this.presenter).claimTask((TaskSummary)task), ((AbstractTaskListPresenter)this.presenter).getClaimActionCondition()));
        cells.add(new ConditionalButtonActionCell(this.constants.Release(), task -> ((AbstractTaskListPresenter)this.presenter).releaseTask((TaskSummary)task), ((AbstractTaskListPresenter)this.presenter).getReleaseActionCondition()));
        cells.add(new ConditionalButtonActionCell(this.constants.Suspend(), task -> ((AbstractTaskListPresenter)this.presenter).suspendTask((TaskSummary)task), ((AbstractTaskListPresenter)this.presenter).getSuspendActionCondition()));
        cells.add(new ConditionalButtonActionCell(this.constants.Resume(), task -> ((AbstractTaskListPresenter)this.presenter).resumeTask((TaskSummary)task), ((AbstractTaskListPresenter)this.presenter).getResumeActionCondition()));
        cells.add(new ConditionalButtonActionCell(this.constants.ViewProcess(), task -> ((AbstractTaskListPresenter)this.presenter).openProcessInstanceView(task.getProcessInstanceId().toString()), ((AbstractTaskListPresenter)this.presenter).getProcessInstanceCondition()));
        cells.add(new ConditionalButtonActionCell(this.constants.Open(), task -> ((AbstractTaskListPresenter)this.presenter).selectTask((TaskSummary)task, false), ((AbstractTaskListPresenter)this.presenter).getCompleteActionCondition()));
        CompositeCell cell = new CompositeCell(cells);
        Column<TaskSummary, TaskSummary> actionsColumn = new Column<TaskSummary, TaskSummary>((Cell)cell){

            public TaskSummary getValue(TaskSummary object) {
                return object;
            }
        };
        actionsColumn.setDataStoreName("Actions");
        return actionsColumn;
    }

    private boolean isColumnAdded(List<ColumnMeta<TaskSummary>> columnMetas, String caption) {
        if (caption != null) {
            for (ColumnMeta<TaskSummary> colMet : columnMetas) {
                if (!caption.equals(colMet.getColumn().getDataStoreName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addDomainSpecifColumns(ExtendedPagedTable<TaskSummary> extendedPagedTable, Set<String> columns) {
        extendedPagedTable.storeColumnToPreferences();
        HashMap<String, String> modifiedCaptions = new HashMap<String, String>();
        ArrayList<ColumnMeta> existingExtraColumns = new ArrayList<ColumnMeta>();
        for (ColumnMeta cm : extendedPagedTable.getColumnMetaList()) {
            if (cm.isExtraColumn()) {
                existingExtraColumns.add(cm);
                continue;
            }
            if (!columns.contains(cm.getCaption())) continue;
            for (String c : columns) {
                if (!c.equals(cm.getCaption())) continue;
                modifiedCaptions.put(c, "Var_" + c);
            }
        }
        for (ColumnMeta colMet : existingExtraColumns) {
            if (!columns.contains(colMet.getCaption())) {
                extendedPagedTable.removeColumnMeta(colMet);
                continue;
            }
            columns.remove(colMet.getCaption());
        }
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        String caption = "";
        Iterator<String> iterator = columns.iterator();
        while (iterator.hasNext()) {
            String c;
            caption = c = iterator.next();
            if (modifiedCaptions.get(c) != null) {
                caption = (String)modifiedCaptions.get(c);
            }
            Column<TaskSummary, ?> genericColumn = this.initGenericColumn(c);
            genericColumn.setSortable(false);
            columnMetas.add(new ColumnMeta(genericColumn, caption, true, true));
        }
        extendedPagedTable.addColumns(columnMetas);
    }

    private Column<TaskSummary, ?> initGenericColumn(String key) {
        return this.createTextColumn(key, task -> task.getDomainDataValue(key));
    }

    @Override
    public void setSelectedTask(TaskSummary selectedTask) {
        this.currentListGrid.getSelectionModel().setSelected((Object)selectedTask, true);
    }
}

