/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskcomments;

import com.google.gwt.user.client.TakesValue;
import java.util.Date;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.common.client.dom.Window;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.ht.client.editors.taskcomments.TaskCommentsPresenter;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.model.CommentSummary;
import org.uberfire.client.views.pfly.widgets.ConfirmPopup;

@Dependent
@Templated
public class TaskCommentItemView
implements TakesValue<CommentSummary>,
IsElement {
    private Constants constants = Constants.INSTANCE;
    @Inject
    @DataField(value="comment-author")
    @Bound(property="addedBy")
    Span addedBy;
    @Inject
    @DataField(value="comment-text")
    @Bound(property="text")
    Span text;
    @Inject
    @DataField(value="icon-type")
    Span iconType;
    @Inject
    @DataField(value="comment-addedat")
    Span addedAt;
    @Inject
    @DataField(value="list-group-item")
    Div listGroupItem;
    @Inject
    @DataField(value="actions-dropdown")
    Div actions;
    @Inject
    @DataField(value="actions-button")
    Button actionsButton;
    @Inject
    @DataField(value="actions-items")
    UnorderedList actionsItems;
    @Inject
    ConfirmPopup confirmPopup;
    protected TaskCommentsPresenter presenter;
    @Inject
    @AutoBound
    private DataBinder<CommentSummary> commentSummary;

    public void init(TaskCommentsPresenter presenter) {
        this.presenter = presenter;
        this.updateActions(presenter.getDeleteCondition().test(this.getValue()));
    }

    public void setIconType(String iconTypeClass) {
        DOMUtil.addCSSClass((HTMLElement)this.iconType, (String)iconTypeClass);
    }

    public HTMLElement getElement() {
        return this.listGroupItem;
    }

    public void addAction(TaskCommentsPresenter.CommentAction action) {
        DOMUtil.removeCSSClass((HTMLElement)this.actionsButton, (String)"disabled");
        HTMLElement a = Window.getDocument().createElement("a");
        a.setTextContent(action.label());
        a.setOnclick(e -> action.execute());
        HTMLElement li = Window.getDocument().createElement("li");
        li.appendChild((Node)a);
        this.actionsItems.appendChild((Node)li);
    }

    public CommentSummary getValue() {
        return (CommentSummary)this.commentSummary.getModel();
    }

    public void setValue(CommentSummary model) {
        this.commentSummary.setModel((Object)model);
        this.addedAt.setTextContent(DateUtils.getPrettyTime((Date)model.getAddedAt()));
    }

    protected void updateActions(boolean editItem) {
        this.actionsItems.setInnerHTML("");
        if (this.presenter.getDeleteCondition().test(this.getValue())) {
            this.addAction(new TaskCommentsPresenter.CommentAction(){

                @Override
                public String label() {
                    return TaskCommentItemView.this.constants.Delete();
                }

                public void execute() {
                    TaskCommentItemView.this.confirmPopup.show(TaskCommentItemView.this.constants.DeleteCommentTitle(), TaskCommentItemView.this.constants.Delete(), TaskCommentItemView.this.constants.DeleteComment(TaskCommentItemView.this.getValue().getText()), () -> TaskCommentItemView.this.presenter.removeTaskComment(TaskCommentItemView.this.getValue().getId()));
                }
            });
        } else {
            this.setIconType("kie-no-highlight");
        }
    }
}

