/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskcomments;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.ht.client.editors.AbstractTaskPresenter;
import org.jbpm.workbench.ht.client.editors.taskcomments.TaskCommentsViewImpl;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.model.CommentSummary;
import org.jbpm.workbench.ht.model.events.AbstractTaskEvent;
import org.jbpm.workbench.ht.model.events.TaskCompletedEvent;
import org.jbpm.workbench.ht.model.events.TaskRefreshedEvent;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.jbpm.workbench.ht.service.TaskService;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.mvp.Command;

@Dependent
public class TaskCommentsPresenter
extends AbstractTaskPresenter {
    public static final int COMMENTS_PAGE_SIZE = 10;
    public static final int WORK_COMMENTS_PAGE_SIZE = 3;
    protected Caller<TaskService> taskService;
    protected Constants constants = Constants.INSTANCE;
    protected User identity;
    protected boolean forLog = false;
    protected boolean forAdmin = false;
    protected boolean sortAsc = false;
    protected int currentPage = 1;
    protected int pageSize = 10;
    public TaskCommentsView view;
    @Inject
    private ManagedInstance<TaskCommentsViewImpl> taskCommentsViewProvider;

    @PostConstruct
    public void init() {
        this.view = (TaskCommentsView)this.taskCommentsViewProvider.get();
        this.view.init(this);
    }

    public IsWidget getView() {
        return ElementWrapperWidget.getWidget((HTMLElement)this.view.getElement());
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void showCommentsHeader() {
        this.view.showCommentHeader();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public boolean isSortAsc() {
        return this.sortAsc;
    }

    public void setSortAsc(boolean sortAsc) {
        this.sortAsc = sortAsc;
    }

    private void loadTaskComments() {
        ((TaskService)this.taskService.call(allComments -> {
            if (allComments != null) {
                this.view.setCommentList(allComments.stream().sorted(this.isSortAsc() ? Comparator.comparing(CommentSummary::getAddedAt) : Comparator.comparing(CommentSummary::getAddedAt).reversed()).collect(Collectors.toList()).subList(0, Math.min(allComments.size(), this.getPageSize() * this.getCurrentPage())));
                if (allComments.size() <= this.getPageSize() * this.getCurrentPage()) {
                    this.view.hideLoadButton();
                } else {
                    this.view.showLoadButton();
                }
            }
        })).getTaskComments(this.getServerTemplateId(), this.getContainerId(), this.getTaskId());
    }

    public void refreshCommentsView() {
        this.setCurrentPage(1);
        this.view.clearCommentInputForm();
        this.loadTaskComments();
    }

    public void loadMoreTaskComments() {
        this.setCurrentPage(this.getCurrentPage() + 1);
        this.loadTaskComments();
    }

    public void sortComments(boolean sortAsc) {
        this.setSortAsc(sortAsc);
        this.refreshCommentsView();
    }

    public void addTaskComment(String text) {
        if (this.forLog) {
            return;
        }
        ((TaskService)this.taskService.call(response -> {
            this.refreshCommentsView();
            this.view.resetPagination();
        })).addTaskComment(this.getServerTemplateId(), this.getContainerId(), this.getTaskId(), text, new Date());
    }

    public void removeTaskComment(long commentId) {
        ((TaskService)this.taskService.call(response -> {
            this.refreshCommentsView();
            this.displayNotification(this.constants.CommentDeleted());
        })).deleteTaskComment(this.getServerTemplateId(), this.getContainerId(), this.getTaskId(), Long.valueOf(commentId));
    }

    public void onTaskSelectionEvent(@Observes TaskSelectionEvent event) {
        this.setSelectedTask(event);
        this.forAdmin = event.isForAdmin();
        this.forLog = event.isForLog();
        if (this.forLog) {
            this.view.disableNewComments();
        }
        this.refreshCommentsView();
    }

    public Predicate<CommentSummary> getDeleteCondition() {
        return c -> !this.forLog && (this.forAdmin || c.getAddedBy().equals(this.identity.getIdentifier()));
    }

    public void onTaskRefreshedEvent(@Observes TaskRefreshedEvent event) {
        if (this.isSameTaskFromEvent().test((AbstractTaskEvent)event)) {
            this.refreshCommentsView();
        }
    }

    public void onTaskCompletedEvent(@Observes TaskCompletedEvent event) {
        if (this.isSameTaskFromEvent().test((AbstractTaskEvent)event) && !this.forLog) {
            this.forLog = true;
            this.view.disableNewComments();
            this.refreshCommentsView();
        }
    }

    @Inject
    public void setTaskService(Caller<TaskService> taskService) {
        this.taskService = taskService;
    }

    @Inject
    public void setIdentity(User identity) {
        this.identity = identity;
    }

    public TaskCommentsView getTaskCommentView() {
        return this.view;
    }

    public static interface CommentAction
    extends Command {
        public String label();
    }

    public static interface TaskCommentsView
    extends UberElement<TaskCommentsPresenter> {
        public void disableNewComments();

        public void clearCommentInputForm();

        public void setCommentList(List<CommentSummary> var1);

        public void resetPagination();

        public void hideLoadButton();

        public void showLoadButton();

        public void showCommentHeader();
    }
}

