/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.tasklogs;

import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.MouseEvent;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.databinding.client.components.ListComponent;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.ht.client.editors.tasklogs.TaskLogItemView;
import org.jbpm.workbench.ht.client.editors.tasklogs.TaskLogsPresenter;
import org.jbpm.workbench.ht.model.TaskEventSummary;

@Dependent
@Templated(value="TaskLogsViewImpl.html")
public class TaskLogsViewImpl
implements TaskLogsPresenter.TaskLogsView {
    @Inject
    @DataField(value="container")
    private HTMLDivElement container;
    @Inject
    @Bound
    @DataField(value="logs-list")
    private ListComponent<TaskEventSummary, TaskLogItemView> logs;
    @Inject
    @AutoBound
    private DataBinder<List<TaskEventSummary>> logsList;
    @Inject
    @DataField(value="load-div")
    private HTMLDivElement loadDiv;
    @Inject
    @DataField(value="load-more-logs")
    private HTMLButtonElement loadMoreLogs;
    @Inject
    @DataField(value="empty-list-item")
    private HTMLDivElement emptyContainer;
    private TaskLogsPresenter presenter;

    public void init(TaskLogsPresenter presenter) {
        this.presenter = presenter;
        this.logs.addComponentCreationHandler(v -> v.init(presenter));
    }

    @Override
    public void setLogs(List<TaskEventSummary> taskEventSummaries) {
        if (taskEventSummaries != null && taskEventSummaries.isEmpty()) {
            this.emptyContainer.hidden = false;
        } else {
            this.logsList.setModel(taskEventSummaries);
            this.emptyContainer.hidden = true;
        }
    }

    @Override
    public void hideLoadButton(boolean hidden) {
        this.loadDiv.hidden = hidden;
    }

    @EventHandler(value={"load-more-logs"})
    public void loadMoreProcessInstanceLogs(@ForEvent(value={"click"}) MouseEvent event) {
        this.presenter.loadMoreProcessInstanceLogs();
    }

    public HTMLElement getElement() {
        return this.container;
    }
}

