/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskcomments;

import com.google.common.base.Strings;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.MouseEvent;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.TextArea;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.databinding.client.components.ListComponent;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.util.AbstractView;
import org.jbpm.workbench.ht.client.editors.taskcomments.TaskCommentItemView;
import org.jbpm.workbench.ht.client.editors.taskcomments.TaskCommentsPresenter;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.model.CommentSummary;
import org.uberfire.client.views.pfly.widgets.FormGroup;
import org.uberfire.client.views.pfly.widgets.ValidationState;

@Dependent
@Templated(value="TaskCommentsViewImpl.html", stylesheet="TaskCommentsViewImpl.css")
public class TaskCommentsViewImpl
extends AbstractView<TaskCommentsPresenter>
implements TaskCommentsPresenter.TaskCommentsView {
    private Constants constants = Constants.INSTANCE;
    @Inject
    @DataField(value="add-comment-div")
    Div addCommentDiv;
    @Inject
    @DataField(value="comments-header-div")
    Div commentsHeaderDiv;
    @Inject
    @DataField(value="load-div")
    Div loadDiv;
    @Inject
    @DataField(value="load-more-comments")
    private Button loadMoreComments;
    @Inject
    @DataField(value="commentsDiv")
    Div commentsContainer;
    @Inject
    @DataField(value="comment-creation-input")
    TextArea newCommentTextArea;
    @Inject
    @DataField(value="comment-creation-help")
    Span newCommentTextAreaHelp;
    @Inject
    @DataField(value="comment-creation-group")
    FormGroup newCommentTextAreaGroup;
    @Inject
    @DataField
    Anchor addCommentButton;
    @Inject
    @DataField(value="sort-alpha-asc")
    private Button sortAlphaAsc;
    @Inject
    @DataField(value="sort-alpha-desc")
    private Button sortAlphaDesc;
    @Inject
    @Bound
    @DataField(value="comments-list")
    private ListComponent<CommentSummary, TaskCommentItemView> comments;
    @Inject
    @AutoBound
    private DataBinder<List<CommentSummary>> commentList;
    @Inject
    @DataField(value="empty-list-item")
    private Div emptyContainer;
    protected TaskCommentsPresenter presenter;

    @PostConstruct
    public void init() {
        this.tooltip((HTMLElement)this.sortAlphaAsc);
        this.sortAlphaAsc.setAttribute("data-original-title", this.constants.SortByDateDesc());
        this.tooltip((HTMLElement)this.sortAlphaDesc);
        this.sortAlphaDesc.setAttribute("data-original-title", this.constants.SortByDateAsc());
    }

    public HTMLElement getElement() {
        return this.commentsContainer;
    }

    public void init(TaskCommentsPresenter presenter) {
        this.presenter = presenter;
        this.comments.addComponentCreationHandler(v -> v.init(presenter));
        this.newCommentTextArea.setOnkeypress(e -> {
            if (!(e != null && e.getKeyCode() != 13 || this.newCommentTextArea.getValue().isEmpty())) {
                this.submitCommentAddition();
            }
        });
    }

    @Override
    public void clearCommentInputForm() {
        this.newCommentTextArea.setValue("");
        this.clearErrorMessages();
    }

    @Override
    public void disableNewComments() {
        DOMUtil.addCSSClass((HTMLElement)this.addCommentDiv, (String)"hidden");
    }

    public void clearErrorMessages() {
        this.newCommentTextAreaHelp.setTextContent("");
        this.newCommentTextAreaGroup.clearValidationState();
    }

    @Override
    public void resetPagination() {
        this.presenter.setCurrentPage(1);
        this.onSortChange((HTMLElement)this.sortAlphaAsc, (HTMLElement)this.sortAlphaDesc, false);
    }

    private void addOrRemoveClassNameOnElement(HTMLElement element, boolean adding, String className) {
        if (adding) {
            DOMUtil.addCSSClass((HTMLElement)element, (String)className);
        } else {
            DOMUtil.removeCSSClass((HTMLElement)element, (String)className);
        }
    }

    @Override
    public void setCommentList(List<CommentSummary> commentSummaries) {
        this.commentList.setModel(commentSummaries);
        this.addOrRemoveClassNameOnElement((HTMLElement)this.emptyContainer, !commentSummaries.isEmpty(), "hidden");
    }

    @Override
    public void hideLoadButton() {
        this.loadDiv.setHidden(true);
    }

    @Override
    public void showLoadButton() {
        this.loadDiv.setHidden(false);
    }

    @Override
    public void showCommentHeader() {
        DOMUtil.removeCSSClass((HTMLElement)this.commentsHeaderDiv, (String)"hidden");
    }

    @EventHandler(value={"addCommentButton"})
    public void addCommentButton(@ForEvent(value={"click"}) Event e) {
        this.submitCommentAddition();
    }

    protected void submitCommentAddition() {
        if (this.validateForm()) {
            this.presenter.addTaskComment(this.newCommentTextArea.getValue());
        }
    }

    private boolean validateForm() {
        this.clearErrorMessages();
        boolean newCommentEmpty = Strings.isNullOrEmpty((String)this.newCommentTextArea.getValue());
        if (newCommentEmpty) {
            this.newCommentTextArea.focus();
            this.newCommentTextAreaHelp.setTextContent(this.constants.CommentCannotBeEmpty());
            this.newCommentTextAreaGroup.setValidationState(ValidationState.ERROR);
            return false;
        }
        return true;
    }

    @EventHandler(value={"sort-alpha-asc"})
    public void onSortAlphaAsc(@ForEvent(value={"click"}) MouseEvent event) {
        this.onSortChange((HTMLElement)this.sortAlphaAsc, (HTMLElement)this.sortAlphaDesc, false);
    }

    @EventHandler(value={"sort-alpha-desc"})
    public void onSortAlphaDesc(@ForEvent(value={"click"}) MouseEvent event) {
        this.onSortChange((HTMLElement)this.sortAlphaDesc, (HTMLElement)this.sortAlphaAsc, true);
    }

    private void onSortChange(HTMLElement toHide, HTMLElement toShow, Boolean sortByAsc) {
        this.addOrRemoveClassNameOnElement(toHide, true, "hidden");
        this.addOrRemoveClassNameOnElement(toShow, false, "hidden");
        this.presenter.sortComments(sortByAsc);
    }

    @EventHandler(value={"load-more-comments"})
    public void loadMoreComments(@ForEvent(value={"click"}) MouseEvent event) {
        this.presenter.loadMoreTaskComments();
    }
}

