/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.tasklogs;

import com.google.gwt.user.client.TakesValue;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.logs.AbstractLogItemView;
import org.jbpm.workbench.ht.client.editors.tasklogs.TaskLogsPresenter;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.model.TaskEventSummary;
import org.jbpm.workbench.ht.util.TaskEventType;

@Dependent
@Templated
public class TaskLogItemView
extends AbstractLogItemView<TaskLogsPresenter>
implements TakesValue<TaskEventSummary>,
IsElement {
    private Constants constants = Constants.INSTANCE;
    @Inject
    private TranslationService translationService;
    @Inject
    @AutoBound
    private DataBinder<TaskEventSummary> logSummary;

    public TaskEventSummary getValue() {
        return (TaskEventSummary)this.logSummary.getModel();
    }

    public void setValue(TaskEventSummary model) {
        this.logSummary.setModel((Object)model);
        TaskEventType type = TaskEventType.valueOf((String)model.getType());
        String logString = this.constants.Task() + " " + this.translationService.format(type.getTypeTranslationId(), new Object[0]).toLowerCase();
        this.setLogTime(model.getLogTime());
        this.setLogIcon(type, logString);
        this.setLogInfo(type, model);
        this.setLogType(logString);
    }

    private void setLogIcon(TaskEventType type, String logString) {
        this.tooltip((HTMLElement)this.logIcon);
        this.logIcon.setAttribute("data-original-title", logString);
        this.logIcon.setClassName(this.getIconClass(type));
    }

    private String getIconClass(TaskEventType type) {
        String iconClass = "list-view-pf-icon-sm kie-timeline-list-view-pf-icon-sm";
        switch (type) {
            case STOPPED: 
            case EXITED: 
            case FAILED: 
            case SKIPPED: 
            case SUSPENDED: {
                iconClass = iconClass + " fa fa-cogs";
                iconClass = iconClass + " kie-timeline-icon--completed";
                break;
            }
            case UPDATED: 
            case CLAIMED: 
            case STARTED: {
                iconClass = iconClass + " fa fa-user";
                break;
            }
            case COMPLETED: 
            case RELEASED: {
                iconClass = iconClass + " fa fa-user";
                iconClass = iconClass + " kie-timeline-icon--completed";
                break;
            }
            default: {
                iconClass = iconClass + " fa fa-cogs";
            }
        }
        return iconClass;
    }

    private void setLogInfo(TaskEventType type, TaskEventSummary model) {
        String logInfoContent = this.constants.ByUser() + " " + model.getUserId();
        switch (type) {
            case ADDED: {
                if (model.getUserId() != null && !model.getUserId().isEmpty()) {
                    logInfoContent = this.constants.ByProcess() + " '" + model.getUserId() + "'";
                    break;
                }
                logInfoContent = "";
                break;
            }
            case UPDATED: {
                logInfoContent = logInfoContent + " (" + model.getMessage() + ")";
            }
        }
        this.logInfo.setTextContent(logInfoContent);
    }

    private void setLogType(String logString) {
        this.logTypeDesc.setTextContent(logString);
    }
}

