/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetLookupFactory;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItem;
import org.jbpm.workbench.common.client.filters.basic.BasicFiltersPresenter;
import org.jbpm.workbench.common.client.util.DateRange;
import org.jbpm.workbench.common.client.util.TaskUtils;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;

public abstract class AbstractTaskListBasicFiltersPresenter
extends BasicFiltersPresenter {
    private Constants constants = Constants.INSTANCE;

    protected String getAdvancedFilterPopupTitle() {
        return this.constants.New_FilteredList();
    }

    public void loadFilters() {
        this.view.addNumericFilter(this.constants.Id(), this.constants.FilterByTaskId(), f -> this.addSearchFilter((ActiveFilterItem)f, FilterFactory.equalsTo((String)"taskId", (Comparable)((Comparable)f.getValue()))));
        this.view.addTextFilter(this.constants.Task(), this.constants.FilterByTaskName(), f -> this.addSearchFilter((ActiveFilterItem)f, FilterFactory.likeTo((String)"name", (String)((String)f.getValue()), (boolean)false)));
        Map status = TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.ALL).stream().sorted().collect(Collectors.toMap(Function.identity(), Function.identity()));
        this.view.addMultiSelectFilter(this.constants.Status(), status, f -> this.addSearchFilterList("status", (ActiveFilterItem)f, status.size()));
        this.view.addTextFilter(this.constants.Process_Instance_Correlation_Key(), this.constants.FilterByCorrelationKey(), f -> this.addSearchFilter((ActiveFilterItem)f, FilterFactory.likeTo((String)"correlationKey", (String)((String)f.getValue()), (boolean)false)));
        this.view.addTextFilter(this.constants.Actual_Owner(), this.constants.FilterByActualOwner(), f -> this.addSearchFilter((ActiveFilterItem)f, FilterFactory.likeTo((String)"actualOwner", (String)((String)f.getValue()), (boolean)false)));
        this.view.addTextFilter(this.constants.Process_Instance_Description(), this.constants.FilterByProcessInstanceDescription(), f -> this.addSearchFilter((ActiveFilterItem)f, FilterFactory.likeTo((String)"processInstanceDescription", (String)((String)f.getValue()), (boolean)false)));
        this.addProcessNameFilter(this.getDataSetId());
        this.view.addDateRangeFilter(this.constants.Created_On(), this.constants.Created_On_Placeholder(), Boolean.valueOf(true), f -> this.addSearchFilter((ActiveFilterItem)f, FilterFactory.between((String)"createdOn", (Comparable)((DateRange)f.getValue()).getStartDate(), (Comparable)((DateRange)f.getValue()).getEndDate())));
    }

    protected void addProcessNameFilter(String dataSetId) {
        DataSetLookup dataSetLookup = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset(dataSetId)).group("processId")).column("processId")).sort("processId", SortOrder.ASCENDING)).buildLookup();
        this.view.addDataSetSelectFilter(this.constants.Process_Definition_Id(), dataSetLookup, "processId", "processId", f -> this.addSearchFilter((ActiveFilterItem)f, FilterFactory.equalsTo((String)"processId", (Comparable)((Comparable)f.getValue()))));
    }

    public abstract String getDataSetId();
}

