/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.common.client.util.TaskUtils;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.filter.FilterSettingsBuilderHelper;
import org.jbpm.workbench.df.client.filter.SavedFilter;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListFilterSettingsManager;
import org.uberfire.ext.services.shared.preferences.MultiGridPreferencesStore;

@Dependent
public class TaskListFilterSettingsManager
extends AbstractTaskListFilterSettingsManager {
    private static final String DATA_SET_TASK_LIST_PREFIX = "DataSetTaskListGrid";
    protected static final String TAB_ALL = "DataSetTaskListGrid_3";
    protected static final String TAB_GROUP = "DataSetTaskListGrid_2";
    protected static final String TAB_PERSONAL = "DataSetTaskListGrid_1";
    protected static final String TAB_ACTIVE = "DataSetTaskListGrid_0";
    protected static final String TAB_ADMIN = "DataSetTaskListGrid_4";
    private User identity;

    @Inject
    public void setIdentity(User identity) {
        this.identity = identity;
    }

    public String getGridGlobalPreferencesKey() {
        return DATA_SET_TASK_LIST_PREFIX;
    }

    public void loadSavedFiltersFromPreferences(MultiGridPreferencesStore store, Consumer<List<SavedFilter>> savedFiltersConsumer) {
        ArrayList existingGrids = new ArrayList(store.getGridsId());
        if (existingGrids.contains(TAB_ADMIN)) {
            this.removeSavedFilterFromPreferences(TAB_ADMIN, store, () -> super.loadSavedFiltersFromPreferences(store, savedFiltersConsumer));
        } else {
            super.loadSavedFiltersFromPreferences(store, savedFiltersConsumer);
        }
    }

    public FilterSettings createFilterSettingsPrototype() {
        return this.createFilterSettings("jbpmHumanTasksWithUser", "createdOn", builder -> {
            builder.group("taskId");
            this.commonColumnSettings().accept((FilterSettingsBuilderHelper)builder);
        });
    }

    public List<FilterSettings> initDefaultFilters() {
        return Arrays.asList(this.createFilterSettings("jbpmHumanTasksWithUser", "createdOn", builder -> {
            ArrayList status = new ArrayList(TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.ACTIVE));
            builder.filter("status", new ColumnFilter[]{FilterFactory.equalsTo((String)"status", status)});
            builder.group("taskId");
            this.commonColumnSettings().accept((FilterSettingsBuilderHelper)builder);
        }, TAB_ACTIVE, this.constants.Active(), this.constants.FilterActive()), this.createFilterSettings("jbpmHumanTasks", "createdOn", builder -> {
            ArrayList names = new ArrayList(TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.PERSONAL));
            builder.filter(new ColumnFilter[]{FilterFactory.equalsTo((String)"status", names)});
            builder.filter(new ColumnFilter[]{FilterFactory.equalsTo((String)"actualOwner", (Comparable)((Object)this.identity.getIdentifier()))});
            this.commonColumnSettings().accept((FilterSettingsBuilderHelper)builder);
        }, TAB_PERSONAL, this.constants.Personal(), this.constants.FilterPersonal()), this.createFilterSettings("jbpmHumanTasksWithUser", "createdOn", builder -> {
            ArrayList names = new ArrayList(TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.GROUP));
            builder.filter("status", new ColumnFilter[]{FilterFactory.equalsTo((String)"status", names)});
            builder.filter("actualOwner", new ColumnFilter[]{FilterFactory.OR((ColumnFilter[])new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"")), FilterFactory.isNull()})});
            builder.group("taskId");
            this.commonColumnSettings().accept((FilterSettingsBuilderHelper)builder);
        }, TAB_GROUP, this.constants.Group(), this.constants.FilterGroup()), this.createFilterSettings("jbpmHumanTasksWithUser", "createdOn", builder -> {
            ArrayList status = new ArrayList(TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.ALL));
            builder.filter("status", new ColumnFilter[]{FilterFactory.equalsTo((String)"status", status)});
            builder.group("taskId");
            this.commonColumnSettings().accept((FilterSettingsBuilderHelper)builder);
        }, TAB_ALL, this.constants.All(), this.constants.FilterAll()));
    }
}

