/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskdetailsmulti;

import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.common.client.menu.RefreshMenuBuilder;
import org.jbpm.workbench.forms.client.display.api.HumanTaskFormDisplayProvider;
import org.jbpm.workbench.forms.display.api.HumanTaskDisplayerConfig;
import org.jbpm.workbench.ht.client.editors.taskadmin.TaskAdminPresenter;
import org.jbpm.workbench.ht.client.editors.taskassignments.TaskAssignmentsPresenter;
import org.jbpm.workbench.ht.client.editors.taskcomments.TaskCommentsPresenter;
import org.jbpm.workbench.ht.client.editors.taskdetails.TaskDetailsPresenter;
import org.jbpm.workbench.ht.client.editors.taskform.TaskFormPresenter;
import org.jbpm.workbench.ht.client.editors.tasklogs.TaskLogsPresenter;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.model.TaskKey;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.jbpm.workbench.ht.service.TaskService;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="TaskDetailsScreen")
public class TaskDetailsMultiPresenter
implements RefreshMenuBuilder.SupportsRefresh {
    private Constants constants = Constants.INSTANCE;
    private Caller<TaskService> taskDataService;
    @Inject
    private TaskDetailsMultiView view;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private HumanTaskFormDisplayProvider taskFormDisplayProvider;
    @Inject
    private TaskFormPresenter taskFormPresenter;
    @Inject
    private TaskDetailsPresenter taskDetailsPresenter;
    @Inject
    private TaskLogsPresenter taskLogsPresenter;
    @Inject
    private TaskAssignmentsPresenter taskAssignmentsPresenter;
    @Inject
    private TaskCommentsPresenter taskCommentsPresenter;
    @Inject
    private TaskAdminPresenter taskAdminPresenter;
    protected Caller<SpecManagementService> specManagementService;
    @Inject
    private Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent;
    @Inject
    private Event<TaskSelectionEvent> taskSelected;
    private PlaceRequest place;
    private Long taskId;
    private String serverTemplateId = "";
    private String containerId = "";
    private String processId = "";
    private boolean forLog = false;
    private boolean forAdmin = false;

    @WorkbenchPartView
    public UberView<TaskDetailsMultiPresenter> getView() {
        return this.view;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return Constants.INSTANCE.Details();
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    public boolean isForAdmin() {
        return this.forAdmin;
    }

    public void setIsForAdmin(boolean isForAdmin) {
        this.forAdmin = isForAdmin;
    }

    public boolean isForLog() {
        return this.forLog;
    }

    public void setIsForLog(boolean isForLog) {
        this.forLog = isForLog;
    }

    public void onTaskSelectionEvent(@Observes TaskSelectionEvent event) {
        boolean refreshDetails = event != null && event.getTaskId() != null && event.getTaskId().equals(this.taskId);
        this.taskId = event.getTaskId();
        this.serverTemplateId = event.getServerTemplateId();
        this.containerId = event.getContainerId();
        this.processId = event.getTaskName();
        if (!event.isForLog().booleanValue()) {
            this.taskFormPresenter.getTaskFormView().getDisplayerView().setOnCloseCommand(() -> this.closeDetails());
            this.taskFormDisplayProvider.setup(new HumanTaskDisplayerConfig(new TaskKey(this.serverTemplateId, this.containerId, this.taskId)), this.taskFormPresenter.getTaskFormView().getDisplayerView());
        }
        this.setIsForLog(event.isForLog());
        this.setIsForAdmin(event.isForAdmin());
        this.changeTitleWidgetEvent.fire((Object)new ChangeTitleWidgetEvent(this.place, String.valueOf(this.taskId) + " - " + this.processId));
        if (this.isForLog()) {
            this.view.displayOnlyLogTab();
            this.disableTaskDetailsEdition();
        } else {
            this.view.displayAllTabs();
        }
        if (this.isForAdmin()) {
            this.view.setAdminTabVisible(true);
        } else {
            this.view.setAdminTabVisible(false);
        }
        if (!refreshDetails) {
            this.view.resetTabs(event.isForLog());
        }
    }

    public void closeDetails() {
        this.placeManager.closePlace(this.place);
    }

    public void onRefresh() {
        ((SpecManagementService)this.specManagementService.call(serverTemplate -> {
            if (serverTemplate != null && serverTemplate.getContainerSpec(this.containerId) != null && serverTemplate.getContainerSpec(this.containerId).getStatus().equals((Object)KieContainerStatus.STARTED)) {
                ((TaskService)this.taskDataService.call(taskSummary -> {
                    if (taskSummary != null) {
                        this.taskSelected.fire((Object)new TaskSelectionEvent(this.serverTemplateId, taskSummary.getDeploymentId(), (Long)taskSummary.getId(), taskSummary.getName(), Boolean.valueOf(this.isForAdmin()), Boolean.valueOf(this.isForLog()), taskSummary.getDescription(), taskSummary.getExpirationTime(), taskSummary.getStatus(), taskSummary.getActualOwner(), taskSummary.getPriority(), taskSummary.getProcessInstanceId(), taskSummary.getProcessId()));
                    }
                })).getTask(this.serverTemplateId, this.containerId, this.taskId);
            } else {
                this.view.displayNotification(this.constants.TaskDetailsNotAvailableContainerNotStarted(this.containerId));
            }
        })).getServerTemplate(this.serverTemplateId);
    }

    @WorkbenchMenu
    public Menus buildMenu() {
        return ((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).build();
    }

    public IsWidget getGenericFormView() {
        return this.taskFormPresenter.getView();
    }

    public IsWidget getTaskDetailsView() {
        return this.taskDetailsPresenter.getView();
    }

    public IsWidget getTaskAssignmentsView() {
        return this.taskAssignmentsPresenter.getView();
    }

    public IsWidget getTaskCommentsView() {
        return this.taskCommentsPresenter.getView();
    }

    public IsWidget getTaskAdminView() {
        return this.taskAdminPresenter.getView();
    }

    public IsWidget getTaskLogsView() {
        return this.taskLogsPresenter.getView();
    }

    public void disableTaskDetailsEdition() {
        this.taskDetailsPresenter.setReadOnlyTaskDetail();
    }

    public void taskAssignmentsRefresh() {
        this.taskAssignmentsPresenter.refreshTaskPotentialOwners();
    }

    public void taskCommentsRefresh() {
        this.taskCommentsPresenter.refreshComments();
    }

    public void taskLogsRefresh() {
        this.taskLogsPresenter.refreshLogs();
    }

    public void taskAdminRefresh() {
        this.taskAdminPresenter.refreshTaskPotentialOwners();
    }

    @Inject
    public void setTaskDataService(Caller<TaskService> taskDataService) {
        this.taskDataService = taskDataService;
    }

    @Inject
    public void setSpecManagementService(Caller<SpecManagementService> specManagementService) {
        this.specManagementService = specManagementService;
    }

    public static interface TaskDetailsMultiView
    extends UberView<TaskDetailsMultiPresenter> {
        public void setAdminTabVisible(boolean var1);

        public void displayAllTabs();

        public void resetTabs(boolean var1);

        public void displayOnlyLogTab();

        public void displayNotification(String var1);
    }
}

