/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.RowStyles;
import com.google.gwt.view.client.CellPreviewEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.workbench.common.client.list.AbstractMultiGridView;
import org.jbpm.workbench.common.client.list.ListTable;
import org.jbpm.workbench.common.client.util.ConditionalAction;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListPresenter;
import org.jbpm.workbench.ht.client.resources.HumanTaskResources;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.model.TaskSummary;
import org.jbpm.workbench.ht.util.TaskStatus;
import org.uberfire.ext.services.shared.preferences.GridColumnPreference;
import org.uberfire.ext.widgets.table.client.ColumnMeta;

public abstract class AbstractTaskListView<P extends AbstractTaskListPresenter>
extends AbstractMultiGridView<TaskSummary, P>
implements AbstractTaskListPresenter.TaskListView<P> {
    private TranslationService translationService;
    protected final Constants constants = Constants.INSTANCE;

    public List<String> getBannedColumns() {
        return Arrays.asList("name", "Actions");
    }

    public void initSelectionModel(ListTable<TaskSummary> extendedPagedTable) {
        RowStyles<TaskSummary> selectedStyles = new RowStyles<TaskSummary>(){

            public String getStyleNames(TaskSummary row, int rowIndex) {
                if (TaskStatus.TASK_STATUS_COMPLETED.equals((Object)row.getTaskStatus())) {
                    return HumanTaskResources.INSTANCE.css().taskCompleted();
                }
                return null;
            }
        };
        extendedPagedTable.setEmptyTableCaption(this.constants.No_Tasks_Found());
        extendedPagedTable.setSelectionCallback(task -> ((AbstractTaskListPresenter)this.presenter).selectTask((TaskSummary)task));
        extendedPagedTable.setRowStyles((RowStyles)selectedStyles);
    }

    public void initColumns(ListTable<TaskSummary> extendedPagedTable) {
        this.initCellPreview(extendedPagedTable);
        ColumnMeta actionsColumnMeta = this.initActionsColumn();
        extendedPagedTable.addSelectionIgnoreColumn(actionsColumnMeta.getColumn());
        ArrayList<ColumnMeta<TaskSummary>> columnMetas = new ArrayList<ColumnMeta<TaskSummary>>();
        columnMetas.add(new ColumnMeta(this.createNumberColumn("taskId", task -> (Long)task.getId()), this.constants.Id()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("name", task -> task.getName()), this.constants.Task()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("description", task -> task.getDescription()), this.constants.Description()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("processId", task -> task.getProcessId()), this.constants.Process_Definition_Id()));
        columnMetas.add(new ColumnMeta(this.createNumberColumn("processInstanceId", task -> task.getProcessInstanceId()), this.constants.Process_Instance_Id()));
        columnMetas.add(new ColumnMeta(this.createNumberColumn("priority", task -> task.getPriority()), this.constants.Priority()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("status", task -> this.translationService.format(task.getStatus(), new Object[0])), this.constants.Status()));
        Column createdOnColumn = this.createTextColumn("createdOn", task -> DateUtils.getDateTimeStr((Date)task.getCreatedOn()));
        createdOnColumn.setDefaultSortAscending(false);
        columnMetas.add(new ColumnMeta(createdOnColumn, this.constants.Created_On()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("dueDate", task -> DateUtils.getDateTimeStr((Date)task.getExpirationTime())), this.constants.Due_On()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("actualOwner", task -> task.getActualOwner()), this.constants.Actual_Owner()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("correlationKey", task -> task.getProcessInstanceCorrelationKey()), this.constants.Process_Instance_Correlation_Key()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("processInstanceDescription", task -> task.getProcessInstanceDescription()), this.constants.Process_Instance_Description()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("lastModificationDate", task -> DateUtils.getDateTimeStr((Date)task.getLastModificationDate())), this.constants.Last_Modification_Date()));
        columnMetas.add(new ColumnMeta(this.createNumberColumn("processSessionId", task -> task.getProcessSessionId()), this.constants.ProcessSessionId()));
        this.addNewColumn(extendedPagedTable, columnMetas);
        columnMetas.add((ColumnMeta<TaskSummary>)actionsColumnMeta);
        List columPreferenceList = extendedPagedTable.getGridPreferencesStore().getColumnPreferences();
        for (GridColumnPreference colPref : columPreferenceList) {
            if (this.isColumnAdded(columnMetas, colPref.getName())) continue;
            Column<TaskSummary, ?> genericColumn = this.initGenericColumn(colPref.getName());
            genericColumn.setSortable(false);
            columnMetas.add((ColumnMeta<TaskSummary>)new ColumnMeta(genericColumn, colPref.getName(), true, true));
        }
        extendedPagedTable.addColumns(columnMetas);
        extendedPagedTable.setColumnWidth(actionsColumnMeta.getColumn(), 175.0, Style.Unit.PX);
        extendedPagedTable.getColumnSortList().push(createdOnColumn);
    }

    protected void addNewColumn(ListTable<TaskSummary> extendedPagedTable, List<ColumnMeta<TaskSummary>> columnMetas) {
    }

    protected void initCellPreview(final ListTable<TaskSummary> extendedPagedTable) {
        extendedPagedTable.addCellPreviewHandler((CellPreviewEvent.Handler)new CellPreviewEvent.Handler<TaskSummary>(){

            public void onCellPreview(CellPreviewEvent<TaskSummary> event) {
                if ("mouseover".equalsIgnoreCase(event.getNativeEvent().getType())) {
                    AbstractTaskListView.this.onMouseOverGrid((ListTable<TaskSummary>)extendedPagedTable, event);
                }
            }
        });
    }

    protected void onMouseOverGrid(ListTable<TaskSummary> extendedPagedTable, CellPreviewEvent<TaskSummary> event) {
        TaskSummary task = (TaskSummary)event.getValue();
        if (task.getDescription() != null) {
            extendedPagedTable.setTooltip(extendedPagedTable.getKeyboardSelectedRow(), event.getColumn(), task.getDescription());
        }
    }

    protected List<ConditionalAction<TaskSummary>> getConditionalActions() {
        return Arrays.asList(new ConditionalAction(this.constants.Claim(), task -> ((AbstractTaskListPresenter)this.presenter).claimTask((TaskSummary)task), ((AbstractTaskListPresenter)this.presenter).getClaimActionCondition(), Boolean.valueOf(false)), new ConditionalAction(this.constants.Release(), task -> ((AbstractTaskListPresenter)this.presenter).releaseTask((TaskSummary)task), ((AbstractTaskListPresenter)this.presenter).getReleaseActionCondition(), Boolean.valueOf(false)), new ConditionalAction(this.constants.Suspend(), task -> ((AbstractTaskListPresenter)this.presenter).suspendTask((TaskSummary)task), ((AbstractTaskListPresenter)this.presenter).getSuspendActionCondition(), Boolean.valueOf(false)), new ConditionalAction(this.constants.Resume(), task -> ((AbstractTaskListPresenter)this.presenter).resumeTask((TaskSummary)task), ((AbstractTaskListPresenter)this.presenter).getResumeActionCondition(), Boolean.valueOf(false)), new ConditionalAction(this.constants.ViewProcess(), task -> ((AbstractTaskListPresenter)this.presenter).openProcessInstanceView(task.getProcessInstanceId().toString()), ((AbstractTaskListPresenter)this.presenter).getProcessInstanceCondition(), Boolean.valueOf(true)));
    }

    @Override
    public void addDomainSpecifColumns(ListTable<TaskSummary> extendedPagedTable, Set<String> columns) {
        extendedPagedTable.storeColumnToPreferences();
        HashMap<String, String> modifiedCaptions = new HashMap<String, String>();
        ArrayList<ColumnMeta> existingExtraColumns = new ArrayList<ColumnMeta>();
        for (ColumnMeta cm : extendedPagedTable.getColumnMetaList()) {
            if (cm.isExtraColumn()) {
                existingExtraColumns.add(cm);
                continue;
            }
            if (!columns.contains(cm.getCaption())) continue;
            for (String c : columns) {
                if (!c.equals(cm.getCaption())) continue;
                modifiedCaptions.put(c, "Var_" + c);
            }
        }
        for (ColumnMeta colMet : existingExtraColumns) {
            if (!columns.contains(colMet.getCaption())) {
                extendedPagedTable.removeColumnMeta(colMet);
                continue;
            }
            columns.remove(colMet.getCaption());
        }
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        String caption = "";
        Iterator<String> iterator = columns.iterator();
        while (iterator.hasNext()) {
            String c;
            caption = c = iterator.next();
            if (modifiedCaptions.get(c) != null) {
                caption = (String)modifiedCaptions.get(c);
            }
            Column<TaskSummary, ?> genericColumn = this.initGenericColumn(c);
            genericColumn.setSortable(false);
            columnMetas.add(new ColumnMeta(genericColumn, caption, true, true));
        }
        extendedPagedTable.addColumns(columnMetas);
    }

    protected Column<TaskSummary, ?> initGenericColumn(String key) {
        return this.createTextColumn(key, task -> task.getDomainDataValue(key));
    }

    @Inject
    public void setTranslationService(TranslationService translationService) {
        this.translationService = translationService;
    }
}

