/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.casemgmt;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.wi.casemgmt.events.CaseProvisioningCompletedEvent;
import org.jbpm.workbench.wi.casemgmt.events.CaseProvisioningFailedEvent;
import org.jbpm.workbench.wi.casemgmt.events.CaseProvisioningStartedEvent;
import org.jbpm.workbench.wi.casemgmt.service.CaseProvisioningService;
import org.jbpm.workbench.wi.casemgmt.service.CaseProvisioningStatus;
import org.jbpm.workbench.wi.client.i18n.Constants;
import org.kie.workbench.common.widgets.client.popups.launcher.events.AppLauncherAddEvent;
import org.uberfire.workbench.events.NotificationEvent;

@ApplicationScoped
public class CaseProvisioningAppLauncherHandler {
    private final Constants constants = Constants.INSTANCE;
    @Inject
    private Event<AppLauncherAddEvent> appLauncherAddEvent;
    @Inject
    private Event<NotificationEvent> notification;
    private Caller<CaseProvisioningService> service;

    public void verifyCaseAppStatus() {
        ((CaseProvisioningService)this.service.call(s -> {
            if (s == CaseProvisioningStatus.COMPLETED) {
                this.addCaseAppLauncher();
            }
        })).getProvisioningStatus();
    }

    public void onCaseManagementProvisioningStartedEvent(@Observes CaseProvisioningStartedEvent event) {
        this.notification.fire((Object)new NotificationEvent(this.constants.CaseAppProvisioningStarted()));
    }

    public void onCaseManagementProvisioningCompletedEvent(@Observes CaseProvisioningCompletedEvent event) {
        this.notification.fire((Object)new NotificationEvent(this.constants.CaseAppProvisioningCompleted(), NotificationEvent.NotificationType.SUCCESS));
        this.addCaseAppLauncher();
    }

    protected void addCaseAppLauncher() {
        this.appLauncherAddEvent.fire((Object)new AppLauncherAddEvent(this.constants.CaseAppName(), "/jbpm-cm", null));
    }

    public void onCaseManagementProvisioningFailedEvent(@Observes CaseProvisioningFailedEvent event) {
        this.notification.fire((Object)new NotificationEvent(this.constants.CaseAppProvisioningFailed(), NotificationEvent.NotificationType.ERROR));
    }

    @Inject
    public void setCaseProvisioningService(Caller<CaseProvisioningService> service) {
        this.service = service;
    }
}

