/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.workitem;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.user.client.TakesValue;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.extras.toggleswitch.client.ui.ToggleSwitch;
import org.gwtbootstrap3.extras.toggleswitch.client.ui.base.constants.SizeType;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.util.AbstractView;
import org.jbpm.workbench.wi.client.workitem.ServiceTasksRepositoryListPresenter;
import org.jbpm.workbench.wi.workitems.model.ServiceTaskSummary;

@Dependent
@Templated
public class ServiceTaskViewImpl
extends AbstractView<ServiceTasksRepositoryListPresenter>
implements TakesValue<ServiceTaskSummary>,
IsElement {
    private String id;
    @Inject
    @DataField(value="list-item")
    private Div row;
    @Inject
    @DataField(value="icon")
    private Span icon;
    @Inject
    @DataField(value="name")
    @Bound
    private Span name;
    @Inject
    @DataField(value="description")
    @Bound
    private Div description;
    @Inject
    @DataField(value="additionalInfo")
    @Bound
    private Span additionalInfo;
    @Inject
    @DataField(value="installedOn")
    private Span installedOn;
    @Inject
    @DataField
    private ToggleSwitch enabled;
    @Inject
    @AutoBound
    private DataBinder<ServiceTaskSummary> serviceTasks;

    @PostConstruct
    public void init() {
        this.enabled.setSize(SizeType.MINI);
    }

    public void init(ServiceTasksRepositoryListPresenter presenter) {
        super.init((Object)presenter);
    }

    public ServiceTaskSummary getValue() {
        return (ServiceTaskSummary)this.serviceTasks.getModel();
    }

    public void setValue(ServiceTaskSummary model) {
        String[] classes;
        this.id = model.getId();
        this.enabled.setValue(model.getEnabled(), false);
        this.serviceTasks.setModel((Object)model);
        for (String css : classes = model.getIcon().split(" ")) {
            this.icon.getClassList().add(css);
        }
        this.installedOn.setTextContent(String.valueOf(model.getInstalledOn().size()));
    }

    public HTMLElement getElement() {
        return this.row;
    }

    @EventHandler(value={"enabled"})
    public void onToggleChange(ChangeEvent event) {
        if (this.presenter == null) {
            return;
        }
        event.preventDefault();
        boolean enabledValue = this.enabled.getValue();
        if (enabledValue) {
            ((ServiceTasksRepositoryListPresenter)this.presenter).enableService(this.id);
        } else {
            ((ServiceTasksRepositoryListPresenter)this.presenter).disableService(this.id);
        }
    }
}

