/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.workitem;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jbpm.workbench.wi.client.i18n.Constants;
import org.jbpm.workbench.wi.client.workitem.ServiceTaskUploadFormPresenter;
import org.jbpm.workbench.wi.workitems.model.ServiceTaskSummary;
import org.jbpm.workbench.wi.workitems.model.ServiceTasksConfiguration;
import org.jbpm.workbench.wi.workitems.service.ServiceTaskService;
import org.kie.workbench.common.widgets.client.popups.alert.AlertPopupView;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.client.views.pfly.widgets.ConfirmPopup;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
@WorkbenchScreen(identifier="ServiceTasksRepositoryPreferences")
public class ServiceTasksRepositoryListPresenter {
    public static final String SCREEN_ID = "ServiceTasksRepositoryPreferences";
    private Caller<ServiceTaskService> serviceTaskService;
    private Constants constants = Constants.INSTANCE;
    private Event<NotificationEvent> notificationEvent;
    protected ServiceTasksRepositoryListView view;
    protected SyncBeanManager iocManager;
    private ConfirmPopup confirmPopup;
    private AlertPopupView cannotRemovePopup;

    public ServiceTasksRepositoryListPresenter() {
    }

    @Inject
    public ServiceTasksRepositoryListPresenter(Event<NotificationEvent> notificationEvent, ServiceTasksRepositoryListView view, Caller<ServiceTaskService> serviceTaskService, SyncBeanManager iocManager) {
        this.notificationEvent = notificationEvent;
        this.view = view;
        this.serviceTaskService = serviceTaskService;
        this.iocManager = iocManager;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.ServiceTaskList();
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.retrieveConfig();
        this.refreshData();
    }

    @WorkbenchPartView
    public ServiceTasksRepositoryListView getView() {
        return this.view;
    }

    @Inject
    public void setConfirmPopup(ConfirmPopup confirmPopup) {
        this.confirmPopup = confirmPopup;
    }

    @Inject
    public void setCannotRemovePopup(AlertPopupView cannotRemovePopup) {
        this.cannotRemovePopup = cannotRemovePopup;
    }

    protected void refreshData() {
        ((ServiceTaskService)this.serviceTaskService.call(serviceTasks -> this.view.setServiceTaskList((List<ServiceTaskSummary>)serviceTasks))).getServiceTasks();
    }

    protected void retrieveConfig() {
        ((ServiceTaskService)this.serviceTaskService.call(configuration -> this.view.setConfiguration((ServiceTasksConfiguration)configuration))).getConfiguration();
    }

    protected void saveConfiguration(ServiceTasksConfiguration configuration) {
        ((ServiceTaskService)this.serviceTaskService.call()).saveConfiguration(configuration);
    }

    public void enableService(String id) {
        ((ServiceTaskService)this.serviceTaskService.call()).enableServiceTask(id);
    }

    public void disableService(String id) {
        ((ServiceTaskService)this.serviceTaskService.call()).disableServiceTask(id);
    }

    public void openUploadDialog() {
        ServiceTaskUploadFormPresenter uploadFormPresenter = (ServiceTaskUploadFormPresenter)this.iocManager.lookupBean(ServiceTaskUploadFormPresenter.class, new Annotation[0]).newInstance();
        uploadFormPresenter.showView(() -> this.refreshData());
    }

    protected void refreshServiceTaskList(ServiceTaskSummary serviceTaskSummary) {
        ((ServiceTaskService)this.serviceTaskService.call(serviceTaskName -> {
            this.notificationEvent.fire((Object)new NotificationEvent(this.getRemoveTaskSuccess((String)serviceTaskName)));
            this.refreshData();
        })).removeServiceTask(serviceTaskSummary);
    }

    protected String getRemoveTaskSuccess(String serviceTaskName) {
        return this.constants.RemoveTaskSuccess(serviceTaskName);
    }

    public void openRemoveServiceTaskConfirmPopup(ServiceTaskSummary serviceTaskSummary) {
        if (serviceTaskSummary.getInstalledOn().size() > 0) {
            this.cannotRemovePopup.alert(this.constants.RemoveServiceTaskTitle(), this.constants.CanNotRemoveServiceTaskMessage(serviceTaskSummary.getName()));
        } else {
            this.confirmPopup.show(this.constants.RemoveServiceTaskTitle(), this.constants.RemoveServiceTaskAction(), this.constants.RemoveServiceTaskConfirmMessage(serviceTaskSummary.getName()), () -> this.refreshServiceTaskList(serviceTaskSummary));
        }
    }

    public static interface ServiceTasksRepositoryListView
    extends UberElement<ServiceTasksRepositoryListPresenter> {
        public void setServiceTaskList(List<ServiceTaskSummary> var1);

        public void setConfiguration(ServiceTasksConfiguration var1);
    }
}

