/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ks.utils;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.jbpm.workbench.ks.security.KeyCloakTokenCredentialsProvider;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.client.CredentialsProvider;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.client.balancer.LoadBalancer;
import org.kie.server.client.credentials.EnteredCredentialsProvider;
import org.kie.server.client.credentials.EnteredTokenCredentialsProvider;
import org.kie.server.client.credentials.SubjectCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieServerUtils.class);

    public static KieServicesClient createKieServicesClient(String ... capabilities) {
        String kieServerEndpoint = System.getProperty("org.kie.server.location");
        Preconditions.checkNotNull((Object)kieServerEndpoint, (Object)"Missing Kie Server system property org.kie.server.location");
        return KieServerUtils.createKieServicesClient(kieServerEndpoint, null, KieServerUtils.getCredentialsProvider(), capabilities);
    }

    public static KieServicesClient createAdminKieServicesClient(String ... capabilities) {
        String kieServerEndpoint = System.getProperty("org.kie.server.location");
        Preconditions.checkNotNull((Object)kieServerEndpoint, (Object)"Missing Kie Server system property org.kie.server.location");
        return KieServerUtils.createKieServicesClient(kieServerEndpoint, null, KieServerUtils.getAdminCredentialsProvider(), capabilities);
    }

    public static KieServicesClient createKieServicesClient(String endpoint, ClassLoader classLoader, String login, String password, String ... capabilities) {
        KieServicesConfiguration configuration = KieServicesFactory.newRestConfiguration((String)endpoint, (String)login, (String)password);
        return KieServerUtils.createKieServicesClient(endpoint, classLoader, configuration, capabilities);
    }

    public static KieServicesClient createKieServicesClient(String endpoint, ClassLoader classLoader, CredentialsProvider credentialsProvider, String ... capabilities) {
        KieServicesConfiguration configuration = KieServicesFactory.newRestConfiguration((String)endpoint, (CredentialsProvider)credentialsProvider);
        return KieServerUtils.createKieServicesClient(endpoint, classLoader, configuration, capabilities);
    }

    public static KieServicesClient createKieServicesClient(String endpoint, ClassLoader classLoader, KieServicesConfiguration configuration, String ... capabilities) {
        LOGGER.debug("Creating client that will use following endpoint {}", (Object)endpoint);
        configuration.setTimeout(60000L);
        configuration.setCapabilities(Arrays.asList(capabilities));
        configuration.setMarshallingFormat(MarshallingFormat.XSTREAM);
        configuration.setLoadBalancer(LoadBalancer.getDefault((String)endpoint));
        KieServicesClient kieServicesClient = classLoader == null ? KieServicesFactory.newKieServicesClient((KieServicesConfiguration)configuration) : KieServicesFactory.newKieServicesClient((KieServicesConfiguration)configuration, (ClassLoader)classLoader);
        LOGGER.debug("KieServerClient created successfully for endpoint {}", (Object)endpoint);
        return kieServicesClient;
    }

    public static CredentialsProvider getCredentialsProvider() {
        KeyCloakTokenCredentialsProvider credentialsProvider;
        try {
            credentialsProvider = new KeyCloakTokenCredentialsProvider();
        }
        catch (UnsupportedOperationException e) {
            credentialsProvider = new SubjectCredentialsProvider();
        }
        LOGGER.debug("{} initialized for the client.", (Object)credentialsProvider.getClass().getName());
        return credentialsProvider;
    }

    public static CredentialsProvider getAdminCredentialsProvider() {
        if (System.getProperty("org.kie.server.token") != null) {
            return new EnteredTokenCredentialsProvider(System.getProperty("org.kie.server.token"));
        }
        return new EnteredCredentialsProvider(System.getProperty("org.kie.server.user", "kieserver"), System.getProperty("org.kie.server.pwd", "kieserver1!"));
    }
}

