/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ks.security;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.keycloak.KeycloakPrincipal;
import org.kie.server.client.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.security.server.SecurityIntegrationFilter;

public class KeyCloakTokenCredentialsProvider
implements CredentialsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyCloakTokenCredentialsProvider.class);

    public String getHeaderName() {
        return "Authorization";
    }

    public String getAuthorization() {
        LOGGER.debug("Get user authorization using KeyCloakTokenCredentialsProvider");
        HttpServletRequest request = SecurityIntegrationFilter.getRequest();
        Principal principal = request.getUserPrincipal();
        if (principal != null && principal instanceof KeycloakPrincipal) {
            try {
                KeycloakPrincipal kc = (KeycloakPrincipal)principal;
                return "Bearer " + kc.getKeycloakSecurityContext().getTokenString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

