/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ks.security;

import java.lang.reflect.Method;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.kie.server.client.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.security.server.SecurityIntegrationFilter;

public class KeyCloakTokenCredentialsProvider
implements CredentialsProvider {
    private static final Logger logger = LoggerFactory.getLogger(KeyCloakTokenCredentialsProvider.class);
    private Class<?> keycloakPrincipal;
    private Class<?> keycloakSecurityContext;
    private Method tokenMethod;
    private Method securityContextMethod;

    public KeyCloakTokenCredentialsProvider() {
        try {
            this.keycloakPrincipal = Class.forName("org.keycloak.KeycloakPrincipal");
            this.keycloakSecurityContext = Class.forName("org.keycloak.KeycloakSecurityContext");
            this.tokenMethod = this.keycloakSecurityContext.getMethod("getTokenString", new Class[0]);
            this.securityContextMethod = this.keycloakPrincipal.getMethod("getKeycloakSecurityContext", new Class[0]);
        }
        catch (Exception e) {
            logger.debug("KeyCloak not on classpath due to {}", (Object)e.toString());
            throw new UnsupportedOperationException("KeyCloak not on classpath");
        }
    }

    public String getHeaderName() {
        return "Authorization";
    }

    public String getAuthorization() {
        HttpServletRequest request = SecurityIntegrationFilter.getRequest();
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            try {
                Object securityContext = this.securityContextMethod.invoke((Object)principal, new Object[0]);
                return "Bearer " + this.tokenMethod.invoke(securityContext, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

