/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.backend.server;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.workbench.ks.integration.AbstractKieServerService;
import org.jbpm.workbench.pr.backend.server.model.RemoteCorrelationKey;
import org.jbpm.workbench.pr.service.ProcessService;
import org.kie.internal.process.CorrelationKey;
import org.kie.server.client.ProcessServicesClient;

@Service
@ApplicationScoped
public class RemoteProcessServiceImpl
extends AbstractKieServerService
implements ProcessService {
    public void abortProcessInstance(String serverTemplateId, String containerId, Long processInstanceId) {
        ProcessServicesClient client = (ProcessServicesClient)this.getClient(serverTemplateId, containerId, ProcessServicesClient.class);
        client.abortProcessInstance(containerId, processInstanceId);
    }

    public void abortProcessInstances(String serverTemplateId, List<String> containers, List<Long> processInstanceId) {
        if (new HashSet<String>(containers).size() == 1) {
            ProcessServicesClient client = (ProcessServicesClient)this.getClient(serverTemplateId, containers.get(0), ProcessServicesClient.class);
            client.abortProcessInstances(containers.get(0), processInstanceId);
        } else {
            for (int i = 0; i < processInstanceId.size(); ++i) {
                ProcessServicesClient client = (ProcessServicesClient)this.getClient(serverTemplateId, containers.get(i), ProcessServicesClient.class);
                client.abortProcessInstance(containers.get(i), processInstanceId.get(i));
            }
        }
    }

    public Long startProcess(String serverTemplateId, String containerId, String processId, String correlationKey, Map<String, Object> params) {
        ProcessServicesClient client = (ProcessServicesClient)this.getClient(serverTemplateId, containerId, ProcessServicesClient.class);
        if (correlationKey != null && !correlationKey.isEmpty()) {
            RemoteCorrelationKey actualCorrelationKey = new RemoteCorrelationKey(correlationKey);
            return client.startProcess(containerId, processId, (CorrelationKey)actualCorrelationKey, params);
        }
        return client.startProcess(containerId, processId, params);
    }

    public List<String> getAvailableSignals(String serverTemplateId, String containerId, Long processInstanceId) {
        ProcessServicesClient client = (ProcessServicesClient)this.getClient(serverTemplateId, containerId, ProcessServicesClient.class);
        return client.getAvailableSignals(containerId, processInstanceId);
    }

    public void signalProcessInstance(String serverTemplateId, String containerId, Long processInstanceId, String signal, Object event) {
        ProcessServicesClient client = (ProcessServicesClient)this.getClient(serverTemplateId, containerId, ProcessServicesClient.class);
        client.signalProcessInstance(containerId, processInstanceId, signal, event);
    }

    public void signalProcessInstances(String serverTemplateId, List<String> containers, List<Long> processInstanceId, String signal, Object event) {
        if (new HashSet<String>(containers).size() == 1) {
            ProcessServicesClient client = (ProcessServicesClient)this.getClient(serverTemplateId, containers.get(0), ProcessServicesClient.class);
            client.signalProcessInstances(containers.get(0), processInstanceId, signal, event);
        } else {
            for (int i = 0; i < processInstanceId.size(); ++i) {
                ProcessServicesClient client = (ProcessServicesClient)this.getClient(serverTemplateId, containers.get(i), ProcessServicesClient.class);
                client.signalProcessInstance(containers.get(i), processInstanceId.get(i), signal, event);
            }
        }
    }

    public void setProcessVariable(String serverTemplateId, String containerId, long processInstanceId, String variableName, String value) {
        ProcessServicesClient client = (ProcessServicesClient)this.getClient(serverTemplateId, containerId, ProcessServicesClient.class);
        client.setProcessVariable(containerId, Long.valueOf(processInstanceId), variableName, (Object)value);
    }
}

