/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.backend.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.dataprovider.BeanDataSetProvider;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetBuilder;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.impl.DataSetMetadataImpl;
import org.dashbuilder.dataset.sort.ColumnSort;
import org.dashbuilder.dataset.sort.DataSetSort;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jbpm.workbench.ks.integration.ConsoleDataSetLookup;
import org.jbpm.workbench.pr.model.ProcessDefinitionDataSetDef;
import org.jbpm.workbench.pr.model.ProcessDefinitionDataSetProviderType;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;

@ApplicationScoped
public class ProcessDefinitionDataSetProvider
extends BeanDataSetProvider {
    @Inject
    protected ProcessRuntimeDataService processRuntimeDataService;

    public DataSetProviderType getType() {
        return new ProcessDefinitionDataSetProviderType();
    }

    public DataSetMetadata getDataSetMetadata(DataSetDef def) throws Exception {
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<ColumnType> columnTypes = new ArrayList<ColumnType>();
        List columns = def.getColumns();
        for (DataColumnDef column : columns) {
            columnNames.add(column.getId());
            columnTypes.add(column.getColumnType());
        }
        return new DataSetMetadataImpl(def, def.getUUID(), -1, def.getColumns().size(), columnNames, columnTypes, -1);
    }

    public DataSet lookupDataSet(DataSetDef def, DataSetLookup lookup) throws Exception {
        ProcessDefinitionDataSetDef processDefinitionDataSetDef = (ProcessDefinitionDataSetDef)def;
        DataSetBuilder dsBuilder = DataSetFactory.newDataSetBuilder();
        for (DataColumnDef columnDef : processDefinitionDataSetDef.getColumns()) {
            dsBuilder.column(columnDef.getId(), columnDef.getColumnType());
        }
        ConsoleDataSetLookup consoleDataSetLookup = (ConsoleDataSetLookup)lookup;
        processDefinitionDataSetDef.setServerTemplateId(consoleDataSetLookup.getServerTemplateId());
        String defaultColumnSort = "ProcessName";
        boolean defaultSortOrder = false;
        DataSetSort dataSetSort = lookup.getFirstSortOp();
        if (dataSetSort != null && dataSetSort.getColumnSortList().size() > 0) {
            defaultColumnSort = ((ColumnSort)dataSetSort.getColumnSortList().get(0)).getColumnId();
            defaultSortOrder = ((ColumnSort)dataSetSort.getColumnSortList().get(0)).getOrder().equals((Object)SortOrder.ASCENDING);
        }
        String searchText = "";
        for (DataSetFilter filter : lookup.getOperationList(DataSetFilter.class)) {
            Optional<ColumnFilter> coreFunctionFilter = filter.getColumnFilterList().stream().filter(columnFilter -> columnFilter instanceof CoreFunctionFilter).filter(columnFilter -> ((CoreFunctionFilter)columnFilter).getParameters().size() > 0).findFirst();
            if (!coreFunctionFilter.isPresent()) continue;
            searchText = ((CoreFunctionFilter)coreFunctionFilter.get()).getParameters().get(0).toString();
        }
        List processSummaryList = this.processRuntimeDataService.getProcessesByFilter(consoleDataSetLookup.getServerTemplateId(), searchText, Integer.valueOf(lookup.getRowOffset() / lookup.getNumberOfRows()), Integer.valueOf(lookup.getNumberOfRows()), defaultColumnSort, Boolean.valueOf(defaultSortOrder));
        processSummaryList.forEach(processSummary -> dsBuilder.row(new Object[]{processSummary.getProcessDefName(), processSummary.getVersion(), processSummary.getDeploymentId(), processSummary.getProcessDefId(), processSummary.isDynamic()}));
        DataSet dataSet = dsBuilder.buildDataSet();
        dataSet.setUUID("jbpmProcessDefinition");
        return dataSet;
    }

    public boolean isDataSetOutdated(DataSetDef def) {
        return false;
    }
}

