/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.backend.server;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jbpm.workbench.ks.utils.KieServerUtils;
import org.jbpm.workbench.pr.model.ProcessNodeSummary;
import org.jbpm.workbench.pr.model.ProcessSummary;
import org.jbpm.workbench.pr.model.TimerSummary;
import org.kie.server.api.model.definition.ProcessDefinition;

public class ProcessSummaryMapper
implements Function<ProcessDefinition, ProcessSummary> {
    @Override
    public ProcessSummary apply(ProcessDefinition definition) {
        if (definition == null) {
            return null;
        }
        ProcessSummary summary = new ProcessSummary(definition.getId(), definition.getName(), definition.getContainerId(), definition.getVersion(), definition.isDynamic());
        summary.setAssociatedEntities(definition.getAssociatedEntities());
        summary.setProcessVariables(definition.getProcessVariables());
        summary.setReusableSubProcesses(definition.getReusableSubProcesses());
        summary.setServiceTasks(definition.getServiceTasks());
        summary.setDynamicFormsEnabled(KieServerUtils.isKieServerRendererEnabled());
        summary.setNodes(definition.getNodes() == null ? Collections.emptyList() : (Collection)definition.getNodes().stream().map(node -> new ProcessNodeSummary(node.getId(), node.getName(), node.getType(), node.getUniqueId())).collect(Collectors.toList()));
        summary.setTimers(definition.getTimers() == null ? Collections.emptyList() : (Collection)definition.getTimers().stream().map(timer -> new TimerSummary(timer.getId(), timer.getNodeId(), timer.getNodeName(), timer.getUniqueId())).collect(Collectors.toList()));
        return summary;
    }
}

