/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.variables.list;

import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jbpm.workbench.common.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.workbench.common.client.list.base.AbstractListPresenter;
import org.jbpm.workbench.common.client.list.base.AbstractListView;
import org.jbpm.workbench.common.client.util.ButtonActionCell;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.common.model.GenericSummary;
import org.jbpm.workbench.pr.client.editors.variables.edit.VariableEditPopup;
import org.jbpm.workbench.pr.client.editors.variables.history.VariableHistoryPopup;
import org.jbpm.workbench.pr.client.editors.variables.list.ProcessVariableListPresenter;
import org.jbpm.workbench.pr.client.i18n.Constants;
import org.jbpm.workbench.pr.events.ProcessInstancesUpdateEvent;
import org.jbpm.workbench.pr.model.ProcessVariableSummary;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.common.client.tables.PopoverTextCell;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
public class ProcessVariableListViewImpl
extends AbstractListView<ProcessVariableSummary, ProcessVariableListPresenter>
implements ProcessVariableListPresenter.ProcessVariableListView {
    public static final String COL_ID_VARID = "varId";
    public static final String COL_ID_VARVALUE = "varValue";
    public static final String COL_ID_VARTYPE = "varType";
    public static final String COL_ID_LASTMOD = "lastMod";
    public static final String COL_ID_ACTIONS = "Actions";
    private Constants constants = Constants.INSTANCE;
    private Column actionsColumn;
    @Inject
    public VariableEditPopup variableEditPopup;
    @Inject
    public VariableHistoryPopup variableHistoryPopup;

    public void init(ProcessVariableListPresenter presenter) {
        ArrayList<String> bannedColumns = new ArrayList<String>();
        bannedColumns.add(COL_ID_VARID);
        bannedColumns.add(COL_ID_VARVALUE);
        bannedColumns.add(COL_ID_ACTIONS);
        ArrayList<String> initColumns = new ArrayList<String>();
        initColumns.add(COL_ID_VARID);
        initColumns.add(COL_ID_VARVALUE);
        initColumns.add(COL_ID_ACTIONS);
        super.init((AbstractListPresenter)presenter, new GridGlobalPreferences("ProcessVariablesGrid", initColumns, bannedColumns));
        this.listGrid.setEmptyTableCaption(this.constants.No_Variables_Available());
        this.selectionModel = new NoSelectionModel();
        this.selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                if (ProcessVariableListViewImpl.this.selectedRow == -1) {
                    ProcessVariableListViewImpl.this.listGrid.setRowStyles(ProcessVariableListViewImpl.this.selectedStyles);
                    ProcessVariableListViewImpl.this.selectedRow = ProcessVariableListViewImpl.this.listGrid.getKeyboardSelectedRow();
                    ProcessVariableListViewImpl.this.listGrid.redraw();
                } else if (ProcessVariableListViewImpl.this.listGrid.getKeyboardSelectedRow() != ProcessVariableListViewImpl.this.selectedRow) {
                    ProcessVariableListViewImpl.this.listGrid.setRowStyles(ProcessVariableListViewImpl.this.selectedStyles);
                    ProcessVariableListViewImpl.this.selectedRow = ProcessVariableListViewImpl.this.listGrid.getKeyboardSelectedRow();
                    ProcessVariableListViewImpl.this.listGrid.redraw();
                }
                ProcessVariableListViewImpl.this.selectedItem = (GenericSummary)ProcessVariableListViewImpl.this.selectionModel.getLastSelectedObject();
            }
        });
        this.noActionColumnManager = DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new DefaultSelectionEventManager.EventTranslator<ProcessVariableSummary>(){

            public boolean clearCurrentSelection(CellPreviewEvent<ProcessVariableSummary> event) {
                return false;
            }

            public DefaultSelectionEventManager.SelectAction translateSelectionEvent(CellPreviewEvent<ProcessVariableSummary> event) {
                NativeEvent nativeEvent = event.getNativeEvent();
                if ("click".equals(nativeEvent.getType()) && ProcessVariableListViewImpl.this.listGrid.getColumnIndex(ProcessVariableListViewImpl.this.actionsColumn) == event.getColumn()) {
                    return DefaultSelectionEventManager.SelectAction.IGNORE;
                }
                return DefaultSelectionEventManager.SelectAction.DEFAULT;
            }
        });
        this.listGrid.setSelectionModel((SelectionModel)this.selectionModel, (CellPreviewEvent.Handler)this.noActionColumnManager);
        this.listGrid.setRowStyles(this.selectedStyles);
    }

    public void initColumns(ExtendedPagedTable extendedPagedTable) {
        Column<ProcessVariableSummary, ?> variableId = this.initProcessVariableIdColumn();
        Column<ProcessVariableSummary, ?> valueColumn = this.initProcessVariableValueColumn();
        Column<ProcessVariableSummary, String> typeColumn = this.initProcessVariableTypeColumn();
        Column<ProcessVariableSummary, ?> lastModificationColumn = this.initProcessVariableLastModifiedColumn();
        this.actionsColumn = this.initActionsColumn();
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        columnMetas.add(new ColumnMeta(variableId, this.constants.Name()));
        columnMetas.add(new ColumnMeta(valueColumn, this.constants.Value()));
        columnMetas.add(new ColumnMeta(typeColumn, this.constants.Type()));
        columnMetas.add(new ColumnMeta(lastModificationColumn, this.constants.Last_Modification()));
        columnMetas.add(new ColumnMeta(this.actionsColumn, this.constants.Actions()));
        extendedPagedTable.addColumns(columnMetas);
    }

    private Column<ProcessVariableSummary, ?> initProcessVariableIdColumn() {
        Column<ProcessVariableSummary, String> variableId = new Column<ProcessVariableSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessVariableSummary object) {
                return object.getVariableId();
            }
        };
        variableId.setSortable(true);
        variableId.setDataStoreName(COL_ID_VARID);
        return variableId;
    }

    private Column<ProcessVariableSummary, ?> initProcessVariableValueColumn() {
        Column<ProcessVariableSummary, String> valueColumn = new Column<ProcessVariableSummary, String>((Cell)new PopoverTextCell()){

            public String getValue(ProcessVariableSummary object) {
                return object.getNewValue() != null ? object.getNewValue() : "";
            }
        };
        valueColumn.setSortable(true);
        valueColumn.setDataStoreName(COL_ID_VARVALUE);
        return valueColumn;
    }

    public Column<ProcessVariableSummary, String> initProcessVariableTypeColumn() {
        Column<ProcessVariableSummary, String> typeColumn = new Column<ProcessVariableSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessVariableSummary object) {
                return object.getType();
            }
        };
        typeColumn.setSortable(true);
        typeColumn.setDataStoreName(COL_ID_VARTYPE);
        return typeColumn;
    }

    private Column<ProcessVariableSummary, ?> initProcessVariableLastModifiedColumn() {
        Column<ProcessVariableSummary, String> lastModificationColumn = new Column<ProcessVariableSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessVariableSummary object) {
                return DateUtils.getDateTimeStr((Date)new Date(object.getTimestamp()));
            }
        };
        lastModificationColumn.setSortable(true);
        lastModificationColumn.setDataStoreName(COL_ID_LASTMOD);
        return lastModificationColumn;
    }

    private Column initActionsColumn() {
        LinkedList<ButtonActionCell> cells = new LinkedList<ButtonActionCell>();
        cells.add(new EditVariableActionHasCell(this.constants.Edit(), new ActionCell.Delegate<ProcessVariableSummary>(){

            public void execute(ProcessVariableSummary variable) {
                ProcessVariableListViewImpl.this.variableEditPopup.show(variable.getServerTemplateId(), variable.getDeploymentId(), variable.getProcessInstanceId(), variable.getVariableId(), variable.getNewValue() != null ? variable.getNewValue() : "");
            }
        }));
        cells.add(new VariableHistoryActionHasCell(this.constants.History(), new ActionCell.Delegate<ProcessVariableSummary>(){

            public void execute(final ProcessVariableSummary variable) {
                ProcessVariableListViewImpl.this.showBusyIndicator(ProcessVariableListViewImpl.this.constants.Loading());
                ((ProcessVariableListPresenter)ProcessVariableListViewImpl.this.presenter).loadVariableHistory(new ParameterizedCommand<List<ProcessVariableSummary>>(){

                    public void execute(List<ProcessVariableSummary> processVariableSummaries) {
                        ProcessVariableListViewImpl.this.hideBusyIndicator();
                        ProcessVariableListViewImpl.this.variableHistoryPopup.show(variable.getVariableId(), processVariableSummaries);
                    }
                }, variable.getVariableId());
            }
        }));
        CompositeCell cell = new CompositeCell(cells);
        Column<ProcessVariableSummary, ProcessVariableSummary> actionsColumn = new Column<ProcessVariableSummary, ProcessVariableSummary>((Cell)cell){

            public ProcessVariableSummary getValue(ProcessVariableSummary object) {
                return object;
            }
        };
        actionsColumn.setDataStoreName(COL_ID_ACTIONS);
        return actionsColumn;
    }

    public void formClosed(@Observes ProcessInstancesUpdateEvent closed) {
        ((ProcessVariableListPresenter)this.presenter).refreshGrid();
    }

    protected class VariableHistoryActionHasCell
    extends ButtonActionCell<ProcessVariableSummary> {
        public VariableHistoryActionHasCell(String text, ActionCell.Delegate<ProcessVariableSummary> delegate) {
            super(text, delegate);
        }

        public void render(Cell.Context context, ProcessVariableSummary value, SafeHtmlBuilder sb) {
            super.render(context, (Object)value, sb);
        }
    }

    protected class EditVariableActionHasCell
    extends ButtonActionCell<ProcessVariableSummary> {
        public EditVariableActionHasCell(String text, ActionCell.Delegate<ProcessVariableSummary> delegate) {
            super(text, delegate);
        }

        public void render(Cell.Context context, ProcessVariableSummary value, SafeHtmlBuilder sb) {
            if (((ProcessVariableListPresenter)ProcessVariableListViewImpl.this.presenter).getProcessInstanceStatus() == 1) {
                super.render(context, (Object)value, sb);
            }
        }
    }
}

