/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.details;

import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.model.NodeInstanceSummary;
import org.jbpm.workbench.pr.model.ProcessInstanceKey;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.jbpm.workbench.pr.model.UserTaskSummary;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;

@Dependent
public class ProcessInstanceDetailsTabPresenter {
    private String currentDeploymentId;
    private String currentProcessInstanceId;
    private String currentServerTemplateId;
    private ProcessInstanceDetailsTabView view;
    private Constants constants = Constants.INSTANCE;
    private Caller<ProcessRuntimeDataService> processRuntimeDataService;

    @Inject
    public void setView(ProcessInstanceDetailsTabView view) {
        this.view = view;
    }

    @Inject
    public void setProcessRuntimeDataService(Caller<ProcessRuntimeDataService> processRuntimeDataService) {
        this.processRuntimeDataService = processRuntimeDataService;
    }

    public IsWidget getWidget() {
        return this.view;
    }

    public void onProcessInstanceSelectionEvent(@Observes ProcessInstanceSelectionEvent event) {
        this.currentDeploymentId = event.getDeploymentId();
        this.currentProcessInstanceId = String.valueOf(event.getProcessInstanceId());
        this.currentServerTemplateId = event.getServerTemplateId();
        this.refreshProcessInstanceDataRemote(this.currentDeploymentId, this.currentProcessInstanceId, this.currentServerTemplateId);
    }

    public void refreshProcessInstanceDataRemote(String deploymentId, String processId, String serverTemplateId) {
        this.view.setProcessDefinitionIdText("");
        this.view.setProcessVersionText("");
        this.view.setProcessDeploymentText("");
        this.view.setCorrelationKeyText("");
        this.view.setParentProcessInstanceIdText("");
        this.view.setActiveTasksListBox("");
        this.view.setStateText("");
        this.view.setCurrentActivitiesListBox("");
        ((ProcessRuntimeDataService)this.processRuntimeDataService.call(process -> {
            this.view.setProcessDefinitionIdText(process.getProcessId());
            this.view.setProcessVersionText(process.getProcessVersion());
            this.view.setProcessDeploymentText(process.getDeploymentId());
            this.view.setCorrelationKeyText(process.getCorrelationKey());
            if (process.getParentId() > 0L) {
                this.view.setParentProcessInstanceIdText(process.getParentId().toString());
            } else {
                this.view.setParentProcessInstanceIdText(this.constants.No_Parent_Process_Instance());
            }
            String statusStr = this.constants.Unknown();
            switch (process.getState()) {
                case 1: {
                    statusStr = this.constants.Active();
                    break;
                }
                case 3: {
                    statusStr = this.constants.Aborted();
                    break;
                }
                case 2: {
                    statusStr = this.constants.Completed();
                    break;
                }
                case 0: {
                    statusStr = this.constants.Pending();
                    break;
                }
                case 4: {
                    statusStr = this.constants.Suspended();
                    break;
                }
            }
            this.view.setStateText(statusStr);
            String slaComplianceStr = this.mapSlaCompliance((ProcessInstanceSummary)process);
            this.view.setSlaComplianceText(slaComplianceStr);
            if (process.getActiveTasks() != null && !process.getActiveTasks().isEmpty()) {
                SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
                for (UserTaskSummary uts : process.getActiveTasks()) {
                    safeHtmlBuilder.appendEscapedLines(uts.getName() + " (" + uts.getStatus() + ")  " + this.constants.Owner() + ": " + uts.getOwner() + " \n");
                }
                this.view.setActiveTasksListBox(safeHtmlBuilder.toSafeHtml().asString());
            }
        })).getProcessInstance(serverTemplateId, new ProcessInstanceKey(serverTemplateId, deploymentId, Long.valueOf(Long.parseLong(processId))));
        ((ProcessRuntimeDataService)this.processRuntimeDataService.call(details -> {
            SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
            for (NodeInstanceSummary nis : details) {
                safeHtmlBuilder.appendEscapedLines(nis.getTimestamp() + ": " + nis.getId() + " - " + nis.getNodeName() + " (" + nis.getType() + ") \n");
            }
            this.view.setCurrentActivitiesListBox(safeHtmlBuilder.toSafeHtml().asString());
        })).getProcessInstanceActiveNodes(serverTemplateId, deploymentId, Long.valueOf(Long.parseLong(processId)));
    }

    protected String mapSlaCompliance(ProcessInstanceSummary process) {
        String slaComplianceStr = this.constants.Unknown();
        switch (process.getSlaCompliance()) {
            case 0: {
                slaComplianceStr = this.constants.SlaNA();
                break;
            }
            case 1: {
                slaComplianceStr = this.constants.SlaPending();
                break;
            }
            case 2: {
                slaComplianceStr = this.constants.SlaMet();
                break;
            }
            case 4: {
                slaComplianceStr = this.constants.SlaAborted();
                break;
            }
            case 3: {
                slaComplianceStr = this.constants.SlaViolated();
                break;
            }
        }
        return slaComplianceStr;
    }

    public static interface ProcessInstanceDetailsTabView
    extends IsWidget {
        public void setCurrentActivitiesListBox(String var1);

        public void setActiveTasksListBox(String var1);

        public void setProcessDefinitionIdText(String var1);

        public void setStateText(String var1);

        public void setProcessDeploymentText(String var1);

        public void setProcessVersionText(String var1);

        public void setCorrelationKeyText(String var1);

        public void setParentProcessInstanceIdText(String var1);

        public void setSlaComplianceText(String var1);
    }
}

