/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.log;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItem;
import org.jbpm.workbench.common.client.filters.basic.BasicFiltersPresenter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.client.util.LogUtils;

@Dependent
public class ProcessInstanceLogBasicFiltersPresenter
extends BasicFiltersPresenter {
    private Constants constants = Constants.INSTANCE;

    public String getDataSetId() {
        return "jbpmProcessInstanceLogs";
    }

    public void loadFilters() {
        HashMap<String, String> logStateOptions = new HashMap<String, String>();
        logStateOptions.put(LogUtils.NODE_ENTERED.toString(), this.constants.NodeEntered());
        logStateOptions.put(LogUtils.NODE_COMPLETED.toString(), this.constants.NodeCompleted());
        this.view.addMultiSelectFilter(this.constants.EventType(), logStateOptions, f -> {
            List values = (List)f.getValue();
            ColumnFilter columnFilter = FilterFactory.in((String)"type", (List)values);
            this.addSearchFilterList((ActiveFilterItem)f, columnFilter);
        });
        HashMap<String, String> logTypeOptions = new HashMap<String, String>();
        logTypeOptions.put(LogUtils.ALL_NODES, this.constants.All());
        logTypeOptions.put(LogUtils.NODE_TYPE_HUMAN_TASK, this.constants.Human_Tasks());
        logTypeOptions.put(LogUtils.NODE_TYPE_START, this.constants.StartNodes());
        logTypeOptions.put(LogUtils.NODE_TYPE_END, this.constants.EndNodes());
        logTypeOptions.put(LogUtils.NODE_TYPE_ACTION, this.constants.ActionNodes());
        logTypeOptions.put(LogUtils.NODE_TYPE_MILESTONE, this.constants.Milestones());
        logTypeOptions.put(LogUtils.NODE_TYPE_SUBPROCESS, this.constants.SubProcesses());
        logTypeOptions.put(LogUtils.NODE_TYPE_RULE_SET, this.constants.RuleSets());
        logTypeOptions.put(LogUtils.NODE_TYPE_WORK_ITEM, this.constants.WorkItems());
        this.view.addMultiSelectFilter(this.constants.EventNodeType(), logTypeOptions, f -> {
            List values = (List)f.getValue();
            ColumnFilter columnFilter = FilterFactory.in((String)"nodeType", (List)values);
            if (values != null && values.contains(LogUtils.ALL_NODES)) {
                this.removeSearchFilter((ActiveFilterItem)f, columnFilter);
                this.checkSelectFilterValues(this.constants.EventNodeType(), Arrays.asList(LogUtils.NODE_TYPE_HUMAN_TASK, LogUtils.NODE_TYPE_START, LogUtils.NODE_TYPE_END, LogUtils.NODE_TYPE_ACTION, LogUtils.NODE_TYPE_MILESTONE, LogUtils.NODE_TYPE_SUBPROCESS, LogUtils.NODE_TYPE_RULE_SET, LogUtils.NODE_TYPE_WORK_ITEM));
            } else {
                this.addSearchFilterList((ActiveFilterItem)f, columnFilter);
            }
        });
        this.view.hideFilterBySection();
    }

    protected void onActiveFilterAdded(ActiveFilterItem activeFilterItem) {
        if (activeFilterItem.getKey().equals(this.constants.EventNodeType())) {
            this.checkSelectFilterValues(this.constants.EventNodeType(), (List)activeFilterItem.getValue());
        }
        if (activeFilterItem.getKey().equals(this.constants.EventType())) {
            this.checkSelectFilterValues(this.constants.EventType(), (List)activeFilterItem.getValue());
        }
    }

    public void checkSelectFilterValues(String label, List<String> values) {
        values.forEach(v -> this.view.checkSelectFilter(label, v));
    }
}

