/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.log;

import java.util.Date;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.ht.model.TaskSummary;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.client.util.TaskStatusConverter;

@Dependent
@Templated
public class ProcessInstanceLogHumanTaskView
implements IsElement {
    private Constants constants = Constants.INSTANCE;
    @Inject
    @DataField(value="humanTaskContainer")
    Div humanTaskContainer;
    @Inject
    @DataField(value="createdOn")
    Span createdOn;
    @Inject
    @DataField(value="createdBy")
    Span createdBy;
    @Inject
    @DataField(value="updatedOn")
    Span updatedOn;
    @Inject
    @DataField(value="taskId")
    Span taskId;
    @Inject
    @DataField(value="taskStatus")
    Span taskStatus;
    @Inject
    @DataField(value="actualOwner")
    Span actualOwner;
    @Inject
    @DataField(value="description")
    Span description;

    public HTMLElement getElement() {
        return this.humanTaskContainer;
    }

    public void setDetailsData(TaskSummary model, Date logDate) {
        this.taskId.setTextContent(((Long)model.getId()).toString());
        this.createdOn.setTextContent(DateUtils.getDateTimeStr((Date)model.getCreatedOn()));
        this.createdBy.setTextContent(model.getCreatedBy());
        this.updatedOn.setTextContent(DateUtils.getDateTimeStr((Date)logDate));
        this.taskId.setTextContent(((Long)model.getId()).toString());
        this.taskStatus.setTextContent(new TaskStatusConverter().toWidgetValue(model.getTaskStatus()));
        if (model.getActualOwner().isEmpty()) {
            this.actualOwner.setTextContent(this.constants.NotClaimed());
        } else {
            this.actualOwner.setTextContent(model.getActualOwner());
        }
        this.description.setTextContent(model.getDescription());
    }
}

