/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.diagram;

import com.google.gwt.dom.client.Node;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Composite;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLParagraphElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Anchor;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.pr.client.editors.diagram.ProcessDiagramWidgetViewImpl;
import org.jbpm.workbench.pr.client.editors.instance.diagram.NodeCounterView;
import org.jbpm.workbench.pr.client.editors.instance.diagram.NodeInstancesView;
import org.jbpm.workbench.pr.client.editors.instance.diagram.ProcessInstanceDiagramView;
import org.jbpm.workbench.pr.client.editors.instance.diagram.ProcessNodeItemView;
import org.jbpm.workbench.pr.client.editors.instance.diagram.SubProcessInstancesView;
import org.jbpm.workbench.pr.client.editors.instance.diagram.TimerInstancesView;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.model.NodeInstanceSummary;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.jbpm.workbench.pr.model.ProcessNodeSummary;
import org.jbpm.workbench.pr.model.TimerInstanceSummary;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.views.pfly.widgets.D3;
import org.uberfire.client.views.pfly.widgets.Select;

@Dependent
@Templated(stylesheet="ProcessInstanceDiagram.css")
public class ProcessInstanceDiagramViewImpl
extends Composite
implements ProcessInstanceDiagramView {
    @Inject
    @DataField(value="diagram")
    private ProcessDiagramWidgetViewImpl diagram;
    @Inject
    @DataField(value="available-nodes")
    private Select processNodes;
    @Inject
    @DataField(value="diagram-details")
    private HTMLDivElement diagramDetails;
    @Inject
    @DataField(value="node-details-panel")
    private ProcessNodeItemView processNodeSummaryView;
    @Inject
    @DataField(value="node-instances")
    private NodeInstancesView nodeInstancesView;
    @Inject
    @DataField(value="timer-instances")
    private TimerInstancesView timerInstancesView;
    @Inject
    @DataField(value="node-actions-panel")
    private HTMLDivElement nodeActionsPanel;
    @Inject
    @DataField(value="parent-sub-process")
    private HTMLDivElement parentAndSubProcessDiv;
    @Inject
    private NodeCounterView nodeCounterView;
    @Inject
    @DataField(value="sub-process-instances")
    private SubProcessInstancesView subProcessInstancesView;
    @Inject
    @DataField(value="parent-process-name")
    private Anchor parentProcessAnchor;
    @Inject
    @DataField(value="none-sub-process")
    private HTMLParagraphElement noneSubProcess;
    private Callback<String> onProcessNodeSelectedCallback;
    private Command parentSelectedCommand;
    private boolean renderBadges = true;
    private Map<String, Long> badges = new HashMap<String, Long>();
    private Constants constants = Constants.INSTANCE;
    private Command showOrHideParentAndSubProcessPanelCommand;
    private Command showOrHideNodeActionsCommand;

    @PostConstruct
    public void init() {
        this.nodeCounterView.setCallback(() -> this.showHideBadges());
        this.noneSubProcess.classList.add(new String[]{"hidden"});
    }

    @Override
    public void setOnProcessNodeSelectedCallback(Callback<String> callback) {
        this.onProcessNodeSelectedCallback = callback;
    }

    @Override
    public void setOnDiagramNodeSelectionCallback(Callback<String> callback) {
        this.diagram.setOnDiagramNodeSelectionCallback(callback);
    }

    @Override
    public void setOnDiagramNodeSelectionDoubleClick(Callback<String> callback) {
        this.diagram.setOnNodeSelectionDoubleClick(callback);
    }

    @Override
    public void setParentSelectedCommand(Command parentSelectedCommand) {
        this.parentSelectedCommand = parentSelectedCommand;
    }

    @Override
    public void setProcessNodes(List<ProcessNodeSummary> nodes) {
        this.processNodes.removeAllOptions();
        nodes.forEach(node -> this.processNodes.addOption(node.getLabel(), node.getUniqueId()));
        this.processNodes.refresh();
    }

    public ProcessNodeSummary getValue() {
        return this.processNodeSummaryView.getValue();
    }

    public void setValue(ProcessNodeSummary node) {
        this.processNodeSummaryView.setValue(node);
        if (node.getId() == null) {
            this.processNodeSummaryView.getElement().classList.add(new String[]{"hidden"});
            this.processNodes.setValue("");
        } else {
            this.processNodeSummaryView.getElement().classList.remove(new String[]{"hidden"});
            this.processNodes.setValue(node.getUniqueId());
        }
    }

    @Override
    public void setNodeInstances(List<NodeInstanceSummary> nodes) {
        if (nodes.isEmpty()) {
            this.nodeInstancesView.getElement().classList.add(new String[]{"hidden"});
        } else {
            this.nodeInstancesView.getElement().classList.remove(new String[]{"hidden"});
        }
        this.nodeInstancesView.setValue(nodes);
    }

    @Override
    public void showParentAndSubProcessPanel() {
        this.parentAndSubProcessDiv.classList.remove(new String[]{"hidden"});
    }

    @Override
    public void hideParentAndSubProcessPanel() {
        this.parentAndSubProcessDiv.classList.add(new String[]{"hidden"});
    }

    @Override
    public void setShowOrHideParentAndSubProcessPanelCommand(Command command) {
        this.showOrHideParentAndSubProcessPanelCommand = command;
    }

    @Override
    public void showOrHideParentAndSubProcessPanelTriggered() {
        if (this.showOrHideParentAndSubProcessPanelCommand != null) {
            this.showOrHideParentAndSubProcessPanelCommand.execute();
        }
    }

    @Override
    public void setSubProcessInstances(List<ProcessInstanceSummary> subProcessInstances) {
        if (subProcessInstances.isEmpty()) {
            this.subProcessInstancesView.getElement().classList.add(new String[]{"hidden"});
            this.noneSubProcess.classList.remove(new String[]{"hidden"});
            this.noneSubProcess.textContent = this.constants.None();
        } else {
            this.subProcessInstancesView.getElement().classList.remove(new String[]{"hidden"});
            this.subProcessInstancesView.setValue(subProcessInstances);
            this.noneSubProcess.classList.add(new String[]{"hidden"});
        }
    }

    @Override
    public void setParentProcessInstance(ProcessInstanceSummary parentProcessInstance) {
        if (parentProcessInstance == null) {
            this.parentProcessAnchor.setText(this.constants.None());
            this.parentProcessAnchor.setEnabled(false);
        } else {
            this.parentProcessAnchor.setText(this.constants.ProcessInstanceIdAndName(parentProcessInstance.getProcessInstanceId().toString(), parentProcessInstance.getProcessName()));
            this.parentProcessAnchor.setEnabled(true);
        }
    }

    @Override
    public void setTimerInstances(List<TimerInstanceSummary> timers) {
        if (timers.isEmpty()) {
            this.timerInstancesView.getElement().classList.add(new String[]{"hidden"});
        } else {
            this.timerInstancesView.getElement().classList.remove(new String[]{"hidden"});
        }
        this.timerInstancesView.setValue(timers);
    }

    @EventHandler(value={"available-nodes"})
    public void onProcessNodeChange(@ForEvent(value={"change"}) Event e) {
        this.processNodes.toggle();
        if (this.onProcessNodeSelectedCallback != null) {
            String node = this.processNodes.getValue();
            this.onProcessNodeSelectedCallback.callback(node == null || node.trim().isEmpty() ? null : node);
        }
    }

    @Override
    public void showNodeActions() {
        this.nodeActionsPanel.classList.remove(new String[]{"hidden"});
    }

    @Override
    public void hideNodeActions() {
        this.nodeActionsPanel.classList.add(new String[]{"hidden"});
    }

    @Override
    public void setShowOrHideNodeActionsCommand(Command command) {
        this.showOrHideNodeActionsCommand = command;
    }

    @Override
    public void showOrHideNodeActionsTriggered() {
        if (this.showOrHideNodeActionsCommand != null) {
            this.showOrHideNodeActionsCommand.execute();
        }
    }

    @Override
    public void expandDiagram() {
        this.diagramDetails.classList.add(new String[]{"hidden"});
        this.diagram.expandDiagramContainer();
    }

    @Override
    public void displayImage(String svgContent) {
        this.diagram.displayImage(svgContent);
        this.diagram.getElement().appendChild((Node)this.nodeCounterView.getElement());
    }

    @Override
    public void setNodeBadges(Map<String, Long> badges) {
        this.badges = badges;
        this.renderBadges = true;
    }

    @Override
    public void onShow() {
        this.renderBadges();
    }

    protected void showHideBadges() {
        D3 d3 = D3.Builder.get();
        D3.Selection nodes = d3.selectAll("#processDiagramDiv svg [jbpm-node-badge]");
        nodes.attr("visibility", (Object)(this.nodeCounterView.showBadges() ? "visible" : "hidden"));
    }

    protected void renderBadges() {
        if (!this.renderBadges) {
            return;
        }
        D3 d3 = D3.Builder.get();
        D3.Selection svg = d3.select("#processDiagramDiv svg");
        if (svg.empty()) {
            return;
        }
        D3.DOMRect svgRect = svg.node().getBoundingClientRect();
        if (svgRect.getWidth() == 0.0 && svgRect.getHeight() == 0.0) {
            return;
        }
        boolean isOryx = svg.attr(":xmlns:oryx") != null;
        this.badges.forEach((nodeId, count) -> {
            String path = "#processDiagramDiv svg [bpmn2nodeid='" + nodeId + "'] " + (isOryx ? ".stencils" : "");
            D3.Selection node = d3.select(path);
            if (node.empty()) {
                return;
            }
            D3.DOMRect bb = node.node().getBoundingClientRect();
            D3 group = node.append("g").attr("transform", (Object)("translate( " + (bb.getWidth() / 2.0 - 12.5) + ", " + (bb.getHeight() + 2.0) + ")")).attr("jbpm-node-badge", nodeId);
            group.append("rect").attr("x", (Object)"0").attr("y", (Object)"0").attr("width", (Object)"25").attr("height", (Object)"20").attr("rx", (Object)"5").attr("ry", (Object)"5").attr("fill", (Object)"grey").attr("opacity", (Object)"0.5");
            group.append("text").attr("font-size", (Object)"10pt").attr("font-weight", (Object)"normal").attr("font-family", (Object)"Open Sans").attr("font-style", (Object)"normal").attr("text-anchor", (Object)"middle").attr("fill", (Object)"white").attr("x", (Object)"12").attr("y", (Object)"15").text(String.valueOf(count));
        });
        this.showHideBadges();
        this.renderBadges = false;
    }

    @Override
    public void displayMessage(String message) {
        this.diagram.displayMessage(message);
    }

    public void showBusyIndicator(String message) {
        this.diagram.showBusyIndicator(message);
    }

    public void hideBusyIndicator() {
        this.diagram.hideBusyIndicator();
    }

    @EventHandler(value={"parent-process-name"})
    protected void onClickParentInstanceName(ClickEvent event) {
        if (this.parentSelectedCommand != null) {
            this.parentSelectedCommand.execute();
        }
    }

    @Override
    public void disableExpandAnchor() {
        this.diagram.disableExpandAnchor();
    }
}

