/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.definition.details.advance;

import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.workbench.pr.client.editors.definition.details.BaseProcessDefDetailsPresenter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.model.ProcessDefinitionKey;
import org.jbpm.workbench.pr.model.ProcessSummary;
import org.jbpm.workbench.pr.model.TaskDefSummary;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;

@Dependent
public class AdvancedViewProcessDefDetailsPresenter
extends BaseProcessDefDetailsPresenter {
    private Constants constants = Constants.INSTANCE;
    @Inject
    private AdvancedProcessDefDetailsView view;
    @Inject
    private Caller<ProcessRuntimeDataService> processRuntimeDataService;

    @Override
    public IsWidget getWidget() {
        return this.view;
    }

    @Override
    protected void refreshView(String serverTemplateId, String processId, String deploymentId) {
        this.view.getProcessIdText().setText(processId);
        this.view.getDeploymentIdText().setText(deploymentId);
    }

    private void refreshServiceTasks(Map<String, String> services) {
        this.view.getProcessServicesListBox().setText("");
        SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
        if (services.keySet().isEmpty()) {
            safeHtmlBuilder.appendEscaped(this.constants.NoServicesRequiredForThisProcess());
            this.view.getProcessServicesListBox().setStyleName("muted");
            this.view.getProcessServicesListBox().setHTML(safeHtmlBuilder.toSafeHtml());
        } else {
            for (String key : services.keySet()) {
                safeHtmlBuilder.appendEscapedLines(key + " - " + services.get(key) + "\n");
            }
            this.view.getProcessServicesListBox().setHTML(safeHtmlBuilder.toSafeHtml());
        }
    }

    private void refreshProcessItems(ProcessSummary process) {
        if (process != null) {
            this.view.getProcessNameText().setText(process.getName());
            this.changeStyleRow(process.getName(), process.getVersion());
        } else {
            this.view.getProcessNameText().setText("");
        }
    }

    private void refreshReusableSubProcesses(Collection<String> subprocesses) {
        this.view.getSubprocessListBox().setText("");
        SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
        if (subprocesses.isEmpty()) {
            safeHtmlBuilder.appendEscapedLines(this.constants.NoSubprocessesRequiredByThisProcess());
            this.view.getSubprocessListBox().setStyleName("muted");
            this.view.getSubprocessListBox().setHTML(safeHtmlBuilder.toSafeHtml());
        } else {
            for (String key : subprocesses) {
                safeHtmlBuilder.appendEscapedLines(key + "\n");
            }
            this.view.getSubprocessListBox().setHTML(safeHtmlBuilder.toSafeHtml());
        }
    }

    private void refreshRequiredInputData(Map<String, String> inputs) {
        this.view.getProcessDataListBox().setText("");
        SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
        if (inputs.keySet().isEmpty()) {
            safeHtmlBuilder.appendEscapedLines(this.constants.NoProcessVariablesDefinedForThisProcess());
            this.view.getProcessDataListBox().setStyleName("muted");
            this.view.getProcessDataListBox().setHTML(safeHtmlBuilder.toSafeHtml());
        } else {
            for (String key : inputs.keySet()) {
                safeHtmlBuilder.appendEscapedLines(key + " - " + inputs.get(key) + "\n");
            }
            this.view.getProcessDataListBox().setHTML(safeHtmlBuilder.toSafeHtml());
        }
    }

    private void refreshAssociatedEntities(Map<String, String[]> entities) {
        this.view.getUsersGroupsListBox().setText("");
        SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
        if (entities.keySet().isEmpty()) {
            safeHtmlBuilder.appendEscapedLines(this.constants.NoUserOrGroupUsedInThisProcess());
            this.view.getUsersGroupsListBox().setStyleName("muted");
            this.view.getUsersGroupsListBox().setHTML(safeHtmlBuilder.toSafeHtml());
        } else {
            for (String key : entities.keySet()) {
                StringBuffer names = new StringBuffer();
                String[] entityNames = entities.get(key);
                if (entityNames != null) {
                    for (String entity : entityNames) {
                        names.append("'" + entity + "' ");
                    }
                }
                safeHtmlBuilder.appendEscapedLines(names + " - " + key + "\n");
            }
            this.view.getUsersGroupsListBox().setHTML(safeHtmlBuilder.toSafeHtml());
        }
    }

    private void refreshTaskDef(String serverTemplateId, String deploymentId, String processId) {
        this.view.getNroOfHumanTasksText().setText("");
        this.view.getHumanTasksListBox().setText("");
        ((ProcessRuntimeDataService)this.processRuntimeDataService.call((RemoteCallback)new RemoteCallback<List<TaskDefSummary>>(){

            public void callback(List<TaskDefSummary> userTaskSummaries) {
                AdvancedViewProcessDefDetailsPresenter.this.view.getNroOfHumanTasksText().setText(String.valueOf(userTaskSummaries.size()));
                SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
                if (userTaskSummaries.isEmpty()) {
                    safeHtmlBuilder.appendEscapedLines(AdvancedViewProcessDefDetailsPresenter.this.constants.NoUserTasksDefinedInThisProcess());
                    AdvancedViewProcessDefDetailsPresenter.this.view.getHumanTasksListBox().setStyleName("muted");
                    AdvancedViewProcessDefDetailsPresenter.this.view.getHumanTasksListBox().setHTML(safeHtmlBuilder.toSafeHtml());
                } else {
                    for (TaskDefSummary t : userTaskSummaries) {
                        safeHtmlBuilder.appendEscapedLines(t.getName() + "\n");
                    }
                    AdvancedViewProcessDefDetailsPresenter.this.view.getHumanTasksListBox().setHTML(safeHtmlBuilder.toSafeHtml());
                }
            }
        })).getProcessUserTasks(serverTemplateId, deploymentId, processId);
    }

    @Override
    protected void refreshProcessDef(final String serverTemplateId, final String deploymentId, final String processId) {
        ((ProcessRuntimeDataService)this.processRuntimeDataService.call((RemoteCallback)new RemoteCallback<ProcessSummary>(){

            public void callback(ProcessSummary process) {
                if (process != null) {
                    AdvancedViewProcessDefDetailsPresenter.this.refreshTaskDef(serverTemplateId, deploymentId, processId);
                    AdvancedViewProcessDefDetailsPresenter.this.refreshAssociatedEntities(process.getAssociatedEntities());
                    AdvancedViewProcessDefDetailsPresenter.this.refreshRequiredInputData(process.getProcessVariables());
                    AdvancedViewProcessDefDetailsPresenter.this.refreshReusableSubProcesses(process.getReusableSubProcesses());
                    AdvancedViewProcessDefDetailsPresenter.this.refreshProcessItems(process);
                    AdvancedViewProcessDefDetailsPresenter.this.refreshServiceTasks(process.getServiceTasks());
                }
            }
        })).getProcess(serverTemplateId, new ProcessDefinitionKey(serverTemplateId, deploymentId, processId));
    }

    public static interface AdvancedProcessDefDetailsView
    extends BaseProcessDefDetailsPresenter.BaseProcessDefDetailsView {
        public HTML getNroOfHumanTasksText();

        public HTML getHumanTasksListBox();

        public HTML getUsersGroupsListBox();

        public HTML getProcessDataListBox();

        public HTML getProcessServicesListBox();

        public HTML getSubprocessListBox();
    }
}

