/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.signal;

import com.google.gwt.core.client.GWT;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.ProcessInstancesUpdateEvent;
import org.jbpm.workbench.pr.service.ProcessService;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchPopup;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;

@Dependent
@WorkbenchPopup(identifier="Signal Process Popup")
public class ProcessInstanceSignalPresenter {
    public static final String SIGNAL_PROCESS_POPUP = "Signal Process Popup";
    private Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    private PopupView view;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private Event<ProcessInstancesUpdateEvent> processInstancesUpdatedEvent;
    private PlaceRequest place;
    private Caller<ProcessService> processService;
    private String serverTemplateId;
    private String[] deploymentId;

    @Inject
    public void setProcessService(Caller<ProcessService> processService) {
        this.processService = processService;
    }

    @PostConstruct
    public void init() {
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Signaling_Process_Instance();
    }

    @WorkbenchPartView
    public UberView<ProcessInstanceSignalPresenter> getView() {
        return this.view;
    }

    public void signalProcessInstances(List<Long> processInstanceIds) {
        if (this.view.getSignalRefText() == null || this.view.getSignalRefText().isEmpty()) {
            this.view.setHelpText(this.constants.Signal_Name_Required());
            return;
        }
        for (Long processInstanceId : processInstanceIds) {
            this.view.displayNotification(this.constants.Signalling_Process_Instance() + processInstanceId + " " + this.constants.Signal() + " = " + this.view.getSignalRefText() + " - " + this.constants.Signal_Data() + " = " + this.view.getEventText());
        }
        ((ProcessService)this.processService.call(v -> {
            this.processInstancesUpdatedEvent.fire((Object)new ProcessInstancesUpdateEvent(Long.valueOf(0L)));
            this.placeManager.closePlace(this.place);
        })).signalProcessInstances(this.serverTemplateId, Arrays.asList(this.deploymentId), processInstanceIds, this.view.getSignalRefText(), (Object)this.view.getEventText());
    }

    @OnOpen
    public void onOpen() {
        String[] ids;
        this.serverTemplateId = this.place.getParameter("serverTemplateId", "").toString();
        this.deploymentId = this.place.getParameter("deploymentId", "").toString().split(",");
        String processInstanceIds = this.place.getParameter("processInstanceId", "-1").toString();
        for (String id : ids = processInstanceIds.split(",")) {
            long processInstanceId = Long.parseLong(id);
            this.view.addProcessInstanceId(processInstanceId);
        }
        if (ids.length == 1 && Long.parseLong(ids[0]) != -1L) {
            this.getAvailableSignals(Long.parseLong(ids[0]));
        }
    }

    public void getAvailableSignals(long processInstanceId) {
        ((ProcessService)this.processService.call((RemoteCallback)new RemoteCallback<Collection<String>>(){

            public void callback(Collection<String> signals) {
                ProcessInstanceSignalPresenter.this.view.setAvailableSignals(signals);
            }
        })).getAvailableSignals(this.serverTemplateId, this.deploymentId[0], Long.valueOf(processInstanceId));
    }

    public static interface PopupView
    extends UberView<ProcessInstanceSignalPresenter> {
        public void displayNotification(String var1);

        public void addProcessInstanceId(long var1);

        public String getSignalRefText();

        public String getEventText();

        public void setAvailableSignals(Collection<String> var1);

        public void setHelpText(String var1);
    }
}

