/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.diagram;

import com.google.gwt.dom.client.Document;
import com.google.gwt.user.client.TakesValue;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLParagraphElement;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.EventListener;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.ListItem;
import org.jboss.errai.common.client.dom.MouseEvent;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.common.client.dom.Window;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.util.DateTimeConverter;
import org.jbpm.workbench.common.client.util.DateTimeNAConverter;
import org.jbpm.workbench.common.model.GenericSummary;
import org.jbpm.workbench.pr.client.editors.instance.diagram.TimerInstanceDelayConverter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.model.TimerInstanceSummary;

@Dependent
@Templated(stylesheet="ProcessInstanceDiagram.css")
public class TimerInstanceItemView
implements TakesValue<TimerInstanceSummary>,
IsElement {
    private Constants constants = Constants.INSTANCE;
    @Inject
    @DataField(value="list-item")
    private ListItem listItem;
    @Inject
    @Bound
    @DataField(value="label")
    private HTMLAnchorElement label;
    @Inject
    @Bound
    @DataField(value="description")
    private HTMLParagraphElement description;
    @Inject
    @DataField(value="actions-items")
    private UnorderedList actionsItems;
    @Inject
    @DataField(value="details")
    private HTMLDivElement details;
    @Inject
    @DataField(value="timer-id")
    @Bound
    private Span id;
    @Inject
    @DataField(value="timer-delay")
    @Bound(converter=TimerInstanceDelayConverter.class)
    private Span delay;
    @Inject
    @DataField(value="timer-period")
    @Bound
    private Span period;
    @Inject
    @DataField(value="timer-repeat-limit")
    @Bound
    private Span repeatLimit;
    @Inject
    @DataField(value="timer-last-fire-time")
    @Bound(converter=DateTimeNAConverter.class)
    private Span lastFireTime;
    @Inject
    @DataField(value="timer-next-fire-time")
    @Bound(converter=DateTimeConverter.class)
    private Span nextFireTime;
    @Inject
    @DataField(value="timer-activation-time")
    @Bound(converter=DateTimeConverter.class)
    private Span activationTime;
    @Inject
    @AutoBound
    private DataBinder<TimerInstanceSummary> timerInstance;

    public HTMLElement getElement() {
        return this.listItem;
    }

    public TimerInstanceSummary getValue() {
        return (TimerInstanceSummary)this.timerInstance.getModel();
    }

    public void setValue(TimerInstanceSummary timer) {
        this.timerInstance.setModel((Object)timer);
        if (timer.hasCallbacks()) {
            for (GenericSummary.LabeledCommand callback : timer.getCallbacks()) {
                this.addAction((EventListener<MouseEvent>)((EventListener)e -> callback.getCommand().execute()), this.constants.Reschedule());
            }
        } else {
            this.actionsItems.getClassList().add("hidden");
        }
        String id = Document.get().createUniqueId();
        this.label.setAttribute("href", "#timer-instance-" + id);
        this.details.id = "timer-instance-" + id;
    }

    public void addAction(EventListener<MouseEvent> onclick, String label) {
        HTMLElement a = Window.getDocument().createElement("a");
        a.setTextContent(label);
        a.setOnclick(onclick);
        HTMLElement li = Window.getDocument().createElement("li");
        li.appendChild((Node)a);
        this.actionsItems.appendChild((Node)li);
    }
}

