/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.definition.list;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.cellview.client.Column;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.list.AbstractMultiGridView;
import org.jbpm.workbench.common.client.list.ListTable;
import org.jbpm.workbench.common.client.util.ConditionalAction;
import org.jbpm.workbench.common.client.util.ConditionalKebabActionCell;
import org.jbpm.workbench.common.preferences.ManagePreferences;
import org.jbpm.workbench.pr.client.editors.definition.list.ProcessDefinitionListPresenter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.model.ProcessSummary;
import org.uberfire.ext.widgets.table.client.ColumnMeta;

@Dependent
@Templated(value="/org/jbpm/workbench/common/client/list/AbstractMultiGridView.html", stylesheet="/org/jbpm/workbench/common/client/resources/css/kie-manage.less")
public class ProcessDefinitionListViewImpl
extends AbstractMultiGridView<ProcessSummary, ProcessDefinitionListPresenter>
implements ProcessDefinitionListPresenter.ProcessDefinitionListView {
    private Constants constants = Constants.INSTANCE;
    @Inject
    protected ManagePreferences preferences;
    @Inject
    protected ManagedInstance<ConditionalKebabActionCell> conditionalKebabActionCell;

    public void displayBlockingError(String summary, String content) {
        this.column.classList.add(new String[]{"hidden"});
        this.alert.getElement().classList.remove(new String[]{"hidden"});
        this.alert.setSummary(summary);
        this.alert.setDescription(content);
    }

    public void clearBlockingError() {
        this.alert.getElement().classList.add(new String[]{"hidden"});
        this.alert.setSummary("");
        this.alert.setDescription("");
        this.column.classList.remove(new String[]{"hidden"});
    }

    public void initColumns(ListTable<ProcessSummary> extendedPagedTable) {
        Column processNameColumn = this.initProcessNameColumn();
        Column versionColumn = this.initVersionColumn();
        Column deploymentColumn = this.initDeploymentColumn();
        ColumnMeta actionsColumnMeta = this.initActionsColumn();
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        columnMetas.add(new ColumnMeta(processNameColumn, this.constants.Name()));
        columnMetas.add(new ColumnMeta(versionColumn, this.constants.Version()));
        columnMetas.add(new ColumnMeta(deploymentColumn, this.constants.Deployment_Name()));
        columnMetas.add(actionsColumnMeta);
        extendedPagedTable.addSelectionIgnoreColumn(actionsColumnMeta.getColumn());
        extendedPagedTable.addColumns(columnMetas);
        extendedPagedTable.setColumnWidth(actionsColumnMeta.getColumn(), 175.0, Style.Unit.PX);
        extendedPagedTable.getColumnSortList().push(processNameColumn);
    }

    public String getEmptyTableCaption() {
        return this.constants.No_Process_Definitions_Found();
    }

    public List<String> getInitColumns() {
        ArrayList<String> initColumns = new ArrayList<String>();
        initColumns.add("ProcessName");
        initColumns.add("ProcessVersion");
        initColumns.add("Project");
        initColumns.add("Actions");
        return initColumns;
    }

    public List<String> getBannedColumns() {
        ArrayList<String> bannedColumns = new ArrayList<String>();
        bannedColumns.add("ProcessName");
        bannedColumns.add("Actions");
        return bannedColumns;
    }

    private Column initProcessNameColumn() {
        Column<ProcessSummary, String> processNameColumn = new Column<ProcessSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessSummary object) {
                return object.getProcessDefName();
            }
        };
        processNameColumn.setSortable(true);
        processNameColumn.setDefaultSortAscending(false);
        processNameColumn.setDataStoreName("ProcessName");
        return processNameColumn;
    }

    private Column initVersionColumn() {
        Column<ProcessSummary, String> versionColumn = new Column<ProcessSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessSummary object) {
                return object.getVersion();
            }
        };
        versionColumn.setSortable(true);
        versionColumn.setDataStoreName("ProcessVersion");
        return versionColumn;
    }

    private Column initDeploymentColumn() {
        Column<ProcessSummary, String> deploymentColumn = new Column<ProcessSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessSummary object) {
                return object.getDeploymentId();
            }
        };
        deploymentColumn.setSortable(true);
        deploymentColumn.setDataStoreName("Project");
        return deploymentColumn;
    }

    protected List<ConditionalAction<ProcessSummary>> getConditionalActions() {
        return Arrays.asList(new ConditionalAction(this.constants.Start(), processSummary -> ((ProcessDefinitionListPresenter)this.presenter).openGenericForm(processSummary.getProcessDefId(), processSummary.getDeploymentId(), processSummary.getProcessDefName(), processSummary.isDynamic()), ((ProcessDefinitionListPresenter)this.presenter).getStartCondition(), Boolean.valueOf(false)), new ConditionalAction(this.constants.View_Process_Instances(), processSummary -> ((ProcessDefinitionListPresenter)this.presenter).viewProcessInstances(processSummary.getProcessDefId()), ((ProcessDefinitionListPresenter)this.presenter).getViewProcessInstanceActionCondition(), Boolean.valueOf(true)));
    }

    protected boolean hasBulkActions() {
        return false;
    }
}

