/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.bpmn2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.kie.api.KieServices;
import org.kie.api.builder.KieScanner;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.command.KieCommands;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.internal.runtime.Cacheable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessRuleTaskHandler
extends AbstractLogOrThrowWorkItemHandler
implements Cacheable {
    private static final Logger logger = LoggerFactory.getLogger(BusinessRuleTaskHandler.class);
    protected static final String STATELESS_TYPE = "stateless";
    protected static final String STATEFULL_TYPE = "statefull";
    protected static final String DRL_LANG = "DRL";
    protected static final String DMN_LANG = "DMN";
    private KieServices kieServices = KieServices.get();
    private KieCommands commandsFactory = this.kieServices.getCommands();
    private KieContainer kieContainer;
    private KieScanner kieScanner;

    public BusinessRuleTaskHandler(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, -1L);
    }

    public BusinessRuleTaskHandler(String groupId, String artifactId, String version, long scannerInterval) {
        logger.debug("About to create KieContainer for {}, {}, {} with scanner interval {}", new Object[]{groupId, artifactId, version, scannerInterval});
        this.kieContainer = this.kieServices.newKieContainer(this.kieServices.newReleaseId(groupId, artifactId, version));
        if (scannerInterval > 0L) {
            this.kieScanner = this.kieServices.newKieScanner(this.kieContainer);
            this.kieScanner.start(scannerInterval);
            logger.debug("Scanner started for {} with poll interval set to {}", (Object)this.kieContainer, (Object)scannerInterval);
        }
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(workItem.getParameters());
        String language = (String)parameters.remove("Language");
        if (language == null) {
            language = DRL_LANG;
        }
        String kieSessionName = (String)parameters.remove("KieSessionName");
        String kieSessionType = (String)parameters.remove("KieSessionType");
        if (kieSessionType == null) {
            kieSessionType = STATELESS_TYPE;
        }
        HashMap<String, Object> results = new HashMap<String, Object>();
        try {
            logger.debug("Facts to be inserted into working memory {}", parameters);
            if (DRL_LANG.equalsIgnoreCase(language)) {
                if (STATEFULL_TYPE.equalsIgnoreCase(kieSessionType)) {
                    this.handleStatefull(workItem, kieSessionName, parameters, results);
                } else {
                    this.handleStateless(workItem, kieSessionName, parameters, results);
                }
            } else if (DMN_LANG.equalsIgnoreCase(language)) {
                this.handleDMN(parameters, results);
            } else {
                throw new IllegalArgumentException("Not supported language type " + language);
            }
            logger.debug("Facts retrieved from working memory {}", results);
            manager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    public void close() {
        if (this.kieScanner != null) {
            this.kieScanner.shutdown();
            logger.debug("Scanner shutdown for kie container {}", (Object)this.kieContainer);
        }
        this.kieContainer.dispose();
    }

    protected void handleStatefull(WorkItem workItem, String kieSessionName, Map<String, Object> parameters, Map<String, Object> results) {
        logger.debug("Evaluating rules in statefull session with name {}", (Object)kieSessionName);
        HashMap<String, FactHandle> factHandles = new HashMap<String, FactHandle>();
        KieSession kieSession = this.kieContainer.newKieSession(kieSessionName);
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String inputKey = workItem.getId() + "_" + entry.getKey();
            factHandles.put(inputKey, kieSession.insert(entry.getValue()));
        }
        int fired = kieSession.fireAllRules();
        logger.debug("{} rules fired", (Object)fired);
        for (Map.Entry entry : factHandles.entrySet()) {
            Object object = kieSession.getObject((FactHandle)entry.getValue());
            String key = ((String)entry.getKey()).replaceAll(workItem.getId() + "_", "");
            results.put(key, object);
            kieSession.delete((FactHandle)entry.getValue());
        }
        factHandles.clear();
    }

    protected void handleStateless(WorkItem workItem, String kieSessionName, Map<String, Object> parameters, Map<String, Object> results) {
        logger.debug("Evaluating rules in stateless session with name {}", (Object)kieSessionName);
        StatelessKieSession kieSession = this.kieContainer.newStatelessKieSession(kieSessionName);
        ArrayList<Command> commands = new ArrayList<Command>();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String inputKey = workItem.getId() + "_" + entry.getKey();
            commands.add(this.commandsFactory.newInsert(entry.getValue(), inputKey, true, null));
        }
        commands.add(this.commandsFactory.newFireAllRules("Fired"));
        BatchExecutionCommand executionCommand = this.commandsFactory.newBatchExecution(commands);
        ExecutionResults executionResults = (ExecutionResults)kieSession.execute((Command)executionCommand);
        logger.debug("{} rules fired", executionResults.getValue("Fired"));
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String inputKey = workItem.getId() + "_" + entry.getKey();
            String key = entry.getKey().replaceAll(workItem.getId() + "_", "");
            results.put(key, executionResults.getValue(inputKey));
        }
    }

    protected void handleDMN(Map<String, Object> parameters, Map<String, Object> results) {
        String namespace = (String)parameters.remove("Namespace");
        String model = (String)parameters.remove("Model");
        String decision = (String)parameters.remove("Decision");
        DMNRuntime runtime = (DMNRuntime)this.kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        DMNModel dmnModel = runtime.getModel(namespace, model);
        if (dmnModel == null) {
            throw new IllegalArgumentException("DMN model '" + model + "' not found with namespace '" + namespace + "'");
        }
        DMNResult dmnResult = null;
        DMNContext context = runtime.newContext();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            context.set(entry.getKey(), entry.getValue());
        }
        dmnResult = decision != null && !decision.isEmpty() ? runtime.evaluateDecisionByName(dmnModel, decision, context) : runtime.evaluateAll(dmnModel, context);
        if (dmnResult.hasErrors()) {
            String errors = dmnResult.getMessages(new DMNMessage.Severity[]{DMNMessage.Severity.ERROR}).stream().map(message -> message.toString()).collect(Collectors.joining(", "));
            throw new RuntimeException("DMN result errors:: " + errors);
        }
        results.putAll(dmnResult.getContext().getAll());
    }

    public KieContainer getKieContainer() {
        return this.kieContainer;
    }
}

