/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.bpmn2;

import java.util.HashMap;
import java.util.Properties;
import javax.xml.ws.Endpoint;
import org.drools.compiler.compiler.ProcessBuilderFactory;
import org.drools.compiler.compiler.ProcessBuilderFactoryService;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.runtime.process.ProcessRuntimeFactory;
import org.drools.core.runtime.process.ProcessRuntimeFactoryService;
import org.jbpm.bpmn2.handler.WorkItemHandlerRuntimeException;
import org.jbpm.process.builder.ProcessBuilderFactoryServiceImpl;
import org.jbpm.process.instance.ProcessRuntimeFactoryServiceImpl;
import org.jbpm.process.workitem.bpmn2.CountDownProcessEventListener;
import org.jbpm.process.workitem.bpmn2.ServiceTaskHandler;
import org.jbpm.process.workitem.bpmn2.SimpleService;
import org.jbpm.process.workitem.webservice.WebServiceWorkItemHandler;
import org.jbpm.test.AbstractBaseTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxWSServiceTaskTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(JaxWSServiceTaskTest.class);
    private Endpoint endpoint;
    private Endpoint endpoint2;
    private SimpleService service;

    @Before
    public void setUp() {
        this.startWebService();
    }

    @After
    public void tearDown() {
        this.stopWebService();
    }

    @Test
    public void testServiceInvocation() throws Exception {
        KieBase kbase = JaxWSServiceTaskTest.readKnowledgeBase();
        KieSession ksession = JaxWSServiceTaskTest.createSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)new ServiceTaskHandler(ksession));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        params.put("mode", "sync");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("WebServiceTask", params);
        String variable = (String)processInstance.getVariable("s");
        JaxWSServiceTaskTest.assertEquals((Object)"Hello john", (Object)variable);
        JaxWSServiceTaskTest.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test(timeout=10000L)
    public void testAsyncServiceInvocation() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("Service Task", 1);
        KieBase kbase = JaxWSServiceTaskTest.readKnowledgeBase();
        KieSession ksession = JaxWSServiceTaskTest.createSession(kbase);
        ksession.addEventListener((ProcessEventListener)countDownListener);
        ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)new ServiceTaskHandler(ksession));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        params.put("mode", "async");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("WebServiceTask", params);
        logger.info("Service invoked async...waiting to get reponse back");
        countDownListener.waitTillCompleted();
        String variable = (String)processInstance.getVariable("s");
        JaxWSServiceTaskTest.assertEquals((Object)"Hello john", (Object)variable);
        JaxWSServiceTaskTest.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testOneWayServiceInvocation() throws Exception {
        KieBase kbase = JaxWSServiceTaskTest.readKnowledgeBase();
        KieSession ksession = JaxWSServiceTaskTest.createSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)new ServiceTaskHandler(ksession));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        params.put("mode", "oneway");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("WebServiceTask", params);
        logger.info("Execution finished");
        String variable = (String)processInstance.getVariable("s");
        JaxWSServiceTaskTest.assertNull((Object)variable);
        JaxWSServiceTaskTest.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testServiceInvocationWithErrorHandled() throws Exception {
        KieBase kbase = JaxWSServiceTaskTest.readKnowledgeBase();
        KieSession ksession = JaxWSServiceTaskTest.createSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)new ServiceTaskHandler(ksession));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        params.put("mode", "sync");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("WebServiceTaskError", params);
        JaxWSServiceTaskTest.assertEquals((long)2L, (long)processInstance.getState());
        Object error = processInstance.getVariable("exception");
        JaxWSServiceTaskTest.assertNotNull((Object)error);
        JaxWSServiceTaskTest.assertTrue((boolean)(error instanceof WorkItemHandlerRuntimeException));
    }

    @Test(timeout=10000L)
    public void testServiceInvocationProcessWith2WSImports() throws Exception {
        KieBase kbase = JaxWSServiceTaskTest.readKnowledgeBase();
        KieSession ksession = JaxWSServiceTaskTest.createSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)new ServiceTaskHandler(ksession));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        params.put("mode", "sync");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("org.jboss.qa.jbpm.CallWS", params);
        String variable = (String)processInstance.getVariable("s");
        JaxWSServiceTaskTest.assertEquals((Object)"Hello john", (Object)variable);
        JaxWSServiceTaskTest.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test(timeout=10000L)
    public void testServiceInvocationProcessWith2WSImportsWSHandler() throws Exception {
        KieBase kbase = JaxWSServiceTaskTest.readKnowledgeBase();
        KieSession ksession = JaxWSServiceTaskTest.createSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)new WebServiceWorkItemHandler(ksession));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        params.put("mode", "sync");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("org.jboss.qa.jbpm.CallWS", params);
        String variable = (String)processInstance.getVariable("s");
        JaxWSServiceTaskTest.assertEquals((Object)"Hello john", (Object)variable);
        JaxWSServiceTaskTest.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testServiceInvocationWithMultipleParams() throws Exception {
        KieBase kbase = JaxWSServiceTaskTest.readKnowledgeBase();
        KieSession ksession = JaxWSServiceTaskTest.createSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)new WebServiceWorkItemHandler(ksession));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("s", new String[]{"john", "doe"});
        params.put("mode", "sync");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("multiparamws", params);
        String variable = (String)processInstance.getVariable("s2");
        JaxWSServiceTaskTest.assertEquals((Object)"Hello doe, john", (Object)variable);
        JaxWSServiceTaskTest.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testServiceInvocationWithMultipleIntParams() throws Exception {
        KieBase kbase = JaxWSServiceTaskTest.readKnowledgeBase();
        KieSession ksession = JaxWSServiceTaskTest.createSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)new WebServiceWorkItemHandler(ksession));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("s", new int[]{2, 3});
        params.put("mode", "sync");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("multiparamws-int", params);
        String variable = (String)processInstance.getVariable("s2");
        JaxWSServiceTaskTest.assertEquals((Object)"Hello 2, 3", (Object)variable);
        JaxWSServiceTaskTest.assertEquals((long)2L, (long)processInstance.getState());
    }

    @Test
    public void testOneWayServiceInvocationProcessWSHandler() throws Exception {
        KieBase kbase = JaxWSServiceTaskTest.readKnowledgeBase();
        KieSession ksession = JaxWSServiceTaskTest.createSession(kbase);
        ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)new WebServiceWorkItemHandler(ksession));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        params.put("mode", "oneway");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("org.jboss.qa.jbpm.CallWS", params);
        logger.info("Execution finished");
        String variable = (String)processInstance.getVariable("s");
        JaxWSServiceTaskTest.assertNull((Object)variable);
        JaxWSServiceTaskTest.assertEquals((long)2L, (long)processInstance.getState());
    }

    private void startWebService() {
        this.service = new SimpleService();
        this.endpoint = Endpoint.publish((String)"http://127.0.0.1:9876/HelloService/greeting", (Object)this.service);
        this.endpoint2 = Endpoint.publish((String)"http://127.0.0.1:9877/SecondService/greeting", (Object)this.service);
    }

    private void stopWebService() {
        this.endpoint.stop();
        this.endpoint2.stop();
    }

    private static KieBase readKnowledgeBase() throws Exception {
        ProcessBuilderFactory.setProcessBuilderFactoryService((ProcessBuilderFactoryService)new ProcessBuilderFactoryServiceImpl());
        ProcessRuntimeFactory.setProcessRuntimeFactoryService((ProcessRuntimeFactoryService)new ProcessRuntimeFactoryServiceImpl());
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-JaxWSServiceTask.bpmn2"), ResourceType.BPMN2);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-JaxWSServiceTaskWithErrorBoundaryEvent.bpmn2"), ResourceType.BPMN2);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-TwoWebServiceImports.bpmn"), ResourceType.BPMN2);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-MultipleParamsWebService.bpmn"), ResourceType.BPMN2);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-MultipleIntParamsWebService.bpmn"), ResourceType.BPMN2);
        return kbuilder.newKieBase();
    }

    private static KieSession createSession(KieBase kbase) {
        Properties properties = new Properties();
        properties.put("drools.processInstanceManagerFactory", "org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory");
        properties.put("drools.processSignalManagerFactory", "org.jbpm.process.instance.event.DefaultSignalManagerFactory");
        KieSessionConfiguration config = KnowledgeBaseFactory.newKnowledgeSessionConfiguration((Properties)properties);
        return kbase.newKieSession(config, EnvironmentFactory.newEnvironment());
    }
}

