/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.bpmn2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jbpm.process.instance.impl.util.TypeTransformer;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.KieServices;
import org.kie.api.builder.KieScanner;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.command.KieCommands;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.NodeInstanceContainer;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.internal.runtime.Cacheable;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRuleTaskHandler
extends AbstractLogOrThrowWorkItemHandler
implements Cacheable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRuleTaskHandler.class);
    protected static final String STATELESS_TYPE = "stateless";
    protected static final String STATEFULL_TYPE = "statefull";
    protected static final String STATEFUL_TYPE = "stateful";
    protected static final String DRL_LANG = "DRL";
    protected static final String DMN_LANG = "DMN";
    private KieServices kieServices = KieServices.get();
    private KieCommands commandsFactory = this.kieServices.getCommands();
    private KieContainer kieContainer;
    private KieScanner kieScanner;
    private ClassLoader classLoader;
    private RuntimeManager runtimeManager;
    private TypeTransformer typeTransformer;

    public AbstractRuleTaskHandler(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, -1L);
    }

    public AbstractRuleTaskHandler(String groupId, String artifactId, String version, long scannerInterval) {
        this(groupId, artifactId, version, scannerInterval, null, null);
    }

    public AbstractRuleTaskHandler(String groupId, String artifactId, String version, long scannerInterval, ClassLoader classLoader, RuntimeManager runtimeManager) {
        logger.debug("About to create KieContainer for {}, {}, {} with scanner interval {}", new Object[]{groupId, artifactId, version, scannerInterval});
        this.kieContainer = this.kieServices.newKieContainer(this.kieServices.newReleaseId(groupId, artifactId, version));
        this.classLoader = classLoader;
        this.runtimeManager = runtimeManager;
        this.typeTransformer = new TypeTransformer(classLoader);
        if (scannerInterval > 0L) {
            this.kieScanner = this.kieServices.newKieScanner(this.kieContainer);
            this.kieScanner.start(scannerInterval);
            logger.debug("Scanner started for {} with poll interval set to {}", (Object)this.kieContainer, (Object)scannerInterval);
        }
    }

    public abstract String getRuleLanguage();

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(workItem.getParameters());
        String language = (String)parameters.remove("Language");
        if (language == null) {
            language = this.getRuleLanguage();
        }
        String kieSessionName = (String)parameters.remove("KieSessionName");
        String kieSessionType = (String)parameters.remove("KieSessionType");
        if (kieSessionType == null) {
            kieSessionType = STATELESS_TYPE;
        }
        HashMap<String, Object> results = new HashMap<String, Object>();
        try {
            logger.debug("Facts to be inserted into working memory {}", parameters);
            if (DRL_LANG.equalsIgnoreCase(language)) {
                if (STATEFULL_TYPE.equalsIgnoreCase(kieSessionType) || STATEFUL_TYPE.equalsIgnoreCase(kieSessionType)) {
                    this.handleStatefull(workItem, kieSessionName, parameters, results);
                } else {
                    this.handleStateless(workItem, kieSessionName, parameters, results);
                }
            } else if (DMN_LANG.equalsIgnoreCase(language)) {
                this.handleDMN(workItem, parameters, results);
            } else {
                throw new IllegalArgumentException("Not supported language type " + language);
            }
            logger.debug("Facts retrieved from working memory {}", results);
            manager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    public void setRuntimeManager(RuntimeManager runtimeManager) {
        this.runtimeManager = runtimeManager;
    }

    public void close() {
        if (this.kieScanner != null) {
            this.kieScanner.shutdown();
            logger.debug("Scanner shutdown for kie container {}", (Object)this.kieContainer);
        }
        this.kieContainer.dispose();
    }

    protected void handleStatefull(WorkItem workItem, String kieSessionName, Map<String, Object> parameters, Map<String, Object> results) {
        logger.debug("Evaluating rules in statefull session with name {}", (Object)kieSessionName);
        HashMap<String, FactHandle> factHandles = new HashMap<String, FactHandle>();
        KieSession kieSession = this.kieContainer.newKieSession(kieSessionName);
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String inputKey = workItem.getId() + "_" + entry.getKey();
            factHandles.put(inputKey, kieSession.insert(entry.getValue()));
        }
        int fired = kieSession.fireAllRules();
        logger.debug("{} rules fired", (Object)fired);
        for (Map.Entry entry : factHandles.entrySet()) {
            Object object = kieSession.getObject((FactHandle)entry.getValue());
            String key = ((String)entry.getKey()).replaceAll(workItem.getId() + "_", "");
            results.put(key, object);
            kieSession.delete((FactHandle)entry.getValue());
        }
        factHandles.clear();
    }

    protected void handleStateless(WorkItem workItem, String kieSessionName, Map<String, Object> parameters, Map<String, Object> results) {
        logger.debug("Evaluating rules in stateless session with name {}", (Object)kieSessionName);
        StatelessKieSession kieSession = this.kieContainer.newStatelessKieSession(kieSessionName);
        ArrayList<Command> commands = new ArrayList<Command>();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String inputKey = workItem.getId() + "_" + entry.getKey();
            commands.add(this.commandsFactory.newInsert(entry.getValue(), inputKey, true, null));
        }
        commands.add(this.commandsFactory.newFireAllRules("Fired"));
        BatchExecutionCommand executionCommand = this.commandsFactory.newBatchExecution(commands);
        ExecutionResults executionResults = (ExecutionResults)kieSession.execute((Command)executionCommand);
        logger.debug("{} rules fired", executionResults.getValue("Fired"));
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String inputKey = workItem.getId() + "_" + entry.getKey();
            String key = entry.getKey().replaceAll(workItem.getId() + "_", "");
            results.put(key, executionResults.getValue(inputKey));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDMN(WorkItem workItem, Map<String, Object> parameters, Map<String, Object> results) {
        String namespace = (String)parameters.remove("Namespace");
        String model = (String)parameters.remove("Model");
        String decision = (String)parameters.remove("Decision");
        DMNRuntime runtime = (DMNRuntime)this.kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        DMNModel dmnModel = runtime.getModel(namespace, model);
        if (dmnModel == null) {
            throw new IllegalArgumentException("DMN model '" + model + "' not found with namespace '" + namespace + "'");
        }
        DMNResult dmnResult = null;
        DMNContext context = runtime.newContext();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            context.set(entry.getKey(), entry.getValue());
        }
        dmnResult = decision != null && !decision.isEmpty() ? runtime.evaluateDecisionByName(dmnModel, decision, context) : runtime.evaluateAll(dmnModel, context);
        if (dmnResult.hasErrors()) {
            String errors = dmnResult.getMessages(new DMNMessage.Severity[]{DMNMessage.Severity.ERROR}).stream().map(message -> message.toString()).collect(Collectors.joining(", "));
            throw new RuntimeException("DMN result errors:: " + errors);
        }
        if (this.classLoader == null || this.runtimeManager == null) {
            results.putAll(dmnResult.getContext().getAll());
            return;
        }
        RuntimeEngine engine = this.runtimeManager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)workItem.getProcessInstanceId()));
        try {
            KieSession localksession = engine.getKieSession();
            WorkflowProcessInstance processInstance = (WorkflowProcessInstance)localksession.getProcessInstance(workItem.getProcessInstanceId());
            WorkItemNodeInstance nodeInstance = this.findNodeInstance(workItem.getId(), (NodeInstanceContainer)processInstance);
            WorkItemNode workItemNode = (WorkItemNode)nodeInstance.getNode();
            Map dataTypeOutputs = (Map)workItemNode.getMetaData("DataOutputs");
            Map decisionOutputData = dmnResult.getContext().getAll();
            HashMap<String, Object> outcome = new HashMap<String, Object>();
            if (!workItemNode.getOutAssociations().isEmpty()) {
                for (DataAssociation dataAssociation : workItemNode.getOutAssociations()) {
                    String targetOutputTask = (String)dataAssociation.getSources().get(0);
                    String targetTypeOutputTask = (String)dataTypeOutputs.get(targetOutputTask);
                    outcome.put(targetOutputTask, this.typeTransformer.transform(decisionOutputData.get(targetOutputTask), targetTypeOutputTask));
                }
                results.putAll(outcome);
            } else {
                results.putAll(dmnResult.getContext().getAll());
            }
        }
        catch (IOException | ClassNotFoundException e) {
            results.putAll(dmnResult.getContext().getAll());
        }
        finally {
            this.runtimeManager.disposeRuntimeEngine(engine);
        }
    }

    public KieContainer getKieContainer() {
        return this.kieContainer;
    }
}

